/*
 * Decompiled with CFR 0.152.
 */
package terracer;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import terracer.HouseNumberInputDialog;
import terracer.TerracerAction;

public class HouseNumberInputHandler
implements ChangeListener,
ItemListener,
ActionListener,
FocusListener {
    private TerracerAction terracerAction;
    private Way outline;
    private Way street;
    private Relation associatedStreet;
    private HouseNumberInputDialog dialog;

    public HouseNumberInputHandler(TerracerAction terracerAction, Way outline, Way street, Relation associatedStreet, String title) {
        this.terracerAction = terracerAction;
        this.outline = outline;
        this.street = street;
        this.associatedStreet = associatedStreet;
        this.dialog = new HouseNumberInputDialog(street, associatedStreet != null);
        this.dialog.addHandler(this);
        this.dialog.setVisible(true);
        this.dialog.setTitle(title);
    }

    private void validateInput() {
        boolean isOk = true;
        StringBuffer message = new StringBuffer();
        isOk = isOk && this.checkNumberOrder(message);
        isOk = isOk && this.checkSegmentsFromHousenumber(message);
        isOk = isOk && this.checkSegments(message);
        isOk = isOk && this.checkNumberStringField(this.dialog.lo, I18n.tr((String)"Lowest number"), message);
        isOk = isOk && this.checkNumberStringField(this.dialog.hi, I18n.tr((String)"Highest number"), message);
        boolean bl = isOk = isOk && this.checkNumberStringField(this.dialog.segments, I18n.tr((String)"Segments"), message);
        if (isOk) {
            this.dialog.okButton.setEnabled(true);
            this.dialog.messageLabel.setForeground(Color.black);
            this.dialog.messageLabel.setText(I18n.tr((String)HouseNumberInputDialog.DEFAULT_MESSAGE));
        } else {
            this.dialog.okButton.setEnabled(false);
            this.dialog.messageLabel.setForeground(Color.red);
            this.dialog.messageLabel.setText(message.toString());
        }
    }

    private boolean checkNumberOrder(StringBuffer message) {
        if (this.numberFrom() != null && this.numberTo() != null && this.numberFrom() > this.numberTo()) {
            this.appendMessageNewLine(message);
            message.append(I18n.tr((String)"Lowest housenumber cannot be higher than highest housenumber"));
            return false;
        }
        return true;
    }

    private boolean checkSegmentsFromHousenumber(StringBuffer message) {
        this.dialog.segments.setEditable(true);
        if (this.numberFrom() != null && this.numberTo() != null) {
            int segments = this.numberTo() - this.numberFrom();
            if (segments % this.stepSize() != 0) {
                this.appendMessageNewLine(message);
                message.append(I18n.tr((String)"Housenumbers do not match odd/even setting"));
                return false;
            }
            int steps = segments / this.stepSize();
            this.dialog.segments.setText(String.valueOf(++steps));
            this.dialog.segments.setEditable(false);
        }
        return true;
    }

    private boolean checkSegments(StringBuffer message) {
        if (this.segments() == null || this.segments() < 1) {
            this.appendMessageNewLine(message);
            message.append(I18n.tr((String)"Segment must be a number greater 1"));
            return false;
        }
        return true;
    }

    private boolean checkNumberStringField(JTextField field, String label, StringBuffer message) {
        String content = field.getText();
        if (content != null && content.length() != 0) {
            try {
                int i = Integer.parseInt(content);
                if (i < 0) {
                    this.appendMessageNewLine(message);
                    message.append(I18n.tr((String)"{0} must be greater than 0", (Object[])new Object[]{label}));
                    return false;
                }
            }
            catch (NumberFormatException e) {
                this.appendMessageNewLine(message);
                message.append(I18n.tr((String)"{0} is not a number", (Object[])new Object[]{label}));
                return false;
            }
        }
        return true;
    }

    private void appendMessageNewLine(StringBuffer message) {
        if (message.length() > 0) {
            message.append("\n");
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.validateInput();
    }

    public void itemStateChanged(ItemEvent e) {
        this.validateInput();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            JButton button = (JButton)e.getSource();
            if ("OK".equals(button.getName())) {
                this.saveValues();
                this.terracerAction.terraceBuilding(this.outline, this.street, this.associatedStreet, this.segments(), this.numberFrom(), this.numberTo(), this.stepSize(), this.streetName(), this.doHandleRelation(), this.doDeleteOutline());
                this.dialog.dispose();
            } else if ("CANCEL".equals(button.getName())) {
                this.dialog.dispose();
            }
        } else {
            this.validateInput();
        }
    }

    public int stepSize() {
        return this.dialog.interpolation.getSelectedItem().equals(I18n.tr((String)"All")) ? 1 : 2;
    }

    public Integer segments() {
        try {
            return Integer.parseInt(this.dialog.segments.getText());
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public Integer numberFrom() {
        try {
            return Integer.parseInt(this.dialog.lo.getText());
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public Integer numberTo() {
        try {
            return Integer.parseInt(this.dialog.hi.getText());
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public String streetName() {
        if (this.street != null) {
            return null;
        }
        Object selected = this.dialog.streetComboBox.getSelectedItem();
        if (selected == null) {
            return null;
        }
        String name = selected.toString();
        if (name.length() == 0) {
            return null;
        }
        return name;
    }

    public boolean doHandleRelation() {
        return this.dialog.handleRelationCheckBox.isSelected();
    }

    public boolean doDeleteOutline() {
        return this.dialog.deleteOutlineCheckBox.isSelected();
    }

    public void focusGained(FocusEvent e) {
        this.validateInput();
    }

    public void focusLost(FocusEvent e) {
        this.validateInput();
    }

    public void saveValues() {
        Main.pref.put("plugins.terracer.handle_relation", this.doHandleRelation());
        Main.pref.put("plugins.terracer.delete_outline", this.doDeleteOutline());
    }
}

