/*
 * Decompiled with CFR 0.152.
 */
package public_transport;

import java.util.Collection;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import public_transport.WaypointTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaypointsNameCommand
extends Command {
    private int workingLine = 0;
    private WaypointTableModel waypointTM = null;
    private String oldName = null;
    private String name = null;
    private String oldShelter = null;
    private String shelter = null;

    public WaypointsNameCommand(WaypointTableModel waypointTM, int workingLine, String name, String shelter) {
        this.waypointTM = waypointTM;
        this.workingLine = workingLine;
        if (waypointTM.nodes.elementAt(workingLine) != null) {
            this.oldName = waypointTM.nodes.elementAt(workingLine).get("name");
            this.oldShelter = waypointTM.nodes.elementAt(workingLine).get("shelter");
        }
        this.name = name;
        this.shelter = shelter;
        if ("".equals(shelter)) {
            shelter = null;
        }
    }

    public boolean executeCommand() {
        if (this.waypointTM.nodes.elementAt(this.workingLine) != null) {
            this.waypointTM.nodes.elementAt(this.workingLine).put("name", this.name);
            this.waypointTM.nodes.elementAt(this.workingLine).put("shelter", this.shelter);
            this.waypointTM.inEvent = true;
            this.waypointTM.setValueAt(this.name, this.workingLine, 1);
            if (this.shelter == null) {
                this.waypointTM.setValueAt("", this.workingLine, 2);
            } else {
                this.waypointTM.setValueAt(this.shelter, this.workingLine, 2);
            }
            this.waypointTM.inEvent = false;
        }
        return true;
    }

    public void undoCommand() {
        if (this.waypointTM.nodes.elementAt(this.workingLine) != null) {
            this.waypointTM.nodes.elementAt(this.workingLine).put("name", this.oldName);
            this.waypointTM.nodes.elementAt(this.workingLine).put("shelter", this.oldShelter);
            this.waypointTM.inEvent = true;
            this.waypointTM.setValueAt(this.oldName, this.workingLine, 1);
            if (this.oldShelter == null) {
                this.waypointTM.setValueAt("", this.workingLine, 2);
            } else {
                this.waypointTM.setValueAt(this.oldShelter, this.workingLine, 2);
            }
            this.waypointTM.inEvent = false;
        }
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    public MutableTreeNode description() {
        return new DefaultMutableTreeNode("public_transport.Waypoints.EditName");
    }
}

