/*
 * Decompiled with CFR 0.152.
 */
package public_transport;

import java.util.Collection;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import public_transport.StopImporterAction;
import public_transport.WaypointTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaypointsDetachCommand
extends Command {
    private Vector<Integer> workingLines = null;
    private Vector<Node> nodesForUndo = null;
    private WaypointTableModel waypointTM = null;

    public WaypointsDetachCommand(StopImporterAction controller) {
        int i;
        this.waypointTM = controller.getWaypointTableModel();
        this.workingLines = new Vector();
        this.nodesForUndo = new Vector();
        int[] selectedLines = controller.getDialog().getWaypointsTable().getSelectedRows();
        Vector<Integer> consideredLines = new Vector<Integer>();
        if (selectedLines.length > 0) {
            for (i = 0; i < selectedLines.length; ++i) {
                consideredLines.add(selectedLines[i]);
            }
        } else {
            for (i = 0; i < this.waypointTM.getRowCount(); ++i) {
                consideredLines.add(new Integer(i));
            }
        }
        for (i = 0; i < consideredLines.size(); ++i) {
            if (this.waypointTM.nodes.elementAt((Integer)consideredLines.elementAt(i)) == null) continue;
            this.workingLines.add((Integer)consideredLines.elementAt(i));
        }
    }

    public boolean executeCommand() {
        this.nodesForUndo.clear();
        for (int i = 0; i < this.workingLines.size(); ++i) {
            int j = this.workingLines.elementAt(i);
            Node node = this.waypointTM.nodes.elementAt(j);
            this.nodesForUndo.add(node);
            this.waypointTM.nodes.set(j, null);
        }
        return true;
    }

    public void undoCommand() {
        for (int i = 0; i < this.workingLines.size(); ++i) {
            int j = this.workingLines.elementAt(i);
            Node node = this.nodesForUndo.elementAt(i);
            this.waypointTM.nodes.set(j, node);
        }
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    public MutableTreeNode description() {
        return new DefaultMutableTreeNode("public_transport.Waypoints.Detach");
    }
}

