/*
 * Decompiled with CFR 0.152.
 */
package public_transport;

import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.Node;
import public_transport.StopImporterAction;
import public_transport.WaypointsNameCommand;

public class WaypointTableModel
extends DefaultTableModel
implements TableModelListener {
    private StopImporterAction controller = null;
    public boolean inEvent = false;
    public Vector<Node> nodes = new Vector();
    public Vector<LatLon> coors = new Vector();

    public WaypointTableModel(StopImporterAction controller) {
        this.controller = controller;
        this.addColumn("Time");
        this.addColumn("Stopname");
        this.addTableModelListener(this);
    }

    public boolean isCellEditable(int row, int column) {
        return column == 1;
    }

    public void addRow(Object[] obj) {
        throw new UnsupportedOperationException();
    }

    public void insertRow(int insPos, Object[] obj) {
        throw new UnsupportedOperationException();
    }

    public void addRow(WayPoint wp) {
        this.insertRow(-1, wp);
    }

    public void insertRow(int insPos, WayPoint wp) {
        Object[] buf = new String[]{"", ""};
        buf[0] = wp.getString("time");
        if (buf[0] == null) {
            buf[0] = "";
        }
        buf[1] = wp.getString("name");
        if (buf[1] == null) {
            buf[1] = "";
        }
        Node node = this.controller.createNode(wp.getCoor(), buf[1]);
        if (insPos == -1) {
            this.nodes.addElement(node);
            this.coors.addElement(wp.getCoor());
            super.addRow(buf);
        } else {
            this.nodes.insertElementAt(node, insPos);
            this.coors.insertElementAt(wp.getCoor(), insPos);
            super.insertRow(insPos, buf);
        }
    }

    public void clear() {
        this.nodes.clear();
        super.setRowCount(0);
    }

    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 0) {
            if (this.inEvent) {
                return;
            }
            Main.main.undoRedo.add((Command)new WaypointsNameCommand(this, e.getFirstRow(), (String)this.getValueAt(e.getFirstRow(), 1)));
        }
    }
}

