/*
 * Decompiled with CFR 0.152.
 */
package public_transport;

import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import public_transport.StopImporterAction;
import public_transport.StopImporterDialog;
import public_transport.TrackStoplistTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackStoplistSortCommand
extends Command {
    private TrackStoplistTableModel stoplistTM = null;
    private Vector<Vector<Object>> tableDataModel = null;
    private Vector<Node> nodes = null;
    private Vector<String> times = null;
    private Vector<Integer> workingLines = null;
    private int insPos;
    private String stopwatchStart;

    public TrackStoplistSortCommand(StopImporterAction controller) {
        this.stoplistTM = controller.getCurrentTrack().stoplistTM;
        this.workingLines = new Vector();
        this.insPos = controller.getDialog().getStoplistTable().getSelectedRow();
        this.stopwatchStart = controller.getCurrentTrack().stopwatchStart;
        int[] selectedLines = controller.getDialog().getStoplistTable().getSelectedRows();
        if (selectedLines.length > 0) {
            for (int i = 0; i < selectedLines.length; ++i) {
                this.workingLines.add(selectedLines[i]);
            }
        } else {
            for (int i = 0; i < this.stoplistTM.getRowCount(); ++i) {
                this.workingLines.add(new Integer(i));
            }
        }
    }

    public boolean executeCommand() {
        this.tableDataModel = (Vector)this.stoplistTM.getDataVector().clone();
        this.nodes = (Vector)this.stoplistTM.getNodes().clone();
        this.times = (Vector)this.stoplistTM.getTimes().clone();
        Vector<NodeSortEntry> nodesToSort = new Vector<NodeSortEntry>();
        for (int i = this.workingLines.size() - 1; i >= 0; --i) {
            int j = this.workingLines.elementAt(i);
            nodesToSort.add(new NodeSortEntry(this.stoplistTM.nodeAt(j), (String)this.stoplistTM.getValueAt(j, 0), (String)this.stoplistTM.getValueAt(j, 1), StopImporterDialog.parseTime(this.stopwatchStart)));
            this.stoplistTM.removeRow(j);
        }
        Collections.sort(nodesToSort);
        int insPos = this.insPos;
        for (NodeSortEntry nse : nodesToSort) {
            this.stoplistTM.insertRow(insPos, nse.node, nse.time, nse.name);
            if (insPos < 0) continue;
            ++insPos;
        }
        return true;
    }

    public void undoCommand() {
        this.stoplistTM.setDataVector(this.tableDataModel);
        this.stoplistTM.setNodes(this.nodes);
        this.stoplistTM.setTimes(this.times);
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    public MutableTreeNode description() {
        return new DefaultMutableTreeNode("public_transport.TrackStoplist.Sort");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeSortEntry
    implements Comparable<NodeSortEntry> {
        public Node node = null;
        public String time = null;
        public String name = null;
        public double startTime = 0.0;

        public NodeSortEntry(Node node, String time, String name, double startTime) {
            this.node = node;
            this.time = time;
            this.name = name;
        }

        @Override
        public int compareTo(NodeSortEntry nse) {
            double nseTime;
            double time = StopImporterDialog.parseTime(this.time);
            if (time - this.startTime > 43200.0) {
                time -= 86400.0;
            }
            if ((nseTime = StopImporterDialog.parseTime(nse.time)) - this.startTime > 43200.0) {
                nseTime -= 86400.0;
            }
            if (time < nseTime) {
                return -1;
            }
            if (time > nseTime) {
                return 1;
            }
            return 0;
        }
    }
}

