/*
 * Decompiled with CFR 0.152.
 */
package public_transport;

import java.util.Collection;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import public_transport.StopImporterAction;
import public_transport.TrackStoplistTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackStoplistDeleteCommand
extends Command {
    private Vector<Integer> workingLines = null;
    private Vector<NodeTimeName> nodesForUndo = null;
    private TrackStoplistTableModel stoplistTM = null;

    public TrackStoplistDeleteCommand(StopImporterAction controller) {
        this.stoplistTM = controller.getCurrentTrack().stoplistTM;
        this.workingLines = new Vector();
        this.nodesForUndo = new Vector();
        int[] selectedLines = controller.getDialog().getStoplistTable().getSelectedRows();
        if (selectedLines.length > 0) {
            for (int i = 0; i < selectedLines.length; ++i) {
                this.workingLines.add(selectedLines[i]);
            }
        } else {
            for (int i = 0; i < this.stoplistTM.getRowCount(); ++i) {
                this.workingLines.add(new Integer(i));
            }
        }
    }

    public boolean executeCommand() {
        this.nodesForUndo.clear();
        for (int i = this.workingLines.size() - 1; i >= 0; --i) {
            int j = this.workingLines.elementAt(i);
            Node node = this.stoplistTM.nodeAt(j);
            this.nodesForUndo.add(new NodeTimeName(node, (String)this.stoplistTM.getValueAt(j, 0), (String)this.stoplistTM.getValueAt(j, 1)));
            this.stoplistTM.removeRow(j);
            if (node == null) continue;
            Main.main.getCurrentDataSet().removePrimitive((PrimitiveId)node);
            node.setDeleted(true);
        }
        return true;
    }

    public void undoCommand() {
        for (int i = 0; i < this.workingLines.size(); ++i) {
            int j = this.workingLines.elementAt(i);
            NodeTimeName ntn = this.nodesForUndo.elementAt(this.workingLines.size() - i - 1);
            this.stoplistTM.insertRow(j, ntn.node, ntn.time, ntn.name);
            if (ntn.node == null) continue;
            ntn.node.setDeleted(false);
            Main.main.getCurrentDataSet().addPrimitive((OsmPrimitive)ntn.node);
        }
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    public MutableTreeNode description() {
        return new DefaultMutableTreeNode("public_transport.TrackStoplist.Delete");
    }

    private class NodeTimeName {
        public Node node;
        public String time;
        public String name;

        NodeTimeName(Node node, String time, String name) {
            this.node = node;
            this.time = time;
            this.name = name;
        }
    }
}

