/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipolygonTest
extends Test {
    protected static final int WRONG_MEMBER_TYPE = 1601;
    protected static final int WRONG_MEMBER_ROLE = 1602;
    protected static final int NON_CLOSED_WAY = 1603;
    protected static final int MISSING_OUTER_WAY = 1604;
    protected static final int INNER_WAY_OUTSIDE = 1605;
    protected static final int CROSSING_WAYS = 1606;
    private final List<List<Node>> nonClosedWays = new ArrayList<List<Node>>();

    public MultipolygonTest() {
        super(I18n.tr((String)"Multipolygon"), I18n.tr((String)"This test checks if multipolygons are valid"));
    }

    private List<List<Node>> joinWays(Collection<Way> ways) {
        ArrayList<List<Node>> result = new ArrayList<List<Node>>();
        ArrayList<Way> waysToJoin = new ArrayList<Way>();
        for (Way way : ways) {
            if (way.isClosed()) {
                result.add(way.getNodes());
                continue;
            }
            waysToJoin.add(way);
        }
        for (Multipolygon.JoinedWay jw : Multipolygon.joinWays(waysToJoin)) {
            if (!jw.isClosed()) {
                this.nonClosedWays.add(jw.getNodes());
                continue;
            }
            result.add(jw.getNodes());
        }
        return result;
    }

    private GeneralPath createPath(List<Node> nodes) {
        GeneralPath result = new GeneralPath();
        result.moveTo((float)nodes.get(0).getCoor().lat(), (float)nodes.get(0).getCoor().lon());
        for (int i = 1; i < nodes.size(); ++i) {
            Node n = nodes.get(i);
            result.lineTo((float)n.getCoor().lat(), (float)n.getCoor().lon());
        }
        return result;
    }

    private List<GeneralPath> createPolygons(List<List<Node>> joinedWays) {
        ArrayList<GeneralPath> result = new ArrayList<GeneralPath>();
        for (List<Node> way : joinedWays) {
            result.add(this.createPath(way));
        }
        return result;
    }

    private Multipolygon.PolyData.Intersection getPolygonIntersection(GeneralPath outer, List<Node> inner) {
        boolean inside = false;
        boolean outside = false;
        for (Node n : inner) {
            boolean contains = outer.contains(n.getCoor().lat(), n.getCoor().lon());
            if (!((inside |= contains) & (outside |= !contains))) continue;
            return Multipolygon.PolyData.Intersection.CROSSING;
        }
        return inside ? Multipolygon.PolyData.Intersection.INSIDE : Multipolygon.PolyData.Intersection.OUTSIDE;
    }

    @Override
    public void visit(Relation r) {
        this.nonClosedWays.clear();
        if ("multipolygon".equals(r.get("type"))) {
            this.checkMembersAndRoles(r);
            Multipolygon polygon = new Multipolygon((NavigatableComponent)Main.map.mapView);
            polygon.load(r);
            if (polygon.getOuterWays().isEmpty()) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"No outer way for multipolygon"), 1604, (OsmPrimitive)r));
            }
            for (RelationMember rm : r.getMembers()) {
                if (rm.getMember().isUsable()) continue;
                return;
            }
            List<List<Node>> innerWays = this.joinWays(polygon.getInnerWays());
            List<List<Node>> outerWays = this.joinWays(polygon.getOuterWays());
            if (!this.nonClosedWays.isEmpty()) {
                this.errors.add(new TestError(this, Severity.WARNING, I18n.tr((String)"Multipolygon is not closed"), 1603, Collections.singletonList(r), this.nonClosedWays));
            }
            List<GeneralPath> outerPolygons = this.createPolygons(outerWays);
            for (List<Node> pdInner : innerWays) {
                boolean outside = true;
                boolean crossing = false;
                List<Node> outerWay = null;
                for (int i = 0; i < outerWays.size(); ++i) {
                    GeneralPath outer = outerPolygons.get(i);
                    Multipolygon.PolyData.Intersection intersection = this.getPolygonIntersection(outer, pdInner);
                    outside &= intersection == Multipolygon.PolyData.Intersection.OUTSIDE;
                    if (intersection != Multipolygon.PolyData.Intersection.CROSSING) continue;
                    crossing = true;
                    outerWay = outerWays.get(i);
                }
                if (!(outside | crossing)) continue;
                ArrayList<List<Node>> highlights = new ArrayList<List<Node>>();
                highlights.add(pdInner);
                if (outside) {
                    this.errors.add(new TestError(this, Severity.WARNING, I18n.tr((String)"Multipolygon inner way is outside."), 1605, Collections.singletonList(r), highlights));
                    continue;
                }
                if (!crossing) continue;
                highlights.add(outerWay);
                this.errors.add(new TestError(this, Severity.WARNING, I18n.tr((String)"Intersection between multipolygon ways"), 1606, Collections.singletonList(r), highlights));
            }
        }
    }

    private void checkMembersAndRoles(Relation r) {
        for (RelationMember rm : r.getMembers()) {
            if (rm.isWay()) {
                if ("inner".equals(rm.getRole()) || "outer".equals(rm.getRole()) || !rm.hasRole()) continue;
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"No useful role for multipolygon member"), 1602, rm.getMember()));
                continue;
            }
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Non-Way in multipolygon."), 1601, rm.getMember()));
        }
    }
}

