/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.BuildingsImageModifier;
import cadastre_fr.GeorefImage;
import cadastre_fr.SimplifyWay;
import cadastre_fr.WMSLayer;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Buildings
extends MapMode
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    GeorefImage selectedImage;
    WMSLayer selectedLayer;
    private EastNorth clickedEastNorth;
    private ArrayList<Pixel> listPixels = new ArrayList();
    private static final int cMaxnode = 10000;
    private static final double cDistanceForOptimization = 0.7;
    private int[] dirsX = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    private int[] dirsY = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private int orange = Color.ORANGE.getRGB();
    BuildingsImageModifier bim = new BuildingsImageModifier();
    private double snapDistance = Main.pref.getDouble("cadastrewms.snap-distance", 50.0);
    private double snapDistanceSq = this.snapDistance * this.snapDistance;
    private double dx;
    private double dy;

    public Buildings(MapFrame mapFrame) {
        super(I18n.tr((String)"Grab buildings"), "buildings", I18n.tr((String)"Extract building on click (vector images only)"), Shortcut.registerShortcut((String)"mapmode:buildings", (String)I18n.tr((String)"Mode: {0}", (Object[])new Object[]{I18n.tr((String)"Buildings")}), (int)69, (int)3), mapFrame, ImageProvider.getCursor((String)"normal", (String)"move"));
    }

    public void enterMode() {
        super.enterMode();
        boolean atLeastOneBuildingLayer = false;
        for (Layer layer : Main.map.mapView.getAllLayers()) {
            if (!(layer instanceof WMSLayer) || !((WMSLayer)layer).isBuildingsOnly()) continue;
            atLeastOneBuildingLayer = true;
            break;
        }
        if (atLeastOneBuildingLayer && Main.main.getCurrentDataSet() != null) {
            Main.map.mapView.addMouseListener((MouseListener)this);
            Main.map.mapView.addMouseMotionListener((MouseMotionListener)this);
        } else {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"This feature requires (at least) one special cadastre\nBuildings layer and an OSM data layer."));
            this.exitMode();
            Main.map.selectMapMode((MapMode)Main.map.getDefaultButtonAction());
        }
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)this);
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)this);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        this.selectedImage = null;
        boolean ctrl = (e.getModifiers() & 2) != 0;
        boolean shift = (e.getModifiers() & 1) != 0;
        for (Layer layer : Main.map.mapView.getAllLayers()) {
            if (!layer.isVisible() || !(layer instanceof WMSLayer) || !((WMSLayer)layer).isBuildingsOnly()) continue;
            this.clickedEastNorth = Main.map.mapView.getEastNorth(e.getX(), e.getY());
            this.selectedLayer = (WMSLayer)layer;
            this.selectedImage = this.selectedLayer.findImage(this.clickedEastNorth);
        }
        if (this.selectedImage != null) {
            int x = (int)((this.clickedEastNorth.east() - this.selectedImage.min.east()) * this.selectedImage.getPixelPerEast());
            int y = this.selectedImage.image.getHeight() - (int)((this.clickedEastNorth.north() - this.selectedImage.min.north()) * this.selectedImage.getPixelPerNorth());
            int rgb = this.selectedImage.image.getRGB(x, y);
            System.out.println("image found, x=" + x + ", y=" + y + ", RGB=" + rgb);
            boolean clickOnRoof = this.bim.isRoofColor(rgb, shift);
            boolean clickOnBuilding = this.bim.isBuildingColor(rgb, shift);
            if ((clickOnRoof || clickOnBuilding) && this.traceBuilding(x, y, clickOnBuilding, shift) && this.listPixels.size() > 3) {
                int i;
                Way wayToCreate = new Way();
                Way way2 = new Way();
                double pPE = this.selectedImage.getPixelPerEast();
                double pPN = this.selectedImage.getPixelPerNorth();
                for (i = 0; i < this.listPixels.size(); ++i) {
                    EastNorth en = new EastNorth(this.selectedImage.min.east() + ((double)this.listPixels.get((int)i).p.x + 0.5) / pPE, this.selectedImage.max.north() - ((double)this.listPixels.get((int)i).p.y + 0.5) / pPN);
                    Node nodeToAdd = new Node(Main.proj.eastNorth2latlon(en));
                    wayToCreate.addNode(nodeToAdd);
                }
                wayToCreate.addNode(wayToCreate.getNode(0));
                new SimplifyWay().simplifyWay(wayToCreate, 0.2);
                for (i = 1; i < wayToCreate.getNodesCount(); ++i) {
                    way2.addNode(wayToCreate.getNode(i));
                }
                way2.addNode(way2.getNode(0));
                new SimplifyWay().simplifyWay(way2, 0.2);
                this.simplifyAngles(way2);
                Way wayToAdd = new Way();
                LinkedList<Command> cmds = new LinkedList<Command>();
                if (ctrl) {
                    for (int i2 = 0; i2 < way2.getNodesCount() - 1; ++i2) {
                        wayToAdd.addNode(way2.getNode(i2));
                        cmds.add((Command)new AddCommand((OsmPrimitive)wayToAdd.getNode(i2)));
                    }
                    wayToAdd.addNode(wayToAdd.getNode(0));
                } else {
                    List<WaySegment> wss;
                    int i3;
                    for (i3 = 0; i3 < way2.getNodesCount() - 1; ++i3) {
                        Node nearestNode = this.getNearestNode(way2.getNode(i3));
                        if (nearestNode == null) {
                            wss = this.getNearestWaySegments(way2.getNode(i3));
                            wayToAdd.addNode(way2.getNode(i3));
                            cmds.add((Command)new AddCommand((OsmPrimitive)way2.getNode(i3)));
                            if (wss.size() <= 0) continue;
                            cmds.add((Command)new MoveCommand((OsmPrimitive)way2.getNode(i3), this.dx, this.dy));
                            this.joinNodeToExistingWays(wss, way2.getNode(i3), cmds);
                            continue;
                        }
                        wayToAdd.addNode(nearestNode);
                        cmds.add((Command)new MoveCommand((OsmPrimitive)nearestNode, this.dx, this.dy));
                    }
                    wayToAdd.addNode(wayToAdd.getNode(0));
                    for (i3 = 1; i3 < wayToAdd.getNodesCount(); ++i3) {
                        Node nodeToJoin = this.existingNodesInNewSegment(wayToAdd.getNode(i3 - 1), wayToAdd.getNode(i3), wayToAdd);
                        if (nodeToJoin == null) continue;
                        wss = new LinkedList<WaySegment>();
                        wss.add(new WaySegment(wayToAdd, i3 - 1));
                        wayToAdd = this.joinNodeToExistingWays(wss, nodeToJoin, cmds);
                        cmds.add((Command)new MoveCommand((OsmPrimitive)nodeToJoin, this.dx, this.dy));
                        --i3;
                    }
                }
                cmds.add((Command)new AddCommand((OsmPrimitive)wayToAdd));
                if (clickOnBuilding) {
                    this.addBuildingTags(cmds, wayToAdd);
                }
                if (clickOnRoof) {
                    this.addRoofTags(cmds, wayToAdd);
                }
                Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Create building"), cmds));
                this.getCurrentDataSet().setSelected(new PrimitiveId[]{wayToAdd});
                Main.map.repaint();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    private void addBuildingTags(Collection<Command> cmds, Way wayToAdd) {
        cmds.add((Command)new ChangePropertyCommand((OsmPrimitive)wayToAdd, "building", "yes"));
    }

    private void addRoofTags(Collection<Command> cmds, Way wayToAdd) {
        cmds.add((Command)new ChangePropertyCommand((OsmPrimitive)wayToAdd, "building", "yes"));
        cmds.add((Command)new ChangePropertyCommand((OsmPrimitive)wayToAdd, "wall", "no"));
    }

    private boolean traceBuilding(int x, int y, boolean buildingColors, boolean ignoreParcels) {
        int startY = 0;
        int startX = x;
        while (y > 0) {
            if (this.bim.isBuildingOrRoofColor(this.selectedImage.image, x, --y, buildingColors, ignoreParcels)) continue;
            System.out.println("at " + x + "," + y + " color was " + this.selectedImage.image.getRGB(x, y));
            startY = ++y;
            break;
        }
        if (startY == 0) {
            System.out.println("border not found");
            return false;
        }
        System.out.println("start at x=" + startX + ", y=" + startY);
        this.listPixels.clear();
        int test_x = 0;
        int test_y = 0;
        int new_dir = 0;
        this.addPixeltoList(x, y, new_dir);
        int last_dir = 1;
        for (int i = 0; i < 10000; ++i) {
            for (int d = 1; d <= this.dirsY.length; ++d) {
                new_dir = (last_dir + d + 4) % 8;
                test_x = x + this.dirsX[new_dir];
                test_y = y + this.dirsY[new_dir];
                if (test_x < 0 || test_x >= this.selectedImage.image.getWidth() || test_y < 0 || test_y >= this.selectedImage.image.getHeight()) {
                    System.out.println("Outside image");
                    return false;
                }
                if (this.bim.isBuildingOrRoofColor(this.selectedImage.image, test_x, test_y, buildingColors, ignoreParcels)) {
                    System.out.println("building color at " + test_x + "," + test_y + " new_dir=" + new_dir);
                    break;
                }
                if (d != this.dirsY.length - 1) continue;
                System.out.println("Got stuck at " + x + "," + y);
                this.selectedImage.image.setRGB(x, y, this.orange);
                if (this.removeTwoLastPixelsFromList()) {
                    x = this.listPixels.get((int)(this.listPixels.size() - 1)).p.x;
                    y = this.listPixels.get((int)(this.listPixels.size() - 1)).p.y;
                    last_dir = this.listPixels.get((int)(this.listPixels.size() - 1)).dir;
                    System.out.println("return at " + x + "," + y + " and try again");
                    d = 1;
                    continue;
                }
                System.out.println("cannot try another way");
                return false;
            }
            last_dir = new_dir;
            x = test_x;
            y = test_y;
            if (x == startX && y == startY) {
                System.out.println("loop closed at " + x + "," + y + ", exit");
                break;
            }
            if (this.listPixels.contains(new Pixel(x, y, 0))) {
                int j = this.listPixels.indexOf(new Pixel(x, y, 0));
                int l = this.listPixels.size();
                for (int k = j; k < l; ++k) {
                    this.listPixels.remove(j);
                }
            }
            this.addPixeltoList(x, y, new_dir);
        }
        System.out.println("list size=" + this.listPixels.size());
        return true;
    }

    private void addPixeltoList(int x, int y, int dir) {
        this.listPixels.add(new Pixel(x, y, dir));
        System.out.println("added pixel at " + x + "," + y);
    }

    private boolean removeTwoLastPixelsFromList() {
        if (this.listPixels.size() > 2) {
            System.out.println("remove " + this.listPixels.get((int)(this.listPixels.size() - 1)).p.x + "," + this.listPixels.get((int)(this.listPixels.size() - 1)).p.y);
            this.listPixels.remove(this.listPixels.size() - 1);
            System.out.println("remove " + this.listPixels.get((int)(this.listPixels.size() - 1)).p.x + "," + this.listPixels.get((int)(this.listPixels.size() - 1)).p.y);
            this.listPixels.remove(this.listPixels.size() - 1);
            return true;
        }
        return false;
    }

    private BBox getSnapDistanceBBox(Node n) {
        return new BBox(Main.proj.eastNorth2latlon(new EastNorth(n.getEastNorth().east() - this.snapDistance, n.getEastNorth().north() - this.snapDistance)), Main.proj.eastNorth2latlon(new EastNorth(n.getEastNorth().east() + this.snapDistance, n.getEastNorth().north() + this.snapDistance)));
    }

    private Point getPointInCm(Node n) {
        return new Point(new Double(n.getEastNorth().getX() * 100.0).intValue(), new Double(n.getEastNorth().getY() * 100.0).intValue());
    }

    public Node getNearestNode(Node newNode) {
        Point newPoint = this.getPointInCm(newNode);
        DataSet ds = this.getCurrentDataSet();
        if (ds == null) {
            return null;
        }
        double minDistanceSq = this.snapDistanceSq;
        Node minNode = null;
        for (Node n : ds.searchNodes(this.getSnapDistanceBBox(newNode))) {
            if (!n.isUsable()) continue;
            Point sp = new Point(new Double(n.getEastNorth().getX() * 100.0).intValue(), new Double(n.getEastNorth().getY() * 100.0).intValue());
            double dist = newPoint.distanceSq(sp);
            if (dist < minDistanceSq) {
                minDistanceSq = dist;
                minNode = n;
                continue;
            }
            if (dist != minDistanceSq || minNode == null || (!n.isNew() || !ds.isSelected((OsmPrimitive)n)) && (ds.isSelected((OsmPrimitive)minNode) || !ds.isSelected((OsmPrimitive)n) && !n.isNew())) continue;
            minNode = n;
        }
        if (minNode != null) {
            this.dx = (newNode.getEastNorth().getX() - minNode.getEastNorth().getX()) / 2.0;
            this.dy = (newNode.getEastNorth().getY() - minNode.getEastNorth().getY()) / 2.0;
        }
        return minNode;
    }

    private List<WaySegment> getNearestWaySegments(Node newNode) {
        Point newPoint = new Point(new Double(newNode.getEastNorth().getX() * 100.0).intValue(), new Double(newNode.getEastNorth().getY() * 100.0).intValue());
        TreeMap nearest = new TreeMap();
        DataSet ds = this.getCurrentDataSet();
        if (ds == null) {
            return null;
        }
        for (Way w : ds.searchWays(this.getSnapDistanceBBox(newNode))) {
            if (!w.isUsable()) continue;
            Node lastN = null;
            int i = -2;
            for (Node n : w.getNodes()) {
                double b;
                ++i;
                if (n.isDeleted() || n.isIncomplete()) continue;
                if (lastN == null) {
                    lastN = n;
                    continue;
                }
                Point A = this.getPointInCm(lastN);
                Point B = this.getPointInCm(n);
                double c = A.distanceSq(B);
                double a = newPoint.distanceSq(B);
                double perDist = a - (a - (b = newPoint.distanceSq(A)) + c) * (a - b + c) / 4.0 / c;
                if (perDist < this.snapDistanceSq && a < c + this.snapDistanceSq && b < c + this.snapDistanceSq) {
                    List<WaySegment> l;
                    if (ds.isSelected((OsmPrimitive)w)) {
                        perDist -= 1.0E-5;
                    }
                    if (nearest.containsKey(perDist)) {
                        l = (List)nearest.get(perDist);
                    } else {
                        l = new LinkedList();
                        nearest.put(perDist, l);
                    }
                    double ratio = A.distance(newPoint) / A.distance(B);
                    Point perP = new Point(A.x + new Double((double)(B.x - A.x) * ratio).intValue(), A.y + new Double((double)(B.y - A.y) * ratio).intValue());
                    this.dx = (double)(perP.x - newPoint.x) / 200.0;
                    this.dy = (double)(perP.y - newPoint.y) / 200.0;
                    l.add(new WaySegment(w, i));
                }
                lastN = n;
            }
        }
        ArrayList<WaySegment> nearestList = new ArrayList<WaySegment>();
        for (List wss : nearest.values()) {
            nearestList.addAll(wss);
        }
        return nearestList;
    }

    private Node existingNodesInNewSegment(Node n1, Node n2, Way way) {
        double minx = Math.min(n1.getEastNorth().getX(), n2.getEastNorth().getX()) * 100.0;
        double miny = Math.min(n1.getEastNorth().getY(), n2.getEastNorth().getY()) * 100.0;
        double maxx = Math.max(n1.getEastNorth().getX(), n2.getEastNorth().getX()) * 100.0;
        double maxy = Math.max(n1.getEastNorth().getY(), n2.getEastNorth().getY()) * 100.0;
        BBox bbox = new BBox(Main.proj.eastNorth2latlon(new EastNorth((minx - this.snapDistance) / 100.0, (miny - this.snapDistance) / 100.0)), Main.proj.eastNorth2latlon(new EastNorth((maxx + this.snapDistance) / 100.0, (maxy + this.snapDistance) / 100.0)));
        DataSet ds = this.getCurrentDataSet();
        if (ds == null) {
            return null;
        }
        Node ret = null;
        List nodesInBbox = ds.searchNodes(bbox);
        for (Node n : nodesInBbox) {
            double b;
            Point A = this.getPointInCm(n1);
            Point B = this.getPointInCm(n2);
            Point existingPoint = this.getPointInCm(n);
            double c = A.distanceSq(B);
            double a = existingPoint.distanceSq(B);
            double perDist = a - (a - (b = existingPoint.distanceSq(A)) + c) * (a - b + c) / 4.0 / c;
            if (!(perDist < this.snapDistanceSq) || !(a < c + this.snapDistanceSq) || !(b < c + this.snapDistanceSq) || !n.isUsable() || way.getNodes().contains(n)) continue;
            ret = n;
            double ratio = A.distance(existingPoint) / A.distance(B);
            Point perP = new Point(A.x + new Double((double)(B.x - A.x) * ratio).intValue(), A.y + new Double((double)(B.y - A.y) * ratio).intValue());
            this.dx = (double)(perP.x - existingPoint.x) / 200.0;
            this.dy = (double)(perP.y - existingPoint.y) / 200.0;
            break;
        }
        return ret;
    }

    private Way joinNodeToExistingWays(List<WaySegment> wss, Node newNode, Collection<Command> cmds) {
        HashMap insertPoints = new HashMap();
        for (WaySegment ws : wss) {
            List<Integer> is;
            if (insertPoints.containsKey(ws.way)) {
                is = (List)insertPoints.get(ws.way);
            } else {
                is = new ArrayList();
                insertPoints.put(ws.way, is);
            }
            if (ws.way.getNode(ws.lowerIndex) == newNode || ws.way.getNode(ws.lowerIndex + 1) == newNode) continue;
            is.add(ws.lowerIndex);
        }
        Way wnew = null;
        for (Map.Entry insertPoint : insertPoints.entrySet()) {
            List is = (List)insertPoint.getValue();
            if (is.size() == 0) continue;
            Way w = (Way)insertPoint.getKey();
            List nodesToAdd = w.getNodes();
            Buildings.pruneSuccsAndReverse(is);
            Iterator i$ = is.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                nodesToAdd.add(i + 1, newNode);
            }
            wnew = new Way(w);
            wnew.setNodes(nodesToAdd);
            cmds.add((Command)new ChangeCommand((OsmPrimitive)w, (OsmPrimitive)wnew));
        }
        return wnew;
    }

    private static void pruneSuccsAndReverse(List<Integer> is) {
        HashSet<Integer> is2 = new HashSet<Integer>();
        for (int i : is) {
            if (is2.contains(i - 1) || is2.contains(i + 1)) continue;
            is2.add(i);
        }
        is.clear();
        is.addAll(is2);
        Collections.sort(is);
        Collections.reverse(is);
    }

    private void simplifyAngles(Way way) {
        for (int i = 1; i < way.getNodes().size(); ++i) {
            Node n1 = way.getNode(i - 1);
            Node n2 = way.getNode(i);
            double dist = this.getPointInCm(n1).distance(this.getPointInCm(n2)) / 100.0;
            if (!(dist < 0.7)) continue;
            Node n0 = i > 1 ? way.getNode(i - 2) : way.getNode(way.getNodes().size() - 1);
            Node n3 = i < way.getNodes().size() - 1 ? way.getNode(i + 1) : way.getNode(0);
            double angle1 = this.AngleOfView(n1.getCoor().getX(), n1.getCoor().getY(), n0.getCoor().getX(), n0.getCoor().getY(), n2.getCoor().getX(), n2.getCoor().getY());
            double angle2 = this.AngleOfView(n2.getCoor().getX(), n2.getCoor().getY(), n1.getCoor().getX(), n1.getCoor().getY(), n3.getCoor().getX(), n3.getCoor().getY());
            if (angle1 > 2.827433388230814 && angle1 < 3.455751918948773) {
                way.removeNode(n1);
                System.out.println("remove n1");
                continue;
            }
            if (angle2 > 2.827433388230814 && angle2 < 3.455751918948773) {
                way.removeNode(n2);
                System.out.println("remove n2");
                continue;
            }
            System.out.println("no angle near PI");
        }
    }

    private double AngleOfView(double ViewPt_X, double ViewPt_Y, double Pt1_X, double Pt1_Y, double Pt2_X, double Pt2_Y) {
        double a1 = Pt1_X - ViewPt_X;
        double a2 = Pt1_Y - ViewPt_Y;
        double b1 = Pt2_X - ViewPt_X;
        double b2 = Pt2_Y - ViewPt_Y;
        double a = Math.sqrt(a1 * a1 + a2 * a2);
        double b = Math.sqrt(b1 * b1 + b2 * b2);
        if (a == 0.0 || b == 0.0) {
            return 0.0;
        }
        double cosinus = (a1 * b1 + a2 * b2) / (a * b);
        double t = Math.acos(cosinus);
        return t;
    }

    private class Pixel {
        public Point p;
        public int dir;

        public Pixel(int x, int y, int dir) {
            this.p = new Point(x, y);
            this.dir = dir;
        }

        public int hashCode() {
            return this.p.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Pixel) {
                return this.p.equals(new Point(((Pixel)obj).p.x, ((Pixel)obj).p.y));
            }
            return this.p.equals(obj);
        }
    }
}

