/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.editor;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.DefaultListSelectionModel;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.RelationMemberModel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationMemberEditorModel
extends AbstractTableModel {
    private static final Logger logger = Logger.getLogger(RelationMemberEditorModel.class.getName());
    private final ArrayList<RelationMemberModel> members = new ArrayList();
    private OsmDataLayer layer;
    private DefaultListSelectionModel rowSelectionModel;
    private DefaultListSelectionModel colSelectionModel;

    public RelationMemberEditorModel(OsmDataLayer layer) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)layer, (String)"layer");
        this.layer = layer;
        this.rowSelectionModel = new DefaultListSelectionModel();
        this.colSelectionModel = new DefaultListSelectionModel();
    }

    public RelationMemberEditorModel(OsmDataLayer layer, DefaultListSelectionModel rowSelectionModel, DefaultListSelectionModel colSelectionModel) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)layer, (String)"layer");
        CheckParameterUtil.ensureParameterNotNull((Object)rowSelectionModel, (String)"rowSelectionModel");
        CheckParameterUtil.ensureParameterNotNull((Object)colSelectionModel, (String)"colSelectionModel");
        this.layer = layer;
        this.rowSelectionModel = rowSelectionModel;
        this.colSelectionModel = colSelectionModel;
    }

    public DefaultListSelectionModel getRowSelectionModel() {
        return this.rowSelectionModel;
    }

    public DefaultListSelectionModel getColSelectionModel() {
        return this.colSelectionModel;
    }

    protected Set<OsmPrimitive> getPrimitivesWithRole(String role) {
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        for (RelationMemberModel rm : this.members) {
            OsmPrimitive p;
            if (!rm.getRole().equals(role) || (p = this.layer.data.getPrimitiveById(rm.getTarget())) == null) continue;
            ret.add(p);
        }
        return ret;
    }

    protected List<RelationMemberModel> getRelationMembersWithRole(String role) {
        ArrayList<RelationMemberModel> ret = new ArrayList<RelationMemberModel>();
        for (RelationMemberModel rm : this.members) {
            if (!rm.getRole().equals(role)) continue;
            ret.add(rm);
        }
        return ret;
    }

    protected boolean removeMembersWithRole(String role) {
        if (role == null) {
            return false;
        }
        boolean isChanged = false;
        Iterator<RelationMemberModel> it = this.members.iterator();
        while (it.hasNext()) {
            RelationMemberModel rm = it.next();
            if (!rm.getRole().equals(role)) continue;
            it.remove();
            isChanged = true;
        }
        return isChanged;
    }

    public Set<OsmPrimitive> getFromPrimitives() {
        return this.getPrimitivesWithRole("from");
    }

    public Set<OsmPrimitive> getToPrimitives() {
        return this.getPrimitivesWithRole("to");
    }

    public List<OsmPrimitive> getVias() {
        ArrayList<OsmPrimitive> ret = new ArrayList<OsmPrimitive>();
        for (RelationMemberModel rm : this.getRelationMembersWithRole("via")) {
            ret.add(this.layer.data.getPrimitiveById(rm.getTarget()));
        }
        return ret;
    }

    public void setVias(List<OsmPrimitive> vias) throws IllegalArgumentException {
        boolean viasDeleted = this.removeMembersWithRole("via");
        if (vias == null || vias.isEmpty()) {
            if (viasDeleted) {
                this.fireTableDataChanged();
            }
            return;
        }
        for (OsmPrimitive via : vias) {
            if (via == null || via.getDataSet() != null && via.getDataSet() == this.layer.data) continue;
            throw new IllegalArgumentException(MessageFormat.format("via object ''{0}'' must belong to dataset of layer ''{1}''", via.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()), this.layer.getName()));
        }
        for (OsmPrimitive via : vias) {
            if (via == null) continue;
            RelationMemberModel model = new RelationMemberModel("via", (PrimitiveId)via);
            this.members.add(model);
        }
        this.fireTableDataChanged();
    }

    protected boolean setPrimitiveWithRole(PrimitiveId id, String role) {
        if (id == null) {
            return this.removeMembersWithRole(role);
        }
        List<RelationMemberModel> fromMembers = this.getRelationMembersWithRole(role);
        if (fromMembers.isEmpty()) {
            RelationMemberModel rm = new RelationMemberModel(role, id);
            this.members.add(rm);
            return true;
        }
        if (fromMembers.size() == 1) {
            RelationMemberModel rm = fromMembers.get(0);
            if (!rm.getTarget().equals(id)) {
                rm.setTarget(id);
                return true;
            }
            return false;
        }
        this.removeMembersWithRole(role);
        RelationMemberModel rm = new RelationMemberModel(role, id);
        this.members.add(rm);
        return true;
    }

    public void setFromPrimitive(PrimitiveId id) {
        if (this.setPrimitiveWithRole(id, "from")) {
            this.fireTableDataChanged();
        }
    }

    public void setToPrimitive(PrimitiveId id) {
        if (this.setPrimitiveWithRole(id, "to")) {
            this.fireTableDataChanged();
        }
    }

    public Set<OsmPrimitive> getMemberPrimitives() {
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        for (RelationMemberModel rm : this.members) {
            OsmPrimitive p = this.layer.data.getPrimitiveById(rm.getTarget());
            if (p == null) continue;
            ret.add(p);
        }
        return ret;
    }

    public void populate(Relation tr) {
        this.members.clear();
        if (tr == null) {
            this.fireTableDataChanged();
            return;
        }
        for (RelationMember rm : tr.getMembers()) {
            this.members.add(new RelationMemberModel(rm));
        }
        this.fireTableDataChanged();
    }

    public void applyTo(Relation tr) {
        if (tr == null) {
            return;
        }
        ArrayList<RelationMember> newMembers = new ArrayList<RelationMember>();
        for (RelationMemberModel model : this.members) {
            RelationMember rm = new RelationMember(model.getRole(), this.layer.data.getPrimitiveById(model.getTarget()));
            newMembers.add(rm);
        }
        tr.setMembers(newMembers);
    }

    protected void clearSelectedRoles() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.rowSelectionModel.isSelectedIndex(i)) continue;
            this.members.get(i).setRole("");
        }
    }

    protected void removedSelectedMembers() {
        int j = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.rowSelectionModel.isSelectedIndex(i)) continue;
            this.members.remove(i - j);
            ++j;
        }
    }

    public void deleteSelected() {
        if (this.colSelectionModel.isSelectedIndex(0) && !this.colSelectionModel.isSelectedIndex(1)) {
            this.clearSelectedRoles();
        } else if (this.rowSelectionModel.getMinSelectionIndex() >= 0) {
            this.removedSelectedMembers();
        }
        this.fireTableDataChanged();
    }

    protected List<Integer> getSelectedIndices() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = 0; i < this.members.size(); ++i) {
            if (!this.rowSelectionModel.isSelectedIndex(i)) continue;
            ret.add(i);
        }
        return ret;
    }

    public boolean canMoveUp() {
        List<Integer> sel = this.getSelectedIndices();
        if (sel.isEmpty()) {
            return false;
        }
        return sel.get(0) > 0;
    }

    public boolean canMoveDown() {
        List<Integer> sel = this.getSelectedIndices();
        if (sel.isEmpty()) {
            return false;
        }
        return sel.get(sel.size() - 1) < this.members.size() - 1;
    }

    public void moveUpSelected() {
        if (!this.canMoveUp()) {
            return;
        }
        List<Integer> sel = this.getSelectedIndices();
        for (int idx : sel) {
            RelationMemberModel m = this.members.remove(idx);
            this.members.add(idx - 1, m);
        }
        this.fireTableDataChanged();
        this.rowSelectionModel.clearSelection();
        this.colSelectionModel.setSelectionInterval(0, 1);
        for (int idx : sel) {
            this.rowSelectionModel.addSelectionInterval(idx - 1, idx - 1);
        }
    }

    public void moveDownSelected() {
        if (!this.canMoveDown()) {
            return;
        }
        List<Integer> sel = this.getSelectedIndices();
        for (int i = sel.size() - 1; i >= 0; --i) {
            int idx = sel.get(i);
            RelationMemberModel m = this.members.remove(idx);
            this.members.add(idx + 1, m);
        }
        this.fireTableDataChanged();
        this.rowSelectionModel.clearSelection();
        this.colSelectionModel.setSelectionInterval(0, 1);
        for (int idx : sel) {
            this.rowSelectionModel.addSelectionInterval(idx + 1, idx + 1);
        }
    }

    public void insertMembers(Collection<PrimitiveId> ids) throws IllegalArgumentException {
        if (ids == null) {
            return;
        }
        ArrayList<RelationMemberModel> newMembers = new ArrayList<RelationMemberModel>();
        for (PrimitiveId id : ids) {
            OsmPrimitive p = this.layer.data.getPrimitiveById(id);
            if (p == null) {
                throw new IllegalArgumentException(I18n.tr((String)"Cannot find object with id ''{0}'' in layer ''{1}''", (Object[])new Object[]{id.toString(), this.layer.getName()}));
            }
            if (p.isDeleted() || !p.isVisible()) {
                throw new IllegalArgumentException(I18n.tr((String)"Cannot add object ''{0}'' as relation member because it is deleted or invisible in layer ''{1}''", (Object[])new Object[]{p.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()), this.layer.getName()}));
            }
            newMembers.add(new RelationMemberModel("", id));
        }
        if (newMembers.isEmpty()) {
            return;
        }
        int insertPos = this.rowSelectionModel.getMinSelectionIndex();
        if (insertPos >= 0) {
            this.members.addAll(insertPos, newMembers);
        } else {
            this.members.addAll(newMembers);
        }
        this.fireTableDataChanged();
        if (insertPos < 0) {
            insertPos = 0;
        }
        this.colSelectionModel.setSelectionInterval(0, 1);
        this.rowSelectionModel.setSelectionInterval(insertPos, insertPos + newMembers.size() - 1);
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.members.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.members.get(rowIndex).getRole();
            }
            case 1: {
                return this.layer.data.getPrimitiveById(this.members.get(rowIndex).getTarget());
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex != 0) {
            return;
        }
        String role = (String)aValue;
        RelationMemberModel model = this.members.get(rowIndex);
        model.setRole(role);
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }
}

