/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.plugins.turnrestrictions.preferences.PreferencesPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;

public class PreferenceEditor
extends JPanel
implements PreferenceSetting {
    private PreferencesPanel pnlIconPreferences;

    protected JPanel buildCreditPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.insets = new Insets(0, 0, 0, 5);
        gc.weightx = 0.0;
        JLabel lbl = new JLabel();
        pnl.add((Component)lbl, gc);
        lbl.setIcon(ImageProvider.get((String)"skobbler-logo"));
        gc.gridx = 1;
        gc.weightx = 1.0;
        HtmlPanel msg = new HtmlPanel();
        msg.setText("<html><body>" + I18n.tr((String)"Development of the turn restriction plugin was sponsored by <a href=\"http://www.skobbler.de\">skobbler GmbH</a>.") + "</body></html>");
        pnl.add((Component)msg, gc);
        gc.gridy = 1;
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        pnl.add((Component)new JPanel(), gc);
        SkobblerUrlLauncher urlLauncher = new SkobblerUrlLauncher();
        msg.getEditorPane().addHyperlinkListener(urlLauncher);
        lbl.addMouseListener(urlLauncher);
        return pnl;
    }

    protected JPanel buildIconPreferencePanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        this.pnlIconPreferences = new PreferencesPanel();
        this.pnlIconPreferences.initFromPreferences(Main.pref);
        JScrollPane sp = new JScrollPane((Component)((Object)this.pnlIconPreferences));
        sp.setHorizontalScrollBarPolicy(31);
        sp.setVerticalScrollBarPolicy(20);
        pnl.add((Component)sp, "Center");
        return pnl;
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        JTabbedPane tp = new JTabbedPane();
        tp.add(this.buildIconPreferencePanel());
        tp.add(this.buildCreditPanel());
        tp.setTitleAt(0, I18n.tr((String)"Preferences"));
        tp.setToolTipTextAt(0, I18n.tr((String)"Configure the preferences for the turnrestrictions plugin"));
        tp.setTitleAt(1, I18n.tr((String)"Sponsor"));
        this.add((Component)tp, "Center");
    }

    public PreferenceEditor() {
        this.build();
    }

    public void addGui(PreferenceTabbedPane gui) {
        String description = I18n.tr((String)"An OSM plugin for editing turn restrictions.");
        JPanel tab = gui.createPreferenceTab("turnrestrictions", I18n.tr((String)"Turn Restrictions"), description);
        tab.add((Component)this, GBC.eol().fill(1));
    }

    public boolean ok() {
        this.pnlIconPreferences.saveToPreferences(Main.pref);
        return false;
    }

    class SkobblerUrlLauncher
    extends MouseAdapter
    implements HyperlinkListener {
        SkobblerUrlLauncher() {
        }

        protected void launchBrowser() {
            OpenBrowser.displayUrl((String)"http://www.skobbler.de");
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                this.launchBrowser();
            }
        }

        public void mouseClicked(MouseEvent e) {
            this.launchBrowser();
        }
    }
}

