/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.qa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.IssuesModel;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Severity;
import org.openstreetmap.josm.tools.CheckParameterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Issue {
    protected IssuesModel parent;
    protected Severity severity;
    protected final ArrayList<Action> actions = new ArrayList();

    public Issue(IssuesModel parent) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)parent, (String)"parent");
        this.parent = parent;
        this.severity = Severity.WARNING;
    }

    public Issue(IssuesModel parent, Severity severity) {
        CheckParameterUtil.ensureParameterNotNull((Object)parent, (String)"parent");
        CheckParameterUtil.ensureParameterNotNull((Object)((Object)severity), (String)"severity");
        this.parent = parent;
        this.severity = severity;
    }

    public IssuesModel getIssuesModel() {
        return this.parent;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)((Object)severity), (String)"severity");
        this.severity = severity;
    }

    public abstract String getText();

    public List<Action> getActions() {
        return Collections.unmodifiableList(this.actions);
    }
}

