/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.editor;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.plugins.turnrestrictions.dnd.PrimitiveIdListTransferHandler;
import org.openstreetmap.josm.plugins.turnrestrictions.dnd.PrimitiveIdTransferable;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.RelationMemberColumnModel;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionEditorModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class RelationMemberTable
extends JTable {
    private static final Logger logger = Logger.getLogger(RelationMemberTable.class.getName());
    private TurnRestrictionEditorModel model;
    private DeleteAction actDelete;
    private PasteAction actPaste;
    private TransferHandler transferHandler;

    public RelationMemberTable(TurnRestrictionEditorModel model) {
        super(model.getRelationMemberEditorModel(), new RelationMemberColumnModel(model.getRelationMemberEditorModel().getColSelectionModel()), model.getRelationMemberEditorModel().getRowSelectionModel());
        this.model = model;
        this.setSelectionMode(2);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(true);
        this.addMouseListener((MouseListener)((Object)new TablePopupLauncher()));
        this.setDragEnabled(true);
        this.setTransferHandler(new RelationMemberTransferHandler());
        this.setDropTarget(new RelationMemberTableDropTarget());
        this.actDelete = new DeleteAction();
        model.getRelationMemberEditorModel().getRowSelectionModel().addListSelectionListener(this.actDelete);
        this.registerKeyboardAction(this.actDelete, KeyStroke.getKeyStroke(127, 0), 1);
        this.actPaste = new PasteAction();
    }

    class RelationMemberTableDropTarget
    extends DropTarget {
        private boolean dropAccepted = false;

        RelationMemberTableDropTarget() {
        }

        protected boolean isSupportedFlavor(DataFlavor[] transferFlavors) {
            for (DataFlavor df : transferFlavors) {
                if (!df.equals(PrimitiveIdTransferable.PRIMITIVE_ID_LIST_FLAVOR)) continue;
                return true;
            }
            return false;
        }

        public synchronized void dragEnter(DropTargetDragEvent dtde) {
            if (this.isSupportedFlavor(dtde.getCurrentDataFlavors())) {
                if ((dtde.getSourceActions() & 3) != 0) {
                    dtde.acceptDrag(3);
                    RelationMemberTable.this.setColumnSelectionAllowed(false);
                    this.dropAccepted = true;
                } else {
                    dtde.rejectDrag();
                }
            } else {
                dtde.rejectDrag();
            }
        }

        public synchronized void dragExit(DropTargetEvent dte) {
            RelationMemberTable.this.setColumnSelectionAllowed(true);
            this.dropAccepted = false;
        }

        public synchronized void dragOver(DropTargetDragEvent dtde) {
            int row = RelationMemberTable.this.rowAtPoint(dtde.getLocation());
            int selectedRow = RelationMemberTable.this.getSelectionModel().getMinSelectionIndex();
            if (row >= 0 && row != selectedRow) {
                RelationMemberTable.this.getSelectionModel().setSelectionInterval(row, row);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void drop(DropTargetDropEvent dtde) {
            try {
                if (!this.dropAccepted) {
                    return;
                }
                if ((dtde.getSourceActions() & 3) == 0) {
                    return;
                }
                List ids = (List)dtde.getTransferable().getTransferData(PrimitiveIdTransferable.PRIMITIVE_ID_LIST_FLAVOR);
                try {
                    RelationMemberTable.this.model.getRelationMemberEditorModel().insertMembers(ids);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            finally {
                RelationMemberTable.this.setColumnSelectionAllowed(true);
            }
        }

        public synchronized void dropActionChanged(DropTargetDragEvent dtde) {
            if ((dtde.getSourceActions() & 3) == 0) {
                dtde.rejectDrag();
            } else {
                dtde.acceptDrag(3);
            }
        }
    }

    class RelationMemberTransferHandler
    extends TransferHandler {
        RelationMemberTransferHandler() {
        }

        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            return PrimitiveIdListTransferHandler.isSupportedFlavor(transferFlavors);
        }

        public boolean importData(JComponent comp, Transferable t) {
            try {
                List ids = (List)t.getTransferData(PrimitiveIdTransferable.PRIMITIVE_ID_LIST_FLAVOR);
                try {
                    RelationMemberTable.this.model.getRelationMemberEditorModel().insertMembers(ids);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            return false;
        }

        public int getSourceActions(JComponent c) {
            return 3;
        }
    }

    class PopupMenu
    extends JPopupMenu {
        public PopupMenu() {
            JMenuItem item = this.add(RelationMemberTable.this.actPaste);
            item.setTransferHandler(RelationMemberTable.this.transferHandler);
            RelationMemberTable.this.actPaste.updateEnabledState();
            this.addSeparator();
            this.add(RelationMemberTable.this.actDelete);
        }
    }

    class TablePopupLauncher
    extends PopupMenuLauncher {
        TablePopupLauncher() {
        }

        public void launch(MouseEvent evt) {
            int row = RelationMemberTable.this.rowAtPoint(evt.getPoint());
            if (RelationMemberTable.this.getSelectionModel().getMinSelectionIndex() < 0 && row >= 0) {
                RelationMemberTable.this.getSelectionModel().setSelectionInterval(row, row);
                RelationMemberTable.this.getColumnModel().getSelectionModel().setSelectionInterval(0, 1);
            }
            new PopupMenu().show(RelationMemberTable.this, evt.getX(), evt.getY());
        }
    }

    class PasteAction
    extends AbstractAction {
        public PasteAction() {
            this.putValue("Name", I18n.tr((String)"Paste"));
            this.putValue("ShortDescription", I18n.tr((String)"Insert new relation members from object in the clipboard"));
            this.putValue("SmallIcon", ImageProvider.get((String)"paste"));
            this.putValue("AcceleratorKey", Shortcut.getPasteKeyStroke());
            this.updateEnabledState();
        }

        public void updateEnabledState() {
            DataFlavor[] flavors = Toolkit.getDefaultToolkit().getSystemClipboard().getAvailableDataFlavors();
            this.setEnabled(PrimitiveIdListTransferHandler.isSupportedFlavor(flavors));
        }

        public void actionPerformed(ActionEvent evt) {
            Clipboard cp = Toolkit.getDefaultToolkit().getSystemClipboard();
            if (!PrimitiveIdListTransferHandler.isSupportedFlavor(cp.getAvailableDataFlavors())) {
                return;
            }
            try {
                List ids = (List)cp.getData(PrimitiveIdTransferable.PRIMITIVE_ID_LIST_FLAVOR);
                try {
                    RelationMemberTable.this.model.getRelationMemberEditorModel().insertMembers(ids);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
        }
    }

    class DeleteAction
    extends AbstractAction
    implements ListSelectionListener {
        public DeleteAction() {
            this.putValue("Name", I18n.tr((String)"Delete"));
            this.putValue("ShortDescription", I18n.tr((String)"Clear the selected roles or delete the selected members"));
            this.putValue("SmallIcon", ImageProvider.get((String)"deletesmall"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
            this.updateEnabledState();
        }

        public void updateEnabledState() {
            this.setEnabled(RelationMemberTable.this.model.getRelationMemberEditorModel().getRowSelectionModel().getMinSelectionIndex() >= 0);
        }

        public void actionPerformed(ActionEvent e) {
            RelationMemberTable.this.model.getRelationMemberEditorModel().deleteSelected();
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }
}

