/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.editor;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionType;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class TurnRestrictionTypeRenderer
extends JLabel
implements ListCellRenderer {
    private final Map<TurnRestrictionType, ImageIcon> icons = new HashMap<TurnRestrictionType, ImageIcon>();

    protected void loadImages() {
        for (TurnRestrictionType type : TurnRestrictionType.values()) {
            try {
                ImageIcon icon = new ImageIcon(ImageProvider.get((String)"types/set-a", (String)type.getTagValue()).getImage().getScaledInstance(16, 16, 4));
                this.icons.put(type, icon);
            }
            catch (Exception e) {
                System.out.println(I18n.tr((String)"Warning: failed to load icon for turn restriction type ''{0}''", (Object[])new Object[]{type.getTagValue()}));
                e.printStackTrace();
            }
        }
    }

    public TurnRestrictionTypeRenderer() {
        this.setOpaque(true);
        this.loadImages();
    }

    protected void renderColors(boolean isSelected) {
        if (isSelected) {
            this.setBackground(UIManager.getColor("List.selectionBackground"));
            this.setForeground(UIManager.getColor("List.selectionForeground"));
        } else {
            this.setBackground(UIManager.getColor("List.background"));
            this.setForeground(UIManager.getColor("List.foreground"));
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.renderColors(isSelected);
        if (value == null) {
            this.setText(I18n.tr((String)"please select a turn restriction type"));
            this.setIcon(null);
        } else if (value instanceof String) {
            this.setText((String)value);
            this.setIcon(null);
        } else if (value instanceof TurnRestrictionType) {
            TurnRestrictionType type = (TurnRestrictionType)((Object)value);
            this.setText(type.getDisplayName());
            this.setIcon(this.icons.get((Object)type));
        }
        return this;
    }
}

