/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.qa;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Logger;
import javax.swing.JPanel;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Issue;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.IssueView;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.IssuesModel;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class IssuesView
extends VerticallyScrollablePanel
implements Observer {
    private static final Logger logger = Logger.getLogger(IssuesView.class.getName());
    private IssuesModel model;

    protected void build() {
        this.setLayout(new GridBagLayout());
    }

    public IssuesView(IssuesModel model) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)model, (String)"model");
        this.model = model;
        model.addObserver(this);
        this.build();
    }

    public void refresh() {
        this.removeAll();
        if (!this.model.getIssues().isEmpty()) {
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            gc.gridx = 0;
            gc.gridy = 0;
            for (Issue issue : this.model.getIssues()) {
                this.add(new IssueView(issue), gc);
                ++gc.gridy;
            }
            gc.weighty = 1.0;
            this.add(new JPanel(), gc);
        }
        this.invalidate();
    }

    public void update(Observable o, Object arg) {
        this.refresh();
    }
}

