/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.qa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.ExceptValueModel;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.NavigationControler;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionEditorModel;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionLegRole;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionType;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.IdenticalTurnRestrictionLegsError;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.IllegalRestrictionTypeError;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.IntersectionMissingAsViaError;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Issue;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.MissingRestrictionTypeError;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.MissingTurnRestrictionLegError;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.MultipleTurnRestrictionLegError;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.NonStandardExceptWarning;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.RequiredTagMissingError;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Severity;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.TurnRestrictionLegSplitRequiredError;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.WrongTurnRestrictionLegTypeError;
import org.openstreetmap.josm.tools.CheckParameterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssuesModel
extends Observable
implements Observer {
    private final ArrayList<Issue> issues = new ArrayList();
    private TurnRestrictionEditorModel editorModel;

    public IssuesModel(TurnRestrictionEditorModel editorModel) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)editorModel, (String)"editorModel");
        this.editorModel = editorModel;
        this.editorModel.addObserver(this);
    }

    public void populate(List<Issue> issues) {
        this.issues.clear();
        if (issues != null) {
            this.issues.addAll(issues);
        }
        this.setChanged();
        this.notifyObservers();
    }

    public List<Issue> getIssues() {
        return Collections.unmodifiableList(this.issues);
    }

    public TurnRestrictionEditorModel getEditorModel() {
        return this.editorModel;
    }

    public void populate() {
        this.issues.clear();
        if (this.editorModel != null) {
            this.checkTags(this.editorModel);
            this.checkFromLeg(this.editorModel);
            this.checkToLeg(this.editorModel);
            this.checkFromAndToEquals(this.editorModel);
            this.checkVias(this.editorModel);
        }
        this.setChanged();
        this.notifyObservers();
    }

    protected void checkTags(TurnRestrictionEditorModel editorModel) {
        TagEditorModel tagEditorModel = editorModel.getTagEditorModel();
        TagModel tag = tagEditorModel.get("type");
        if (tag == null || !tag.getValue().trim().equals("restriction")) {
            this.issues.add(new RequiredTagMissingError(this, "type", "restriction"));
        }
        if ((tag = tagEditorModel.get("restriction")) == null) {
            this.issues.add(new MissingRestrictionTypeError(this));
        } else if (!TurnRestrictionType.isStandardTagValue(tag.getValue())) {
            this.issues.add(new IllegalRestrictionTypeError(this, tag.getValue()));
        }
        ExceptValueModel except = this.getEditorModel().getExcept();
        if (!except.isStandard()) {
            this.issues.add(new NonStandardExceptWarning(this, except));
        }
    }

    protected void checkFromLeg(TurnRestrictionEditorModel editorModel) {
        Set<OsmPrimitive> froms = editorModel.getTurnRestrictionLeg(TurnRestrictionLegRole.FROM);
        if (froms.isEmpty()) {
            this.issues.add(new MissingTurnRestrictionLegError(this, TurnRestrictionLegRole.FROM));
            return;
        }
        if (froms.size() > 1) {
            this.issues.add(new MultipleTurnRestrictionLegError(this, TurnRestrictionLegRole.FROM, froms.size()));
            return;
        }
        OsmPrimitive p = froms.iterator().next();
        if (!(p instanceof Way)) {
            this.issues.add(new WrongTurnRestrictionLegTypeError(this, TurnRestrictionLegRole.FROM, p));
        }
    }

    protected void checkToLeg(TurnRestrictionEditorModel editorModel) {
        Set<OsmPrimitive> toLegs = editorModel.getTurnRestrictionLeg(TurnRestrictionLegRole.TO);
        if (toLegs.isEmpty()) {
            this.issues.add(new MissingTurnRestrictionLegError(this, TurnRestrictionLegRole.TO));
            return;
        }
        if (toLegs.size() > 1) {
            this.issues.add(new MultipleTurnRestrictionLegError(this, TurnRestrictionLegRole.TO, toLegs.size()));
            return;
        }
        OsmPrimitive p = toLegs.iterator().next();
        if (!(p instanceof Way)) {
            this.issues.add(new WrongTurnRestrictionLegTypeError(this, TurnRestrictionLegRole.TO, p));
        }
    }

    protected void checkFromAndToEquals(TurnRestrictionEditorModel editorModel) {
        Set<OsmPrimitive> toLegs = editorModel.getTurnRestrictionLeg(TurnRestrictionLegRole.TO);
        Set<OsmPrimitive> fromLegs = editorModel.getTurnRestrictionLeg(TurnRestrictionLegRole.FROM);
        if (toLegs.size() != 1 || fromLegs.size() != 1) {
            return;
        }
        OsmPrimitive from = fromLegs.iterator().next();
        OsmPrimitive to = toLegs.iterator().next();
        if (!(from instanceof Way)) {
            return;
        }
        if (!(to instanceof Way)) {
            return;
        }
        if (from.equals((Object)to)) {
            this.issues.add(new IdenticalTurnRestrictionLegsError(this, from));
        }
    }

    protected Node getNodeAtIntersection(Way from, Way to) {
        HashSet fromNodes = new HashSet(from.getNodes());
        fromNodes.retainAll(to.getNodes());
        if (fromNodes.size() == 1) {
            return (Node)fromNodes.iterator().next();
        }
        return null;
    }

    protected void checkVias(TurnRestrictionEditorModel editorModel) {
        Way to;
        Set<OsmPrimitive> toLegs = editorModel.getTurnRestrictionLeg(TurnRestrictionLegRole.TO);
        Set<OsmPrimitive> fromLegs = editorModel.getTurnRestrictionLeg(TurnRestrictionLegRole.FROM);
        if (toLegs.size() != 1 || fromLegs.size() != 1) {
            return;
        }
        if (!(toLegs.iterator().next() instanceof Way)) {
            return;
        }
        if (!(fromLegs.iterator().next() instanceof Way)) {
            return;
        }
        Way from = (Way)fromLegs.iterator().next();
        Node intersect = this.getNodeAtIntersection(from, to = (Way)toLegs.iterator().next());
        if (intersect != null && !editorModel.getVias().contains(intersect)) {
            this.issues.add(new IntersectionMissingAsViaError(this, from, to, intersect));
        }
        if (intersect != null && from.getNode(0) != intersect && from.getNode(from.getNodesCount() - 1) != intersect) {
            this.issues.add(new TurnRestrictionLegSplitRequiredError(this, TurnRestrictionLegRole.FROM, from, to, intersect));
        }
        if (intersect != null && to.getNode(0) != intersect && to.getNode(to.getNodesCount() - 1) != intersect) {
            this.issues.add(new TurnRestrictionLegSplitRequiredError(this, TurnRestrictionLegRole.TO, from, to, intersect));
        }
    }

    public NavigationControler getNavigationControler() {
        return this.editorModel.getNavigationControler();
    }

    public int getNumWarnings() {
        int ret = 0;
        for (Issue issue : this.issues) {
            if (!issue.getSeverity().equals((Object)Severity.WARNING)) continue;
            ++ret;
        }
        return ret;
    }

    public int getNumErrors() {
        int ret = 0;
        for (Issue issue : this.issues) {
            if (!issue.getSeverity().equals((Object)Severity.ERROR)) continue;
            ++ret;
        }
        return ret;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.populate();
    }
}

