/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.qa;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.NavigationControler;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionLegRole;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Issue;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.IssuesModel;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Severity;
import org.openstreetmap.josm.tools.I18n;

public class MissingTurnRestrictionLegError
extends Issue {
    private TurnRestrictionLegRole role;

    public MissingTurnRestrictionLegError(IssuesModel parent, TurnRestrictionLegRole role) {
        super(parent, Severity.ERROR);
        this.role = role;
        this.actions.add(new FixAction());
    }

    public String getText() {
        String msg = "";
        switch (this.role) {
            case FROM: {
                msg = I18n.tr((String)"An OSM way with role <tt>from</t> is required in a turn restriction.");
                break;
            }
            case TO: {
                msg = I18n.tr((String)"An OSM way with role <tt>to</tt> is required in a turn restriction.");
            }
        }
        msg = msg + " " + I18n.tr((String)"Please go to the Basic editor and manually choose an OSM way.");
        return msg;
    }

    class FixAction
    extends AbstractAction {
        public FixAction() {
            this.putValue("Name", I18n.tr((String)"Add in editor"));
            switch (MissingTurnRestrictionLegError.this.role) {
                case FROM: {
                    this.putValue("ShortDescription", I18n.tr((String)"Add an OSM way with role ''from''"));
                    break;
                }
                case TO: {
                    this.putValue("ShortDescription", I18n.tr((String)"Add an OSM way with role ''to''"));
                }
            }
        }

        public void actionPerformed(ActionEvent e) {
            switch (MissingTurnRestrictionLegError.this.role) {
                case FROM: {
                    MissingTurnRestrictionLegError.this.getIssuesModel().getNavigationControler().gotoBasicEditor(NavigationControler.BasicEditorFokusTargets.FROM);
                    break;
                }
                case TO: {
                    MissingTurnRestrictionLegError.this.getIssuesModel().getNavigationControler().gotoBasicEditor(NavigationControler.BasicEditorFokusTargets.TO);
                }
            }
        }
    }
}

