/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.list;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.plugins.turnrestrictions.TurnRestrictionBuilder;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionEditor;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionEditorManager;
import org.openstreetmap.josm.plugins.turnrestrictions.list.AbstractTurnRestrictionsListView;
import org.openstreetmap.josm.plugins.turnrestrictions.list.TurnRestrictionsInDatasetView;
import org.openstreetmap.josm.plugins.turnrestrictions.list.TurnRestrictionsInSelectionView;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class TurnRestrictionsListDialog
extends ToggleDialog {
    private JCheckBox cbInSelectionOnly;
    private TurnRestrictionsInDatasetView pnlTurnRestrictionsInDataSet;
    private TurnRestrictionsInSelectionView pnlTurnRestrictionsInSelection;
    private NewAction actNew;
    private EditAction actEdit;
    private DeleteAction actDelete;
    private SelectSelectedTurnRestrictions actSelectSelectedTurnRestrictions;
    private ZoomToAction actZoomTo;
    private SwitchListViewHandler switchListViewHandler;
    private AbstractTurnRestrictionsListView currentListView = null;
    private JPanel pnlContent;

    public void showNotify() {
        this.pnlTurnRestrictionsInDataSet.registerAsListener();
        this.pnlTurnRestrictionsInSelection.registerAsListener();
        MapView.addEditLayerChangeListener((MapView.EditLayerChangeListener)this.actNew);
    }

    public void hideNotify() {
        this.pnlTurnRestrictionsInDataSet.unregisterAsListener();
        this.pnlTurnRestrictionsInSelection.unregisterAsListener();
        MapView.removeEditLayerChangeListener((MapView.EditLayerChangeListener)this.actNew);
    }

    protected JPanel buildInSelectionOnlyTogglePanel() {
        JPanel pnl = new JPanel(new FlowLayout(0, 0, 0));
        pnl.setBorder(null);
        this.cbInSelectionOnly = new JCheckBox(I18n.tr((String)"Only participating in selection"));
        pnl.add(this.cbInSelectionOnly);
        this.cbInSelectionOnly.setToolTipText(I18n.tr((String)"<html>Select to display turn restrictions related to object in the current selection only.<br>Deselect to display all turn restrictions in the current data set.</html>"));
        return pnl;
    }

    protected JPanel buildCommandPanel() {
        JPanel pnl = new JPanel(new FlowLayout(0, 0, 0));
        pnl.setBorder(null);
        this.actNew = new NewAction();
        pnl.add((Component)new SideButton((Action)this.actNew, false));
        this.actEdit = new EditAction();
        pnl.add((Component)new SideButton((Action)this.actEdit, false));
        this.actDelete = new DeleteAction();
        pnl.add((Component)new SideButton((Action)this.actDelete, false));
        this.actSelectSelectedTurnRestrictions = new SelectSelectedTurnRestrictions();
        this.actZoomTo = new ZoomToAction();
        return pnl;
    }

    protected void build() {
        this.pnlContent = new JPanel(new BorderLayout(0, 0));
        this.pnlContent.setBorder(null);
        this.pnlContent.add((Component)this.buildInSelectionOnlyTogglePanel(), "North");
        this.pnlContent.add((Component)this.buildCommandPanel(), "South");
        this.add(this.pnlContent, "Center");
        this.pnlTurnRestrictionsInDataSet = new TurnRestrictionsInDatasetView();
        this.pnlTurnRestrictionsInSelection = new TurnRestrictionsInSelectionView();
        this.switchListViewHandler = new SwitchListViewHandler();
        this.switchListViewHandler.activateListView(this.pnlTurnRestrictionsInDataSet);
        this.cbInSelectionOnly.addItemListener(this.switchListViewHandler);
        TurnRestrictionsPopupLauncher launcher = new TurnRestrictionsPopupLauncher();
        this.pnlTurnRestrictionsInDataSet.getList().addMouseListener((MouseListener)((Object)launcher));
        this.pnlTurnRestrictionsInSelection.getList().addMouseListener((MouseListener)((Object)launcher));
    }

    public TurnRestrictionsListDialog() {
        super(I18n.tr((String)"Turn Restrictions"), "turnrestrictions", I18n.tr((String)"Display and manage turn restrictions in the current data set"), null, 150);
        this.build();
    }

    class TurnRestrictionsPopupMenu
    extends JPopupMenu {
        public TurnRestrictionsPopupMenu() {
            this.add(TurnRestrictionsListDialog.this.actNew);
            this.add(TurnRestrictionsListDialog.this.actEdit);
            this.add(TurnRestrictionsListDialog.this.actDelete);
            this.addSeparator();
            this.add(TurnRestrictionsListDialog.this.actSelectSelectedTurnRestrictions);
            this.add(TurnRestrictionsListDialog.this.actZoomTo);
        }
    }

    class TurnRestrictionsPopupLauncher
    extends PopupMenuLauncher {
        TurnRestrictionsPopupLauncher() {
        }

        public void launch(MouseEvent evt) {
            int idx;
            JList lst = TurnRestrictionsListDialog.this.currentListView.getList();
            if (lst.getSelectedIndices().length == 0 && (idx = lst.locationToIndex(evt.getPoint())) >= 0) {
                lst.getSelectionModel().addSelectionInterval(idx, idx);
            }
            TurnRestrictionsPopupMenu popup = new TurnRestrictionsPopupMenu();
            popup.show(lst, evt.getX(), evt.getY());
        }
    }

    class ZoomToAction
    extends AbstractAction
    implements ListSelectionListener {
        public ZoomToAction() {
            this.putValue("ShortDescription", I18n.tr((String)"Zoom to the currently selected turn restrictions"));
            this.putValue("SmallIcon", ImageProvider.get((String)"dialogs/autoscale/selection"));
            this.putValue("Name", I18n.tr((String)"Zoom to"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            List<Relation> toSelect = TurnRestrictionsListDialog.this.currentListView.getModel().getSelectedTurnRestrictions();
            if (toSelect.isEmpty()) {
                return;
            }
            OsmDataLayer layer = Main.main.getEditLayer();
            if (layer == null) {
                return;
            }
            layer.data.setSelected(toSelect);
            new AutoScaleAction("selection").autoScale();
        }

        public void updateEnabledState() {
            this.setEnabled(TurnRestrictionsListDialog.this.currentListView != null && !TurnRestrictionsListDialog.this.currentListView.getModel().getSelectedTurnRestrictions().isEmpty());
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        class AbortException
        extends Exception {
            AbortException() {
            }
        }
    }

    class SelectSelectedTurnRestrictions
    extends AbstractAction
    implements ListSelectionListener {
        public SelectSelectedTurnRestrictions() {
            this.putValue("ShortDescription", I18n.tr((String)"Set the current JOSM selection to the selected turn restrictions"));
            this.putValue("SmallIcon", ImageProvider.get((String)"selectall"));
            this.putValue("Name", I18n.tr((String)"Select in current data layer"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            List<Relation> toSelect = TurnRestrictionsListDialog.this.currentListView.getModel().getSelectedTurnRestrictions();
            if (toSelect.isEmpty()) {
                return;
            }
            OsmDataLayer layer = Main.main.getEditLayer();
            if (layer == null) {
                return;
            }
            layer.data.setSelected(toSelect);
        }

        public void updateEnabledState() {
            this.setEnabled(TurnRestrictionsListDialog.this.currentListView != null && !TurnRestrictionsListDialog.this.currentListView.getModel().getSelectedTurnRestrictions().isEmpty());
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        class AbortException
        extends Exception {
            AbortException() {
            }
        }
    }

    class NewAction
    extends AbstractAction
    implements MapView.EditLayerChangeListener {
        public NewAction() {
            this.putValue("ShortDescription", I18n.tr((String)"Create a new turn restriction"));
            this.putValue("SmallIcon", ImageProvider.get((String)"new"));
            this.putValue("Name", I18n.tr((String)"New"));
            this.updateEnabledState();
        }

        public void run() {
            OsmDataLayer layer = Main.main.getEditLayer();
            if (layer == null) {
                return;
            }
            Relation tr = new TurnRestrictionBuilder().buildFromSelection(layer);
            TurnRestrictionEditor editor = new TurnRestrictionEditor((Component)((Object)TurnRestrictionsListDialog.this), layer, tr);
            TurnRestrictionEditorManager.getInstance().positionOnScreen(editor);
            TurnRestrictionEditorManager.getInstance().register(layer, tr, editor);
            editor.setVisible(true);
        }

        public void actionPerformed(ActionEvent e) {
            this.run();
        }

        protected void updateEnabledState() {
            this.setEnabled(Main.main != null && Main.main.getEditLayer() != null);
        }

        public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
            this.updateEnabledState();
        }
    }

    class DeleteAction
    extends AbstractAction
    implements ListSelectionListener {
        public DeleteAction() {
            this.putValue("ShortDescription", I18n.tr((String)"Delete the selected turn restriction"));
            this.putValue("SmallIcon", ImageProvider.get((String)"dialogs", (String)"delete"));
            this.putValue("Name", I18n.tr((String)"Delete"));
            this.setEnabled(false);
        }

        protected void deleteRelation(Relation toDelete) {
            if (toDelete == null) {
                return;
            }
            org.openstreetmap.josm.actions.mapmode.DeleteAction.deleteRelation((OsmDataLayer)Main.main.getEditLayer(), (Relation)toDelete);
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            List<Relation> toDelete = TurnRestrictionsListDialog.this.currentListView.getModel().getSelectedTurnRestrictions();
            for (Relation r : toDelete) {
                this.deleteRelation(r);
            }
        }

        public void updateEnabledState() {
            this.setEnabled(TurnRestrictionsListDialog.this.currentListView != null && !TurnRestrictionsListDialog.this.currentListView.getModel().getSelectedTurnRestrictions().isEmpty());
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        class AbortException
        extends Exception {
            AbortException() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EditAction
    extends AbstractAction
    implements ListSelectionListener {
        public EditAction() {
            this.putValue("ShortDescription", I18n.tr((String)"Open an editor for the selected turn restricion"));
            this.putValue("SmallIcon", ImageProvider.get((String)"dialogs", (String)"edit"));
            this.putValue("Name", I18n.tr((String)"Edit"));
            this.setEnabled(false);
        }

        protected Collection<RelationMember> getMembersForCurrentSelection(Relation r) {
            HashSet<RelationMember> members = new HashSet<RelationMember>();
            Collection selection = Main.map.mapView.getEditLayer().data.getSelected();
            for (RelationMember member : r.getMembers()) {
                if (!selection.contains(member.getMember())) continue;
                members.add(member);
            }
            return members;
        }

        public void launchEditor(Relation toEdit) {
            if (toEdit == null) {
                return;
            }
            OsmDataLayer layer = Main.main.getEditLayer();
            TurnRestrictionEditorManager manager = TurnRestrictionEditorManager.getInstance();
            TurnRestrictionEditor editor = manager.getEditorForRelation(layer, toEdit);
            if (editor != null) {
                editor.setVisible(true);
                editor.toFront();
            } else {
                editor = new TurnRestrictionEditor((Component)((Object)TurnRestrictionsListDialog.this), layer, toEdit);
                manager.positionOnScreen(editor);
                manager.register(layer, toEdit, editor);
                editor.setVisible(true);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            List<Relation> toEdit = TurnRestrictionsListDialog.this.currentListView.getModel().getSelectedTurnRestrictions();
            if (toEdit.size() != 1) {
                return;
            }
            this.launchEditor(toEdit.get(0));
        }

        public void updateEnabledState() {
            this.setEnabled(TurnRestrictionsListDialog.this.currentListView != null && TurnRestrictionsListDialog.this.currentListView.getModel().getSelectedTurnRestrictions().size() == 1);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class SwitchListViewHandler
    implements ItemListener {
        SwitchListViewHandler() {
        }

        public void activateListView(AbstractTurnRestrictionsListView view) {
            if (TurnRestrictionsListDialog.this.currentListView != null) {
                TurnRestrictionsListDialog.this.currentListView.removeListSelectionListener(TurnRestrictionsListDialog.this.actEdit);
                TurnRestrictionsListDialog.this.currentListView.removeListSelectionListener(TurnRestrictionsListDialog.this.actDelete);
                TurnRestrictionsListDialog.this.currentListView.removeListSelectionListener(TurnRestrictionsListDialog.this.actSelectSelectedTurnRestrictions);
                TurnRestrictionsListDialog.this.currentListView.removeListSelectionListener(TurnRestrictionsListDialog.this.actZoomTo);
                TurnRestrictionsListDialog.this.pnlContent.remove(TurnRestrictionsListDialog.this.currentListView);
            }
            TurnRestrictionsListDialog.this.pnlContent.add((Component)view, "Center");
            TurnRestrictionsListDialog.this.currentListView = view;
            view.addListSelectionListener(TurnRestrictionsListDialog.this.actEdit);
            view.addListSelectionListener(TurnRestrictionsListDialog.this.actDelete);
            view.addListSelectionListener(TurnRestrictionsListDialog.this.actSelectSelectedTurnRestrictions);
            view.addListSelectionListener(TurnRestrictionsListDialog.this.actZoomTo);
            TurnRestrictionsListDialog.this.actEdit.updateEnabledState();
            TurnRestrictionsListDialog.this.actDelete.updateEnabledState();
            TurnRestrictionsListDialog.this.actSelectSelectedTurnRestrictions.updateEnabledState();
            TurnRestrictionsListDialog.this.actZoomTo.updateEnabledState();
            TurnRestrictionsListDialog.this.currentListView.revalidate();
            TurnRestrictionsListDialog.this.currentListView.repaint();
        }

        public void itemStateChanged(ItemEvent e) {
            switch (e.getStateChange()) {
                case 1: {
                    this.activateListView(TurnRestrictionsListDialog.this.pnlTurnRestrictionsInSelection);
                    break;
                }
                case 2: {
                    this.activateListView(TurnRestrictionsListDialog.this.pnlTurnRestrictionsInDataSet);
                }
            }
        }
    }
}

