/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.plugins.turnrestrictions.dnd.PrimitiveIdListProvider;
import org.openstreetmap.josm.plugins.turnrestrictions.dnd.PrimitiveIdListTransferHandler;
import org.openstreetmap.josm.plugins.turnrestrictions.dnd.PrimitiveIdTransferable;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionEditorModel;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionLegRole;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TurnRestrictionLegEditor
extends JPanel
implements Observer,
PrimitiveIdListProvider {
    private static final Logger logger = Logger.getLogger(TurnRestrictionLegEditor.class.getName());
    private JLabel lblOsmObject;
    private final Set<OsmPrimitive> legs = new HashSet<OsmPrimitive>();
    private TurnRestrictionEditorModel model;
    private TurnRestrictionLegRole role;
    private DeleteAction actDelete;
    private CopyAction actCopy;
    private PasteAction actPaste;
    private TransferHandler transferHandler;

    protected void build() {
        this.setLayout(new BorderLayout());
        this.lblOsmObject = new JLabel();
        this.add((Component)this.lblOsmObject, "Center");
        this.lblOsmObject.setOpaque(true);
        this.lblOsmObject.setBorder(null);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this.actDelete = new DeleteAction();
        JButton btn = new JButton(this.actDelete);
        this.add((Component)btn, "East");
        btn.setFocusable(false);
        btn.setText(null);
        btn.setBorder(BorderFactory.createRaisedBevelBorder());
        FocusHandler fh = new FocusHandler();
        this.lblOsmObject.setFocusable(true);
        this.lblOsmObject.addFocusListener(fh);
        this.addFocusListener(fh);
        MouseEventHandler meh = new MouseEventHandler();
        this.lblOsmObject.addMouseListener(meh);
        this.addMouseListener(meh);
        this.lblOsmObject.addMouseListener((MouseListener)((Object)new PopupLauncher()));
        this.registerKeyboardAction(this.actDelete, KeyStroke.getKeyStroke(127, 0), 1);
        this.getInputMap().put(Shortcut.getCopyKeyStroke(), TransferHandler.getCopyAction().getValue("Name"));
        this.getInputMap().put(Shortcut.getPasteKeyStroke(), TransferHandler.getPasteAction().getValue("Name"));
        this.getActionMap().put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        this.getActionMap().put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        this.transferHandler = new LegEditorTransferHandler(this);
        this.lblOsmObject.setTransferHandler(this.transferHandler);
        this.lblOsmObject.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                JComponent c = (JComponent)e.getSource();
                TransferHandler th = c.getTransferHandler();
                th.exportAsDrag(c, e, 1);
            }
        });
        this.actCopy = new CopyAction();
        this.actPaste = new PasteAction();
    }

    public TurnRestrictionLegEditor(TurnRestrictionEditorModel model, TurnRestrictionLegRole role) {
        CheckParameterUtil.ensureParameterNotNull((Object)model, (String)"model");
        CheckParameterUtil.ensureParameterNotNull((Object)((Object)role), (String)"role");
        this.model = model;
        this.role = role;
        this.build();
        model.addObserver(this);
        this.refresh();
    }

    protected void refresh() {
        this.legs.clear();
        this.legs.addAll(this.model.getTurnRestrictionLeg(this.role));
        if (this.legs.isEmpty()) {
            this.lblOsmObject.setFont(UIManager.getFont("Label.font").deriveFont(2));
            this.lblOsmObject.setIcon(null);
            this.lblOsmObject.setText(I18n.tr((String)"please select a way"));
            this.lblOsmObject.setToolTipText(null);
        } else if (this.legs.size() == 1) {
            OsmPrimitive leg = this.legs.iterator().next();
            this.lblOsmObject.setFont(UIManager.getFont("Label.font"));
            this.lblOsmObject.setIcon(ImageProvider.get((String)"data", (String)"way"));
            this.lblOsmObject.setText(leg.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()));
            this.lblOsmObject.setToolTipText(DefaultNameFormatter.getInstance().buildDefaultToolTip(leg));
        } else {
            this.lblOsmObject.setFont(UIManager.getFont("Label.font").deriveFont(2));
            this.lblOsmObject.setIcon(null);
            this.lblOsmObject.setText(I18n.tr((String)"multiple objects with role ''{0}''", (Object[])new Object[]{this.role.toString()}));
            this.lblOsmObject.setToolTipText(null);
        }
        this.renderColors();
        this.actDelete.updateEnabledState();
    }

    protected void renderColors() {
        if (this.lblOsmObject.hasFocus()) {
            this.setBackground(UIManager.getColor("List.selectionBackground"));
            this.setForeground(UIManager.getColor("List.selectionForeground"));
            this.lblOsmObject.setBackground(UIManager.getColor("List.selectionBackground"));
            this.lblOsmObject.setForeground(UIManager.getColor("List.selectionForeground"));
        } else {
            this.lblOsmObject.setBackground(UIManager.getColor("List.background"));
            this.lblOsmObject.setForeground(UIManager.getColor("List.foreground"));
        }
    }

    public TurnRestrictionEditorModel getModel() {
        return this.model;
    }

    public TurnRestrictionLegRole getRole() {
        return this.role;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.refresh();
    }

    @Override
    public List<PrimitiveId> getSelectedPrimitiveIds() {
        if (this.legs.size() == 1) {
            return Collections.singletonList(this.legs.iterator().next().getPrimitiveId());
        }
        return Collections.emptyList();
    }

    class PasteAction
    extends AbstractAction {
        private Action delegate;

        public boolean canPaste() {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            for (DataFlavor df : clipboard.getAvailableDataFlavors()) {
                if (!df.equals(PrimitiveIdTransferable.PRIMITIVE_ID_LIST_FLAVOR)) continue;
                return true;
            }
            return false;
        }

        public PasteAction() {
            this.putValue("Name", I18n.tr((String)"Paste"));
            this.putValue("ShortDescription", I18n.tr((String)"Paste from the clipboard"));
            this.putValue("SmallIcon", ImageProvider.get((String)"paste"));
            this.putValue("AcceleratorKey", Shortcut.getPasteKeyStroke());
            this.delegate = TurnRestrictionLegEditor.this.getActionMap().get("paste");
        }

        public void updateEnabledState() {
            this.setEnabled(this.canPaste());
        }

        public void actionPerformed(ActionEvent e) {
            this.delegate.actionPerformed(e);
        }
    }

    class CopyAction
    extends AbstractAction {
        private Action delegate;

        public CopyAction() {
            this.putValue("Name", I18n.tr((String)"Copy"));
            this.putValue("ShortDescription", I18n.tr((String)"Copy to the clipboard"));
            this.putValue("SmallIcon", ImageProvider.get((String)"copy"));
            this.putValue("AcceleratorKey", Shortcut.getCopyKeyStroke());
            this.delegate = TurnRestrictionLegEditor.this.getActionMap().get("copy");
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            this.delegate.actionPerformed(e);
        }

        public void updateEnabledState() {
            this.setEnabled(TurnRestrictionLegEditor.this.legs.size() == 1);
        }
    }

    class PopupMenu
    extends JPopupMenu {
        public PopupMenu() {
            TurnRestrictionLegEditor.this.actCopy.updateEnabledState();
            JMenuItem item = this.add(TurnRestrictionLegEditor.this.actCopy);
            item.setTransferHandler(TurnRestrictionLegEditor.this.transferHandler);
            TurnRestrictionLegEditor.this.actPaste.updateEnabledState();
            item = this.add(TurnRestrictionLegEditor.this.actPaste);
            item.setTransferHandler(TurnRestrictionLegEditor.this.transferHandler);
            this.addSeparator();
            this.add(TurnRestrictionLegEditor.this.actDelete);
        }
    }

    class PopupLauncher
    extends PopupMenuLauncher {
        PopupLauncher() {
        }

        public void launch(MouseEvent evt) {
            new PopupMenu().show(TurnRestrictionLegEditor.this.lblOsmObject, evt.getX(), evt.getY());
        }
    }

    class LegEditorTransferHandler
    extends PrimitiveIdListTransferHandler {
        Logger logger;

        public LegEditorTransferHandler(PrimitiveIdListProvider provider) {
            super(provider);
            this.logger = Logger.getLogger(LegEditorTransferHandler.class.getName());
        }

        public boolean importData(JComponent comp, Transferable t) {
            try {
                List ids = (List)t.getTransferData(PrimitiveIdTransferable.PRIMITIVE_ID_LIST_FLAVOR);
                if (ids.size() != 1) {
                    return false;
                }
                PrimitiveId id = (PrimitiveId)ids.get(0);
                if (!id.getType().equals((Object)OsmPrimitiveType.WAY)) {
                    return false;
                }
                TurnRestrictionLegEditor.this.model.setTurnRestrictionLeg(TurnRestrictionLegEditor.this.role, id);
                return true;
            }
            catch (IOException e) {
                return false;
            }
            catch (UnsupportedFlavorException e) {
                return false;
            }
        }

        protected Transferable createTransferable(JComponent c) {
            if (TurnRestrictionLegEditor.this.legs.size() != 1) {
                return null;
            }
            return super.createTransferable(c);
        }
    }

    class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            this.putValue("ShortDescription", I18n.tr((String)"Delete from turn restriction"));
            this.putValue("Name", I18n.tr((String)"Delete"));
            this.putValue("SmallIcon", ImageProvider.get((String)"deletesmall"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            TurnRestrictionLegEditor.this.model.setTurnRestrictionLeg(TurnRestrictionLegEditor.this.role, (Way)null);
        }

        public void updateEnabledState() {
            this.setEnabled(TurnRestrictionLegEditor.this.legs.size() > 0);
        }
    }

    class MouseEventHandler
    extends MouseAdapter {
        MouseEventHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            TurnRestrictionLegEditor.this.lblOsmObject.requestFocusInWindow();
        }
    }

    class FocusHandler
    extends FocusAdapter {
        FocusHandler() {
        }

        public void focusGained(FocusEvent e) {
            TurnRestrictionLegEditor.this.renderColors();
        }

        public void focusLost(FocusEvent e) {
            TurnRestrictionLegEditor.this.renderColors();
        }
    }
}

