/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.qa;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionLegRole;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Issue;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.IssuesModel;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Severity;
import org.openstreetmap.josm.tools.I18n;

public class MultipleTurnRestrictionLegError
extends Issue {
    private TurnRestrictionLegRole role;
    private int numLegs;

    public MultipleTurnRestrictionLegError(IssuesModel parent, TurnRestrictionLegRole role, int numLegs) {
        super(parent, Severity.ERROR);
        this.role = role;
        this.numLegs = numLegs;
        this.actions.add(new FixAction());
    }

    public String getText() {
        switch (this.role) {
            case FROM: {
                return I18n.tr((String)"A turn restriction requires exactly one way with role <em>from</em>. This turn restriction has {0} ways in this role. Please remove {1} of them.", (Object[])new Object[]{this.numLegs, this.numLegs - 1});
            }
            case TO: {
                I18n.tr((String)"A turn restriction requires exactly one way with role <em>from</em>. This turn restriction has {0} ways in this role. Please remove {1} of them.", (Object[])new Object[]{this.numLegs, this.numLegs - 1});
            }
        }
        return "";
    }

    class FixAction
    extends AbstractAction {
        public FixAction() {
            this.putValue("Name", I18n.tr((String)"Fix in editor"));
            this.putValue("ShortDescription", I18n.tr((String)"Go to the Advanced Editor and remove the members"));
        }

        public void actionPerformed(ActionEvent e) {
            MultipleTurnRestrictionLegError.this.getIssuesModel().getNavigationControler().gotoAdvancedEditor();
        }
    }
}

