/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.qa;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.NavigationControler;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Issue;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.IssuesModel;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Severity;
import org.openstreetmap.josm.tools.I18n;

public class IllegalRestrictionTypeError
extends Issue {
    private String value;

    public IllegalRestrictionTypeError(IssuesModel parent, String value) {
        super(parent, Severity.ERROR);
        this.actions.add(new FixInEditorAction());
        this.value = value;
    }

    public String getText() {
        return I18n.tr((String)"This turn restriction uses a non-standard restriction type <tt>{0}</tt> for the tag key <tt>restriction<tt>. It is recommended to use standard values only. Please select one in the Basic editor.", (Object[])new Object[]{this.value});
    }

    class FixInEditorAction
    extends AbstractAction {
        public FixInEditorAction() {
            this.putValue("Name", I18n.tr((String)"Fix in editor"));
            this.putValue("ShortDescription", I18n.tr((String)"Go to Basic Editor and manually choose a turn restriction type"));
        }

        public void actionPerformed(ActionEvent e) {
            IllegalRestrictionTypeError.this.getIssuesModel().getNavigationControler().gotoBasicEditor(NavigationControler.BasicEditorFokusTargets.RESTRICION_TYPE);
        }
    }
}

