/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import wmsplugin.GeorefImage;
import wmsplugin.Grabber;
import wmsplugin.WMSGrabber;
import wmsplugin.WMSPlugin;

public class WMSLayer
extends Layer {
    protected static final Icon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(WMSPlugin.class.getResource("/images/wms_small.png")));
    public int messageNum = 5;
    protected MapView mv;
    protected String resolution;
    protected boolean stopAfterPaint = false;
    protected int imageSize = 500;
    protected int dax = 10;
    protected int day = 10;
    protected int minZoom = 3;
    protected double dx = 0.0;
    protected double dy = 0.0;
    protected double pixelPerDegree;
    protected GeorefImage[][] images = new GeorefImage[this.dax][this.day];
    JCheckBoxMenuItem startstop = new JCheckBoxMenuItem(I18n.tr((String)"Automatic downloading"), true);
    protected JCheckBoxMenuItem alphaChannel = new JCheckBoxMenuItem(new ToggleAlphaAction());
    protected String baseURL;
    protected String cookies;
    protected final int serializeFormatVersion = 5;
    private ExecutorService executor = null;
    private boolean usesInvalidUrl = false;
    private boolean isInvalidUrlConfirmed = false;

    public WMSLayer() {
        this(I18n.tr((String)"Blank Layer"), null, null);
        this.initializeImages();
        this.mv = Main.map.mapView;
    }

    public WMSLayer(String name, String baseURL, String cookies) {
        super(name);
        this.alphaChannel.setSelected(Main.pref.getBoolean("wmsplugin.alpha_channel"));
        this.setBackgroundLayer(true);
        this.initializeImages();
        this.baseURL = baseURL;
        this.cookies = cookies;
        WMSGrabber.getProjection(baseURL, true);
        this.mv = Main.map.mapView;
        int codeIndex = this.getName().indexOf("#PPD=");
        this.pixelPerDegree = codeIndex != -1 ? Double.valueOf(this.getName().substring(codeIndex + 5)).doubleValue() : this.getPPD();
        this.resolution = this.mv.getDist100PixelText();
        this.executor = Executors.newFixedThreadPool(3);
        if (!(baseURL == null || baseURL.startsWith("html:") || WMSGrabber.isUrlWithPatterns(baseURL) || baseURL.endsWith("&") || baseURL.endsWith("?"))) {
            if (!this.confirmMalformedUrl(baseURL)) {
                System.out.println(I18n.tr((String)"Warning: WMS layer deactivated because of malformed base url ''{0}''", (Object[])new Object[]{baseURL}));
                this.usesInvalidUrl = true;
                this.setName(this.getName() + I18n.tr((String)"(deactivated)"));
                return;
            }
            this.isInvalidUrlConfirmed = true;
        }
    }

    public boolean hasAutoDownload() {
        return this.startstop.isSelected();
    }

    public double getDx() {
        return this.dx;
    }

    public double getDy() {
        return this.dy;
    }

    public void destroy() {
        try {
            this.executor.shutdownNow();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public double getPPD() {
        ProjectionBounds bounds = this.mv.getProjectionBounds();
        return (double)this.mv.getWidth() / (bounds.max.east() - bounds.min.east());
    }

    public void initializeImages() {
        this.images = new GeorefImage[this.dax][this.day];
        for (int x = 0; x < this.dax; ++x) {
            for (int y = 0; y < this.day; ++y) {
                this.images[x][y] = new GeorefImage(false);
            }
        }
    }

    public Icon getIcon() {
        return icon;
    }

    public String getToolTipText() {
        if (this.startstop.isSelected()) {
            return I18n.tr((String)"WMS layer ({0}), automatically downloading in zoom {1}", (Object[])new Object[]{this.getName(), this.resolution});
        }
        return I18n.tr((String)"WMS layer ({0}), downloading in zoom {1}", (Object[])new Object[]{this.getName(), this.resolution});
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    private ProjectionBounds XYtoBounds(int x, int y) {
        return new ProjectionBounds(new EastNorth((double)(x * this.imageSize) / this.pixelPerDegree, (double)(y * this.imageSize) / this.pixelPerDegree), new EastNorth((double)((x + 1) * this.imageSize) / this.pixelPerDegree, (double)((y + 1) * this.imageSize) / this.pixelPerDegree));
    }

    private int modulo(int a, int b) {
        return a % b >= 0 ? a % b : a % b + b;
    }

    private boolean zoomIsTooBig() {
        return this.pixelPerDegree / this.getPPD() > (double)this.minZoom;
    }

    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        if (this.baseURL == null) {
            return;
        }
        if (this.usesInvalidUrl && !this.isInvalidUrlConfirmed) {
            return;
        }
        if (this.zoomIsTooBig()) {
            for (int x = 0; x < this.dax; ++x) {
                for (int y = 0; y < this.day; ++y) {
                    this.images[this.modulo(x, this.dax)][this.modulo(y, this.day)].paint(g, (NavigatableComponent)mv, this.dx, this.dy);
                }
            }
        } else {
            this.downloadAndPaintVisible(g, mv);
        }
    }

    public void displace(double dx, double dy) {
        this.dx += dx;
        this.dy += dy;
    }

    protected boolean confirmMalformedUrl(String url) {
        if (this.isInvalidUrlConfirmed) {
            return true;
        }
        String msg = I18n.tr((String)"<html>The base URL<br>''{0}''<br>for this WMS layer does neither end with a ''&'' nor with a ''?''.<br>This is likely to lead to invalid WMS request. You should check your<br>preference settings.<br>Do you want to fetch WMS tiles anyway?", (Object[])new Object[]{url});
        Object[] options = new String[]{I18n.tr((String)"Yes, fetch images"), I18n.tr((String)"No, abort")};
        int ret = JOptionPane.showOptionDialog(Main.parent, msg, I18n.tr((String)"Invalid URL?"), 0, 2, null, options, options[1]);
        switch (ret) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    protected void downloadAndPaintVisible(Graphics g, MapView mv) {
        if (this.usesInvalidUrl) {
            return;
        }
        ProjectionBounds bounds = mv.getProjectionBounds();
        int bminx = (int)Math.floor((bounds.min.east() - this.dx) * this.pixelPerDegree / (double)this.imageSize);
        int bminy = (int)Math.floor((bounds.min.north() - this.dy) * this.pixelPerDegree / (double)this.imageSize);
        int bmaxx = (int)Math.ceil((bounds.max.east() - this.dx) * this.pixelPerDegree / (double)this.imageSize);
        int bmaxy = (int)Math.ceil((bounds.max.north() - this.dy) * this.pixelPerDegree / (double)this.imageSize);
        for (int x = bminx; x < bmaxx; ++x) {
            for (int y = bminy; y < bmaxy; ++y) {
                GeorefImage img = this.images[this.modulo(x, this.dax)][this.modulo(y, this.day)];
                g.drawRect(x, y, this.dax, bminy);
                if (img.paint(g, (NavigatableComponent)mv, this.dx, this.dy) || img.downloadingStarted) continue;
                img.downloadingStarted = true;
                img.image = null;
                img.flushedResizedCachedInstance();
                Grabber gr = WMSPlugin.getGrabber(this.XYtoBounds(x, y), img, mv, this);
                if (gr.loadFromCache()) continue;
                gr.setPriority(1);
                this.executor.submit(gr);
            }
        }
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
        for (int x = 0; x < this.dax; ++x) {
            for (int y = 0; y < this.day; ++y) {
                if (this.images[x][y].image == null) continue;
                v.visit(this.images[x][y].min);
                v.visit(this.images[x][y].max);
            }
        }
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Component[] getMenuEntries() {
        return new Component[]{new JMenuItem((Action)LayerListDialog.getInstance().createActivateLayerAction((Layer)this)), new JMenuItem((Action)LayerListDialog.getInstance().createShowHideLayerAction((Layer)this)), new JMenuItem((Action)LayerListDialog.getInstance().createDeleteLayerAction((Layer)this)), new JSeparator(), new JMenuItem(new LoadWmsAction()), new JMenuItem(new SaveWmsAction()), new JMenuItem(new BookmarkWmsAction()), new JSeparator(), this.startstop, this.alphaChannel, new JMenuItem(new ChangeResolutionAction()), new JMenuItem(new ReloadErrorTilesAction()), new JMenuItem(new DownloadAction()), new JSeparator(), new JMenuItem((Action)new LayerListPopup.InfoAction((Layer)this))};
    }

    public GeorefImage findImage(EastNorth eastNorth) {
        for (int x = 0; x < this.dax; ++x) {
            for (int y = 0; y < this.day; ++y) {
                if (this.images[x][y].image == null || this.images[x][y].min == null || this.images[x][y].max == null || !this.images[x][y].contains(eastNorth, this.dx, this.dy)) continue;
                return this.images[x][y];
            }
        }
        return null;
    }

    public class BookmarkWmsAction
    extends AbstractAction {
        public BookmarkWmsAction() {
            super(I18n.tr((String)"Set WMS Bookmark"));
        }

        public void actionPerformed(ActionEvent ev) {
            int i = 0;
            while (Main.pref.hasKey("wmsplugin.url." + i + ".url")) {
                ++i;
            }
            int parameterIndex = WMSLayer.this.getName().indexOf("#PPD=");
            String baseName = parameterIndex != -1 ? WMSLayer.this.getName().substring(0, parameterIndex) : WMSLayer.this.getName();
            Main.pref.put("wmsplugin.url." + i + ".url", WMSLayer.this.baseURL);
            Main.pref.put("wmsplugin.url." + String.valueOf(i) + ".name", baseName + "#PPD=" + WMSLayer.this.getPPD());
            WMSPlugin.refreshMenu();
        }
    }

    public class LoadWmsAction
    extends AbstractAction {
        public LoadWmsAction() {
            super(I18n.tr((String)"Load WMS layer from file"), ImageProvider.get((String)"load"));
        }

        public void actionPerformed(ActionEvent ev) {
            JFileChooser fc = DiskAccessAction.createAndOpenFileChooser((boolean)true, (boolean)false, (String)I18n.tr((String)"Load WMS layer"), (String)"wms");
            if (fc == null) {
                return;
            }
            File f = fc.getSelectedFile();
            if (f == null) {
                return;
            }
            try {
                FileInputStream fis = new FileInputStream(f);
                ObjectInputStream ois = new ObjectInputStream(fis);
                int sfv = ois.readInt();
                if (sfv != 5) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Unsupported WMS file version; found {0}, expected {1}", (Object[])new Object[]{sfv, 5}), I18n.tr((String)"File Format Error"), 0);
                    return;
                }
                WMSLayer.this.startstop.setSelected(false);
                WMSLayer.this.dax = ois.readInt();
                WMSLayer.this.day = ois.readInt();
                WMSLayer.this.imageSize = ois.readInt();
                WMSLayer.this.pixelPerDegree = ois.readDouble();
                WMSLayer.this.setName((String)ois.readObject());
                WMSLayer.this.baseURL = (String)ois.readObject();
                WMSLayer.this.images = (GeorefImage[][])ois.readObject();
                ois.close();
                fis.close();
                WMSLayer.this.mv.repaint();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error loading file"), I18n.tr((String)"Error"), 0);
                return;
            }
        }
    }

    public class SaveWmsAction
    extends AbstractAction {
        public SaveWmsAction() {
            super(I18n.tr((String)"Save WMS layer to file"), ImageProvider.get((String)"save"));
        }

        public void actionPerformed(ActionEvent ev) {
            File f = SaveActionBase.createAndOpenSaveFileChooser((String)I18n.tr((String)"Save WMS layer"), (String)".wms");
            try {
                if (f != null) {
                    ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
                    oos.writeInt(5);
                    oos.writeInt(WMSLayer.this.dax);
                    oos.writeInt(WMSLayer.this.day);
                    oos.writeInt(WMSLayer.this.imageSize);
                    oos.writeDouble(WMSLayer.this.pixelPerDegree);
                    oos.writeObject(WMSLayer.this.getName());
                    oos.writeObject(WMSLayer.this.baseURL);
                    oos.writeObject(WMSLayer.this.images);
                    oos.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
        }
    }

    public class ToggleAlphaAction
    extends AbstractAction {
        public ToggleAlphaAction() {
            super(I18n.tr((String)"Alpha channel"));
        }

        public void actionPerformed(ActionEvent ev) {
            JCheckBoxMenuItem checkbox = (JCheckBoxMenuItem)ev.getSource();
            boolean alphaChannel = checkbox.isSelected();
            Main.pref.put("wmsplugin.alpha_channel", alphaChannel);
            for (int x = 0; x < WMSLayer.this.dax; ++x) {
                for (int y = 0; y < WMSLayer.this.day; ++y) {
                    GeorefImage img = WMSLayer.this.images[WMSLayer.this.modulo(x, WMSLayer.this.dax)][WMSLayer.this.modulo(y, WMSLayer.this.day)];
                    img.flushedResizedCachedInstance();
                }
            }
            WMSLayer.this.mv.repaint();
        }
    }

    public class ReloadErrorTilesAction
    extends AbstractAction {
        public ReloadErrorTilesAction() {
            super(I18n.tr((String)"Reload erroneous tiles"));
        }

        public void actionPerformed(ActionEvent ev) {
            WMSPlugin.cache.customCleanUp(1, 4096);
            for (int x = 0; x < WMSLayer.this.dax; ++x) {
                for (int y = 0; y < WMSLayer.this.day; ++y) {
                    GeorefImage img = WMSLayer.this.images[WMSLayer.this.modulo(x, WMSLayer.this.dax)][WMSLayer.this.modulo(y, WMSLayer.this.day)];
                    if (!img.failed) continue;
                    img.image = null;
                    img.flushedResizedCachedInstance();
                    img.downloadingStarted = false;
                    img.failed = false;
                    WMSLayer.this.mv.repaint();
                }
            }
        }
    }

    public class ChangeResolutionAction
    extends AbstractAction {
        public ChangeResolutionAction() {
            super(I18n.tr((String)"Change resolution"));
        }

        public void actionPerformed(ActionEvent ev) {
            WMSLayer.this.initializeImages();
            WMSLayer.this.resolution = WMSLayer.this.mv.getDist100PixelText();
            WMSLayer.this.pixelPerDegree = WMSLayer.this.getPPD();
            WMSLayer.this.mv.repaint();
        }
    }

    public class DownloadAction
    extends AbstractAction {
        public DownloadAction() {
            super(I18n.tr((String)"Download visible tiles"));
        }

        public void actionPerformed(ActionEvent ev) {
            if (WMSLayer.this.zoomIsTooBig()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The requested area is too big. Please zoom in a little, or change resolution"), I18n.tr((String)"Error"), 0);
            } else {
                WMSLayer.this.downloadAndPaintVisible(WMSLayer.this.mv.getGraphics(), WMSLayer.this.mv);
            }
        }
    }
}

