/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.qa;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Logger;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Issue;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.IssueView;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.IssuesModel;

public class IssuesView
extends VerticallyScrollablePanel
implements Observer {
    private static final Logger logger = Logger.getLogger(IssuesView.class.getName());
    private IssuesModel model;

    protected void build() {
        this.setLayout(new GridBagLayout());
    }

    public IssuesView(IssuesModel model) {
        this.model = model;
        model.addObserver(this);
        this.build();
    }

    public void refresh() {
        logger.info("entering ...");
        this.removeAll();
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        for (Issue issue : this.model.getIssues()) {
            logger.info("adding issue view ...");
            this.add(new IssueView(issue), gc);
            ++gc.gridy;
        }
        this.invalidate();
        this.repaint();
    }

    public void update(Observable o, Object arg) {
        this.refresh();
    }
}

