/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.qa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionEditorModel;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.CompulsoryTagMissingError;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Issue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssuesModel
extends Observable {
    private final ArrayList<Issue> issues = new ArrayList();

    public void populate(List<Issue> issues) {
        this.issues.clear();
        if (issues != null) {
            this.issues.addAll(issues);
        }
        this.setChanged();
        this.notifyObservers();
    }

    public List<Issue> getIssues() {
        return Collections.unmodifiableList(this.issues);
    }

    public void populate(TurnRestrictionEditorModel editorModel) {
        this.issues.clear();
    }

    protected void checkCompulsoryTags(TurnRestrictionEditorModel editorModel) {
        TagEditorModel tagEditorModel = editorModel.getTagEditorModel();
        TagModel tag = tagEditorModel.get("type");
        if (tag == null || !tag.getValue().trim().equals("restriction")) {
            this.issues.add(new CompulsoryTagMissingError(editorModel, "type", "restriction"));
        }
        if ((tag = tagEditorModel.get("restriction")) == null) {
            // empty if block
        }
    }
}

