/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.qa;

import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionEditorModel;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Issue;
import org.openstreetmap.josm.plugins.turnrestrictions.qa.Severity;
import org.openstreetmap.josm.tools.I18n;

public class CompulsoryTagMissingError
extends Issue {
    private static final Logger logger = Logger.getLogger(CompulsoryTagMissingError.class.getName());
    private String tagKey;
    private String tagValue;

    public CompulsoryTagMissingError(TurnRestrictionEditorModel model, String tagKey, String tagValue) {
        super(model, Severity.ERROR);
        this.tagKey = tagKey;
        this.actions.add(new AddTagAction());
        this.setSeverity(Severity.ERROR);
    }

    public String getText() {
        return I18n.tr((String)"The required tag <tt>{0}={1}</tt> is missing", (Object[])new Object[]{this.tagKey, this.tagValue});
    }

    private class AddTagAction
    extends AbstractAction {
        public AddTagAction() {
            this.putValue("Name", I18n.tr((String)"Add missing tag"));
            this.putValue("ShortDescription", I18n.tr((String)"Add the missing tag {0}={1}", (Object[])new Object[]{CompulsoryTagMissingError.this.tagKey, CompulsoryTagMissingError.this.tagValue}));
        }

        public void actionPerformed(ActionEvent e) {
            logger.info("adding tag");
        }
    }
}

