/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.tagspec;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionItemPritority;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionListItem;
import org.openstreetmap.josm.plugins.tageditor.ac.AutoCompletionContext;
import org.openstreetmap.josm.plugins.tageditor.tagspec.KeyValuePair;
import org.openstreetmap.josm.plugins.tageditor.tagspec.LableSpecification;
import org.openstreetmap.josm.plugins.tageditor.tagspec.TagSpecification;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagSpecifications {
    public static final String ATTR_KEY = "key";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_FOR_NODE = "for-node";
    public static final String ATTR_FOR_WAY = "for-way";
    public static final String ATTR_FOR_RELATION = "for-relation";
    public static final String ATTR_VALUE = "value";
    public static final String ELEM_ROOT = "osm-tag-definitions";
    public static final String ELEM_TAG = "tag";
    public static final String ELEM_LABEL = "label";
    public static final String DTD = "osm-tag-definitions.dtd";
    public static final String RES_NAME_TAG_SPECIFICATIONS = "/resources/osm-tag-definitions.xml";
    private static Logger logger = Logger.getLogger(TagSpecification.class.getName());
    private ArrayList<TagSpecification> tagSpecifications = new ArrayList();
    private static TagSpecifications instance = null;

    public static void loadFromResources() throws Exception {
        InputStream in = TagSpecifications.class.getResourceAsStream(RES_NAME_TAG_SPECIFICATIONS);
        if (in == null) {
            logger.log(Level.SEVERE, "failed to create input stream for resource '/resources/osm-tag-definitions.xml'");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        TagSpecifications spec = new TagSpecifications();
        spec.load(reader);
        reader.close();
        instance = spec;
    }

    public static TagSpecifications getInstance() throws Exception {
        if (instance == null) {
            TagSpecifications.loadFromResources();
        }
        return instance;
    }

    public void load(Reader in) throws Exception {
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            Handler handler = new Handler();
            parser.setContentHandler(handler);
            parser.setErrorHandler(handler);
            parser.setEntityResolver(new ResourceEntityResolver());
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            parser.parse(new InputSource(in));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "failed to load tag specificatoin file", e);
            throw e;
        }
        finally {
            Object parser = null;
        }
    }

    public List<AutoCompletionListItem> getKeysForAutoCompletion(AutoCompletionContext context) {
        ArrayList<AutoCompletionListItem> keys = new ArrayList<AutoCompletionListItem>();
        for (TagSpecification spec : this.tagSpecifications) {
            if (!spec.isApplicable(context)) continue;
            AutoCompletionListItem item = new AutoCompletionListItem();
            item.setValue(spec.getKey());
            item.setPriority(AutoCompletionItemPritority.IS_IN_STANDARD);
            keys.add(item);
        }
        return keys;
    }

    public List<AutoCompletionListItem> getLabelsForAutoCompletion(String forKey, AutoCompletionContext context) {
        ArrayList<AutoCompletionListItem> items = new ArrayList<AutoCompletionListItem>();
        for (TagSpecification spec : this.tagSpecifications) {
            if (!spec.getKey().equals(forKey)) continue;
            List<LableSpecification> lables = spec.getLables();
            for (LableSpecification l : lables) {
                if (!l.isApplicable(context)) continue;
                AutoCompletionListItem item = new AutoCompletionListItem();
                item.setValue(l.getValue());
                item.setPriority(AutoCompletionItemPritority.IS_IN_STANDARD);
                items.add(item);
            }
        }
        return items;
    }

    public ArrayList<KeyValuePair> asList() {
        ArrayList<KeyValuePair> entries = new ArrayList<KeyValuePair>();
        for (TagSpecification s : this.tagSpecifications) {
            for (LableSpecification l : s.getLables()) {
                entries.add(new KeyValuePair(s.getKey(), l.getValue()));
            }
        }
        return entries;
    }

    public static void main(String[] args) throws Exception {
        TagSpecifications.loadFromResources();
    }

    class ResourceEntityResolver
    implements EntityResolver {
        ResourceEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (systemId != null && systemId.endsWith(TagSpecifications.DTD)) {
                return new InputSource(TagSpecifications.class.getResourceAsStream(TagSpecifications.DTD));
            }
            throw new SAXException("couldn't load external DTD '" + systemId + "'");
        }
    }

    class Handler
    extends DefaultHandler {
        private TagSpecification currentTagSpecification = null;

        Handler() {
        }

        public void endDocument() throws SAXException {
            logger.log(Level.FINE, "END");
        }

        public void error(SAXParseException e) throws SAXException {
            logger.log(Level.SEVERE, "XML parsing error", e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            logger.log(Level.SEVERE, "XML parsing error", e);
        }

        public void startDocument() throws SAXException {
            logger.log(Level.FINE, "START");
        }

        protected boolean parseYesNo(String value) throws SAXException {
            if ("yes".equals(value)) {
                return true;
            }
            if ("no".equals(value)) {
                return false;
            }
            throw new SAXException("expected 'yes' or 'no' as attribute value, got '" + value + "'");
        }

        protected void startElementOsmTagDefinitions(Attributes atts) throws SAXException {
            TagSpecifications.this.tagSpecifications = new ArrayList();
        }

        protected void endElementOsmTagDefinitions() throws SAXException {
        }

        protected void startElementTag(Attributes atts) throws SAXException {
            this.currentTagSpecification = new TagSpecification();
            for (int i = 0; i < atts.getLength(); ++i) {
                String name = atts.getQName(i);
                String value = atts.getValue(i);
                if (TagSpecifications.ATTR_KEY.equals(name)) {
                    this.currentTagSpecification.setKey(value);
                    continue;
                }
                if (TagSpecifications.ATTR_TYPE.equals(name)) {
                    this.currentTagSpecification.setType(value);
                    continue;
                }
                if (TagSpecifications.ATTR_FOR_NODE.equals(name)) {
                    this.currentTagSpecification.setApplicableToNode(this.parseYesNo(value));
                    continue;
                }
                if (TagSpecifications.ATTR_FOR_WAY.equals(name)) {
                    this.currentTagSpecification.setApplicableToWay(this.parseYesNo(value));
                    continue;
                }
                if (TagSpecifications.ATTR_FOR_RELATION.equals(name)) {
                    this.currentTagSpecification.setApplicableToRelation(this.parseYesNo(value));
                    continue;
                }
                throw new SAXException("unknown attribut '" + name + "' on element 'tag'");
            }
        }

        protected void endElementTag() throws SAXException {
            TagSpecifications.this.tagSpecifications.add(this.currentTagSpecification);
            this.currentTagSpecification = null;
        }

        protected void startElementLabel(Attributes atts) throws SAXException {
            LableSpecification ls = new LableSpecification();
            for (int i = 0; i < atts.getLength(); ++i) {
                String name = atts.getQName(i);
                String value = atts.getValue(i);
                if (TagSpecifications.ATTR_VALUE.equals(name)) {
                    ls.setValue(value);
                    continue;
                }
                if (TagSpecifications.ATTR_FOR_NODE.equals(name)) {
                    ls.setApplicableToNode(this.parseYesNo(value));
                    continue;
                }
                if (TagSpecifications.ATTR_FOR_WAY.equals(name)) {
                    ls.setApplicableToWay(this.parseYesNo(value));
                    continue;
                }
                if (TagSpecifications.ATTR_FOR_RELATION.equals(name)) {
                    ls.setApplicableToRelation(this.parseYesNo(value));
                    continue;
                }
                throw new SAXException("unknown attribut '" + name + "' on element 'lable'");
            }
            this.currentTagSpecification.addLable(ls);
        }

        protected void endElementLabel() throws SAXException {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (TagSpecifications.ELEM_ROOT.equals(qName)) {
                this.startElementOsmTagDefinitions(atts);
            } else if (TagSpecifications.ELEM_TAG.equals(qName)) {
                this.startElementTag(atts);
            } else if (TagSpecifications.ELEM_LABEL.equals(qName)) {
                this.startElementLabel(atts);
            } else {
                throw new SAXException("unknown element '" + qName + "'");
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (TagSpecifications.ELEM_ROOT.equals(qName)) {
                this.endElementOsmTagDefinitions();
            } else if (TagSpecifications.ELEM_TAG.equals(qName)) {
                this.endElementTag();
            } else if (TagSpecifications.ELEM_LABEL.equals(qName)) {
                this.endElementLabel();
            } else {
                throw new SAXException("unknown element '" + qName + "'");
            }
        }

        public void warning(SAXParseException e) throws SAXException {
            logger.log(Level.WARNING, "XML parsing warning", e);
        }
    }
}

