/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.list;

import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.swing.DefaultListSelectionModel;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.turnrestrictions.list.TurnRestrictionsListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TurnRestrictionsInSelectionListModel
extends TurnRestrictionsListModel
implements MapView.EditLayerChangeListener,
SelectionChangedListener {
    private static final Logger logger = Logger.getLogger(TurnRestrictionsInSelectionListModel.class.getName());

    public TurnRestrictionsInSelectionListModel(DefaultListSelectionModel selectionModel) {
        super(selectionModel);
    }

    public void initFromSelection(Collection<? extends OsmPrimitive> selection) {
        HashSet<Relation> turnRestrictions = new HashSet<Relation>();
        if (selection == null) {
            return;
        }
        for (OsmPrimitive osmPrimitive : selection) {
            for (OsmPrimitive parent : osmPrimitive.getReferrers()) {
                if (!this.isTurnRestriction(parent)) continue;
                turnRestrictions.add((Relation)parent);
            }
        }
        this.setTurnRestrictions(turnRestrictions);
    }

    public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
        if (newLayer == null) {
            this.setTurnRestrictions(null);
            return;
        }
        this.initFromSelection(newLayer.data.getSelected());
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        this.initFromSelection(newSelection);
    }
}

