/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.list;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class TurnRestrictionListCellRenderer
extends JPanel
implements ListCellRenderer {
    private static Set<String> RESTRICTION_TYPES = new HashSet<String>(Arrays.asList("no_left_turn", "no_right_turn", "no_straight_on", "no_u_turn", "only_left_turn", "only_right_turn", "only_straight_on"));
    private JLabel icon;
    private JLabel from;
    private JLabel to;

    public TurnRestrictionListCellRenderer() {
        this.build();
    }

    protected boolean isValidRestrictionType(String restrictionType) {
        if (restrictionType == null) {
            return false;
        }
        restrictionType = restrictionType.trim().toLowerCase();
        return RESTRICTION_TYPES.contains(restrictionType);
    }

    protected String buildImageName(String restrictionType) {
        return "types/" + restrictionType;
    }

    protected ImageIcon getIcon(String restrictionType) {
        if (!this.isValidRestrictionType(restrictionType)) {
            return null;
        }
        return ImageProvider.get((String)this.buildImageName(restrictionType));
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.gridheight = 2;
        gc.anchor = 10;
        gc.insets = new Insets(0, 2, 0, 2);
        this.icon = new JLabel();
        this.add((Component)this.icon, gc);
        gc.anchor = 18;
        gc.gridx = 1;
        gc.gridheight = 1;
        gc.weightx = 0.0;
        gc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)new JMultilineLabel("<html><strong>From:</strong></html>"), gc);
        gc.gridx = 2;
        gc.weightx = 1.0;
        this.from = new JLabel();
        this.add((Component)this.from, gc);
        gc.anchor = 18;
        gc.gridx = 1;
        gc.gridy = 1;
        gc.weightx = 0.0;
        this.add((Component)new JMultilineLabel("<html><strong>To:</strong></html>"), gc);
        gc.gridx = 2;
        gc.weightx = 1.0;
        this.to = new JLabel();
        this.add((Component)this.to, gc);
    }

    protected void renderIcon(Relation tr) {
        String restrictionType = tr.get("restriction");
        if (!this.isValidRestrictionType(restrictionType)) {
            this.icon.setIcon(null);
            return;
        }
        this.icon.setIcon(this.getIcon(restrictionType));
    }

    private Way getParticipatingWay(Relation tr, String role) {
        for (RelationMember rm : tr.getMembers()) {
            if (!rm.getRole().trim().toLowerCase().equals(role) || !rm.getType().equals((Object)OsmPrimitiveType.WAY)) continue;
            return (Way)rm.getMember();
        }
        return null;
    }

    protected void renderFrom(Relation tr) {
        Way from = this.getParticipatingWay(tr, "from");
        if (from == null) {
            this.from.setText(I18n.tr((String)"no participating way with role ''from''"));
            return;
        }
        this.from.setText(DefaultNameFormatter.getInstance().format(from));
    }

    protected void renderTo(Relation tr) {
        Way to = this.getParticipatingWay(tr, "to");
        if (to == null) {
            this.to.setText(I18n.tr((String)"no participating way with role ''to''"));
            return;
        }
        this.to.setText(DefaultNameFormatter.getInstance().format(to));
    }

    protected void renderColor(boolean isSelected) {
        Color fg;
        Color bg;
        if (isSelected) {
            bg = UIManager.getColor("List.selectionBackground");
            fg = UIManager.getColor("List.selectionForeground");
        } else {
            bg = UIManager.getColor("background");
            fg = UIManager.getColor("foreground");
        }
        this.setBackground(bg);
        this.icon.setBackground(bg);
        this.from.setBackground(bg);
        this.to.setBackground(bg);
        this.setForeground(fg);
        this.icon.setForeground(fg);
        this.from.setForeground(fg);
        this.to.setForeground(fg);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.renderColor(isSelected);
        Relation tr = (Relation)value;
        this.renderIcon(tr);
        this.renderFrom(tr);
        this.renderTo(tr);
        return this;
    }
}

