/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListSelectionModel;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.plugins.turnrestrictions.dnd.PrimitiveIdListProvider;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionEditorModel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViaListModel
extends AbstractListModel
implements PrimitiveIdListProvider,
Observer {
    private static final Logger logger = Logger.getLogger(ViaListModel.class.getName());
    private DefaultListSelectionModel selectionModel;
    private final ArrayList<OsmPrimitive> vias = new ArrayList();
    private TurnRestrictionEditorModel model;

    public ViaListModel(TurnRestrictionEditorModel model, DefaultListSelectionModel selectionModel) {
        CheckParameterUtil.ensureParameterNotNull((Object)model, (String)"model");
        CheckParameterUtil.ensureParameterNotNull((Object)selectionModel, (String)"selectionModel");
        this.model = model;
        this.selectionModel = selectionModel;
        model.addObserver(this);
        this.refresh();
    }

    public List<OsmPrimitive> getSelectedVias() {
        ArrayList<OsmPrimitive> ret = new ArrayList<OsmPrimitive>();
        for (int i = 0; i < this.getSize(); ++i) {
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            ret.add(this.vias.get(i));
        }
        return ret;
    }

    public void setSelectedVias(Collection<OsmPrimitive> vias) {
        this.selectionModel.clearSelection();
        if (vias == null) {
            return;
        }
        for (OsmPrimitive via : vias) {
            int idx = this.vias.indexOf(via);
            if (idx < 0) continue;
            this.selectionModel.addSelectionInterval(idx, idx);
        }
    }

    public List<Integer> getSelectedRows() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = 0; i < this.getSize(); ++i) {
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            ret.add(i);
        }
        return ret;
    }

    protected List<Integer> moveUp(List<Integer> rows, int targetRow) {
        ArrayList<Integer> ret = new ArrayList<Integer>(rows.size());
        int delta = rows.get(0) - targetRow;
        for (int row : rows) {
            OsmPrimitive via = this.vias.remove(row);
            this.vias.add(row - delta, via);
            ret.add(row - delta);
        }
        return ret;
    }

    protected List<Integer> moveDown(List<Integer> rows, int targetRow) {
        ArrayList<Integer> ret = new ArrayList<Integer>(rows.size());
        int delta = targetRow - rows.get(0);
        for (int i = rows.size() - 1; i >= 0; --i) {
            int row = rows.get(i);
            OsmPrimitive via = this.vias.remove(row);
            this.vias.add(row + delta, via);
            ret.add(row + delta);
        }
        return ret;
    }

    public void moveVias(List<Integer> selectedRows, int targetRow) {
        int delta;
        if (selectedRows == null) {
            return;
        }
        if (selectedRows.size() == 1) {
            int sourceRow = selectedRows.get(0);
            if (sourceRow == targetRow) {
                return;
            }
            OsmPrimitive via = this.vias.remove(sourceRow);
            this.vias.add(targetRow, via);
            this.fireContentsChanged(this, 0, this.getSize());
            this.selectionModel.setSelectionInterval(targetRow, targetRow);
            return;
        }
        int min = selectedRows.get(0);
        int max = selectedRows.get(selectedRows.size() - 1);
        if (targetRow < min) {
            selectedRows = this.moveUp(selectedRows, targetRow);
        } else if (targetRow != min && targetRow - min < this.getSize() - max && (targetRow = min + (delta = Math.min(targetRow - min, this.getSize() - 1 - max))) > min) {
            selectedRows = this.moveDown(selectedRows, targetRow);
        }
        this.fireContentsChanged(this, 0, this.getSize());
        this.selectionModel.clearSelection();
        for (int row : selectedRows) {
            this.selectionModel.addSelectionInterval(row, row);
        }
    }

    public void moveUp() {
        List<Integer> sel = this.getSelectedRows();
        if (sel.isEmpty() || sel.get(0) == 0) {
            return;
        }
        this.moveVias(sel, sel.get(0) - 1);
    }

    public void moveDown() {
        List<Integer> sel = this.getSelectedRows();
        if (sel.isEmpty() || sel.get(sel.size() - 1) == this.getSize() - 1) {
            return;
        }
        this.moveVias(sel, sel.get(sel.size() - 1) + 1);
    }

    public void insertVias(List<PrimitiveId> idsToInsert) {
        if (idsToInsert == null) {
            return;
        }
        ArrayList<OsmPrimitive> primitives = new ArrayList<OsmPrimitive>(idsToInsert.size());
        DataSet ds = this.model.getDataSet();
        for (PrimitiveId id : idsToInsert) {
            OsmPrimitive p = ds.getPrimitiveById(id);
            if (p == null) {
                System.out.println(I18n.tr((String)"Failed to retrieve OSM object with id {0} from dataset {1}. Cannot add it as ''via''.", (Object[])new Object[]{id, ds}));
                continue;
            }
            primitives.add(p);
        }
        int targetRow = Math.max(this.selectionModel.getMinSelectionIndex(), 0);
        ArrayList<OsmPrimitive> newVias = new ArrayList<OsmPrimitive>(this.vias);
        newVias.addAll(targetRow, primitives);
        this.model.setVias(newVias);
        this.fireContentsChanged(this, 0, this.getSize());
        this.selectionModel.clearSelection();
        for (int i = targetRow; i < targetRow + primitives.size(); ++i) {
            this.selectionModel.addSelectionInterval(i, i);
        }
    }

    public void removeSelectedVias() {
        ArrayList<OsmPrimitive> newVias = new ArrayList<OsmPrimitive>(this.vias);
        int j = 0;
        for (int i = 0; i < this.getSize(); ++i) {
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            newVias.remove(i - j);
            ++j;
        }
        if (j == 0) {
            return;
        }
        this.model.setVias(newVias);
    }

    protected void refresh() {
        List<OsmPrimitive> sel = this.getSelectedVias();
        this.vias.clear();
        this.vias.addAll(this.model.getVias());
        this.fireContentsChanged(this, 0, this.getSize());
        this.setSelectedVias(sel);
    }

    @Override
    public Object getElementAt(int index) {
        return this.vias.get(index);
    }

    @Override
    public int getSize() {
        return this.vias.size();
    }

    @Override
    public List<PrimitiveId> getSelectedPrimitiveIds() {
        ArrayList<PrimitiveId> ids = new ArrayList<PrimitiveId>();
        for (OsmPrimitive p : this.getSelectedVias()) {
            ids.add(p.getPrimitiveId());
        }
        return ids;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.refresh();
    }
}

