/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.editor;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.logging.Logger;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionLegRole;
import org.openstreetmap.josm.tools.CheckParameterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TurnRestrictionEditorModel
extends Observable
implements DataSetListener {
    private static final Logger logger = Logger.getLogger(TurnRestrictionEditorModel.class.getName());
    private RelationMember fromRelationMember;
    private RelationMember toRelationMember;
    private Way from;
    private Way to;
    private TagCollection tags = new TagCollection();
    private DataSet dataSet;
    private final List<OsmPrimitive> vias = new ArrayList<OsmPrimitive>();

    public static boolean hasSameMembersAndTags(Relation tp1, Relation tp2) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)tp1, (String)"tp1");
        CheckParameterUtil.ensureParameterNotNull((Object)tp2, (String)"tp2");
        if (!((Object)TagCollection.from((Tagged)tp1).asSet()).equals(TagCollection.from((Tagged)tp2).asSet())) {
            return false;
        }
        if (tp1.getMembersCount() != tp2.getMembersCount()) {
            return false;
        }
        for (int i = 0; i < tp1.getMembersCount(); ++i) {
            if (tp1.getMember(i).equals((Object)tp2.getMember(i))) continue;
            return false;
        }
        return true;
    }

    public void setTurnRestrictionLeg(TurnRestrictionLegRole role, Way way) {
        CheckParameterUtil.ensureParameterNotNull((Object)((Object)role), (String)"role");
        Way oldValue = null;
        switch (role) {
            case FROM: {
                oldValue = this.from;
                this.from = way;
                break;
            }
            case TO: {
                oldValue = this.to;
                this.to = way;
            }
        }
        if (oldValue != way) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void setTurnRestrictionLeg(TurnRestrictionLegRole role, PrimitiveId wayId) {
        CheckParameterUtil.ensureParameterNotNull((Object)((Object)role), (String)"role");
        if (wayId == null) {
            this.setTurnRestrictionLeg(role, (Way)null);
            return;
        }
        if (!wayId.getType().equals((Object)OsmPrimitiveType.WAY)) {
            throw new IllegalArgumentException(MessageFormat.format("parameter ''wayId'' of type {0} expected, got {1}", OsmPrimitiveType.WAY, wayId.getType()));
        }
        if (this.dataSet == null) {
            throw new IllegalStateException("data set not initialized");
        }
        OsmPrimitive p = this.dataSet.getPrimitiveById(wayId);
        if (p == null) {
            throw new IllegalStateException(MessageFormat.format("didn't find way with id {0} in dataset {1}", wayId, this.dataSet));
        }
        this.setTurnRestrictionLeg(role, (Way)p);
    }

    public Way getTurnRestrictionLeg(TurnRestrictionLegRole role) {
        CheckParameterUtil.ensureParameterNotNull((Object)((Object)role), (String)"role");
        switch (role) {
            case FROM: {
                return this.from;
            }
            case TO: {
                return this.to;
            }
        }
        return null;
    }

    protected void initFromTurnRestriction(Relation turnRestriction) {
        this.from = null;
        this.to = null;
        this.fromRelationMember = null;
        this.toRelationMember = null;
        this.tags = new TagCollection();
        this.vias.clear();
        if (turnRestriction == null) {
            return;
        }
        for (RelationMember rm : turnRestriction.getMembers()) {
            if (!rm.getRole().equals("from") || !rm.isWay()) continue;
            this.fromRelationMember = rm;
            this.from = rm.getWay();
            break;
        }
        for (RelationMember rm : turnRestriction.getMembers()) {
            if (!rm.getRole().equals("to") || !rm.isWay()) continue;
            this.toRelationMember = rm;
            this.to = rm.getWay();
            break;
        }
        for (RelationMember rm : turnRestriction.getMembers()) {
            if (!rm.getRole().equals("via")) continue;
            this.vias.add(rm.getMember());
        }
        this.tags = TagCollection.from((Tagged)turnRestriction);
        this.tags.setUniqueForKey("type", "restriction");
        this.setChanged();
        this.notifyObservers();
    }

    public void populate(Relation turnRestriction) {
        CheckParameterUtil.ensureParameterNotNull((Object)turnRestriction, (String)"turnRestriction");
        if (turnRestriction.getDataSet() == null) {
            throw new IllegalArgumentException(MessageFormat.format("turnRestriction {0} must belong to a dataset", turnRestriction.getId()));
        }
        this.dataSet = turnRestriction.getDataSet();
        this.initFromTurnRestriction(turnRestriction);
    }

    public void populate(Relation turnRestriction, DataSet ds) {
        CheckParameterUtil.ensureParameterNotNull((Object)turnRestriction, (String)"turnRestriction");
        CheckParameterUtil.ensureParameterNotNull((Object)ds, (String)"ds");
        if (!turnRestriction.isNew()) {
            throw new IllegalArgumentException(MessageFormat.format("new turn restriction expected, got turn restriction with id {0}", turnRestriction.getId()));
        }
        if (turnRestriction.getDataSet() != null) {
            throw new IllegalArgumentException(MessageFormat.format("expected turn restriction not assigned to a  dataset, got turn restriction with id {0} assigned to {1}", turnRestriction.getId(), turnRestriction.getDataSet()));
        }
        for (RelationMember rm : turnRestriction.getMembers()) {
            if (rm.getMember().getDataSet() == ds) continue;
            throw new IllegalArgumentException(MessageFormat.format("expected all members assigned to dataset {0}, got member {1} assigned to {2}", ds, rm, rm.getMember().getDataSet()));
        }
        this.dataSet = ds;
        this.initFromTurnRestriction(turnRestriction);
    }

    public void apply(Relation turnRestriction) {
        CheckParameterUtil.ensureParameterNotNull((Object)turnRestriction, (String)"turnRestriction");
        this.tags.applyTo((Tagged)turnRestriction);
        ArrayList<RelationMember> members = new ArrayList<RelationMember>();
        if (this.from != null) {
            members.add(new RelationMember("from", (OsmPrimitive)this.from));
        }
        if (this.to != null) {
            members.add(new RelationMember("to", (OsmPrimitive)this.to));
        }
        for (OsmPrimitive via : this.vias) {
            members.add(new RelationMember("via", via));
        }
        turnRestriction.setMembers(members);
    }

    public String getRestrictionTagValue() {
        if (!this.tags.hasTagsFor("restriction")) {
            return null;
        }
        return this.tags.getJoinedValues("restriction");
    }

    public void setRestrictionTagValue(String value) {
        if (value == null || value.trim().equals("")) {
            this.tags.removeByKey("restriction");
        } else {
            this.tags.setUniqueForKey("restriction", value.trim());
        }
        this.setChanged();
        this.notifyObservers();
    }

    public List<OsmPrimitive> getVias() {
        return Collections.unmodifiableList(this.vias);
    }

    public void setVias(List<OsmPrimitive> vias) {
        if (vias == null) {
            this.vias.clear();
            this.setChanged();
            this.notifyObservers();
            return;
        }
        for (OsmPrimitive p : vias) {
            if (p == null) {
                throw new IllegalArgumentException("a via object must not be null");
            }
            if (p.getDataSet() == this.dataSet) continue;
            throw new IllegalArgumentException(MessageFormat.format("a via object must belong to dataset {1}, object {2} belongs to {3}", this.dataSet, p.getPrimitiveId(), p.getDataSet()));
        }
        this.vias.clear();
        this.vias.addAll(vias);
        this.setChanged();
        this.notifyObservers();
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void registerAsEventListener() {
        DatasetEventManager.getInstance().addDatasetListener((DataSetListener)this, DatasetEventManager.FireMode.IN_EDT);
    }

    public void unregisterAsEventListener() {
        DatasetEventManager.getInstance().removeDatasetListener((DataSetListener)this);
    }

    protected boolean isAffectedByDataSetUpdate(DataSet ds, List<? extends OsmPrimitive> updatedPrimitives) {
        if (ds != this.dataSet) {
            return false;
        }
        if (updatedPrimitives == null || updatedPrimitives.isEmpty()) {
            return false;
        }
        if (this.from != null && updatedPrimitives.contains(this.from)) {
            return true;
        }
        if (this.to != null && updatedPrimitives.contains(this.to)) {
            return true;
        }
        for (OsmPrimitive via : this.vias) {
            if (!updatedPrimitives.contains(via)) continue;
            return true;
        }
        return false;
    }

    public void dataChanged(DataChangedEvent event) {
        this.setChanged();
        this.notifyObservers();
    }

    public void nodeMoved(NodeMovedEvent event) {
        if (this.isAffectedByDataSetUpdate(event.getDataset(), event.getPrimitives())) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    public void primtivesAdded(PrimitivesAddedEvent event) {
    }

    public void primtivesRemoved(PrimitivesRemovedEvent event) {
    }

    public void relationMembersChanged(RelationMembersChangedEvent event) {
    }

    public void tagsChanged(TagsChangedEvent event) {
        if (this.isAffectedByDataSetUpdate(event.getDataset(), event.getPrimitives())) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void wayNodesChanged(WayNodesChangedEvent event) {
        if (this.isAffectedByDataSetUpdate(event.getDataset(), event.getPrimitives())) {
            this.setChanged();
            this.notifyObservers();
        }
    }
}

