/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.wayselector;

import java.util.Collection;
import java.util.TreeSet;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaySelection {
    Collection<Way> ways;
    TreeSet<Node> outerNodes;
    TreeSet<Node> nodes;

    public WaySelection(Collection<Way> ways) {
        this.ways = ways;
        this.outerNodes = null;
        this.nodes = null;
    }

    private void addNodes(Node node) {
        if (node != null) {
            if (!this.nodes.add(node)) {
                this.outerNodes.remove(node);
            } else {
                this.outerNodes.add(node);
            }
        }
    }

    private void addNodes(Way way) {
        this.addNodes(way.firstNode());
        this.addNodes(way.lastNode());
    }

    public boolean canExtend() {
        if (this.ways.isEmpty()) {
            return false;
        }
        this.nodes = new TreeSet();
        this.outerNodes = new TreeSet();
        for (Way way : this.ways) {
            this.addNodes(way);
        }
        return !this.outerNodes.isEmpty();
    }

    private Way findWay(Collection<OsmPrimitive> selection, Node node) {
        TreeSet<Way> foundWays = new TreeSet<Way>();
        for (Way way : OsmPrimitive.getFilteredList((Collection)node.getReferrers(), Way.class)) {
            if (way.getNodesCount() < 2 || selection.contains(way) || !way.isFirstLastNode(node)) continue;
            foundWays.add(way);
        }
        return foundWays.size() == 1 ? (Way)foundWays.first() : null;
    }

    private Way findWay(Collection<OsmPrimitive> selection) {
        for (Node node : this.outerNodes) {
            Way way = this.findWay(selection, node);
            if (way == null) continue;
            return way;
        }
        return null;
    }

    void extend(DataSet data) {
        Way way;
        Collection selection = data.getSelected();
        boolean selectionChanged = false;
        if (!this.canExtend()) {
            return;
        }
        while ((way = this.findWay(selection)) != null && selection.add(way)) {
            selectionChanged = true;
            this.ways.add(way);
            this.addNodes(way);
        }
        if (selectionChanged) {
            data.setSelected(selection, true);
        }
    }
}

