/*
 * Decompiled with CFR 0.152.
 */
package org.kaintoch.gps.globalsat.dg100;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Properties;

public class Dg100Config {
    private byte logFormat = (byte)-1;
    private byte disableLogSpeed = (byte)-1;
    private int speedThres = -1;
    private byte disableLogDist = (byte)-1;
    private int distThres = -1;
    private int swATime = -1;
    private int swBTime = -1;
    private int swCTime = -1;
    private short unk1 = (short)-1;
    private byte swATimeOrDist = (byte)-1;
    private byte swBTimeOrDist = (byte)-1;
    private byte swCTimeOrDist = (byte)-1;
    private int swADist = -1;
    private int swBDist = -1;
    private int swCDist = -1;
    private byte unk2 = (byte)-1;
    private int remainder = -1;
    private int unk3 = -1;
    private int unk4 = -1;
    private static String propLogFormat = "logFormat";
    private static String propDisableLogSpeed = "disableLogSpeed";
    private static String propSpeedThres = "speedThres";
    private static String propDisableLogDist = "disableLogDist";
    private static String propDistThres = "distThres";
    private static String propSwATime = "swATime";
    private static String propSwBTime = "swBTime";
    private static String propSwCTime = "swCTime";
    private static String propUnk1 = "unk1";
    private static String propSwATimeOrDist = "swATimeOrDist";
    private static String propSwBTimeOrDist = "swBTimeOrDist";
    private static String propSwCTimeOrDist = "swCTimeOrDist";
    private static String propSwADist = "swADist";
    private static String propSwBDist = "swBDist";
    private static String propSwCDist = "swCDist";
    private static String propUnk2 = "unk2";
    private static String propRemainder = "remainder";
    private static String propUnk3 = "unk3";
    private static String propUnk4 = "unk4";

    public Dg100Config(ByteBuffer buf) {
        this.logFormat = buf.get();
        this.disableLogSpeed = buf.get();
        this.speedThres = buf.getInt();
        this.disableLogDist = buf.get();
        this.distThres = buf.getInt();
        this.swATime = buf.getInt();
        this.swBTime = buf.getInt();
        this.swCTime = buf.getInt();
        this.unk1 = buf.getShort();
        this.swATimeOrDist = buf.get();
        this.swBTimeOrDist = buf.get();
        this.swCTimeOrDist = buf.get();
        this.swADist = buf.getInt();
        this.swBDist = buf.getInt();
        this.swCDist = buf.getInt();
        this.unk2 = buf.get();
        this.remainder = buf.get();
        this.unk3 = buf.get();
        this.unk4 = buf.get();
    }

    public Dg100Config(String fName) throws Exception {
        this.readProps(fName);
    }

    public String toString() {
        return "[Dg100Config: logFormat = " + this.logFormat + ",disableLogSpeed = " + this.disableLogSpeed + ",speedThres = " + this.speedThres + ",disableLogDist = " + this.disableLogDist + ",distThres = " + this.distThres + ",swATime = " + this.swATime + ",swBTime = " + this.swBTime + ",swCTime = " + this.swCTime + ",unk1 = " + this.unk1 + ",swATimeOrDist = " + this.swATimeOrDist + ",swBTimeOrDist = " + this.swBTimeOrDist + ",swCTimeOrDist = " + this.swCTimeOrDist + ",swADist = " + this.swADist + ",swBDist = " + this.swBDist + ",swCDist = " + this.swCDist + ",unk2 = " + this.unk2 + ",remainder = " + this.remainder + ",unk3 = " + this.unk3 + ",unk4 = " + this.unk4;
    }

    public void write(ByteBuffer buf) {
        buf.position(5);
        buf.put(this.logFormat);
        buf.put(this.disableLogSpeed);
        buf.putInt(this.speedThres);
        buf.put(this.disableLogDist);
        buf.putInt(this.distThres);
        buf.putInt(this.swATime);
        buf.putInt(this.swBTime);
        buf.putInt(this.swCTime);
        buf.putShort(this.unk1);
        buf.put(this.swATimeOrDist);
        buf.put(this.swBTimeOrDist);
        buf.put(this.swCTimeOrDist);
        buf.putInt(this.swADist);
        buf.putInt(this.swBDist);
        buf.putInt(this.swCDist);
        buf.put(this.unk2);
    }

    public boolean getDisableLogDist() {
        return this.disableLogDist != 0;
    }

    public void setDisableLogDist(boolean disableLogDist) {
        this.disableLogDist = (byte)(disableLogDist ? 1 : 0);
    }

    public boolean getDisableLogSpeed() {
        return this.disableLogSpeed != 0;
    }

    public void setDisableLogSpeed(boolean disableLogSpeed) {
        this.disableLogSpeed = (byte)(disableLogSpeed ? 1 : 0);
    }

    public int getDistThres() {
        return this.distThres;
    }

    public void setDistThres(int distThres) {
        this.distThres = distThres;
    }

    public byte getLogFormat() {
        return this.logFormat;
    }

    public void setLogFormat(byte logFormat) {
        this.logFormat = logFormat;
    }

    public int getSpeedThres() {
        return this.speedThres;
    }

    public void setSpeedThres(int speedThres) {
        this.speedThres = speedThres;
    }

    public int getSwADist() {
        return this.swADist;
    }

    public void setSwADist(int swADist) {
        this.swADist = swADist;
    }

    public int getSwATime() {
        return this.swATime;
    }

    public void setSwATime(int swATime) {
        this.swATime = swATime;
    }

    public byte getSwATimeOrDist() {
        return this.swATimeOrDist;
    }

    public void setSwATimeOrDist(byte swATimeOrDist) {
        this.swATimeOrDist = swATimeOrDist;
    }

    public int getSwBDist() {
        return this.swBDist;
    }

    public void setSwBDist(int swBDist) {
        this.swBDist = swBDist;
    }

    public int getSwBTime() {
        return this.swBTime;
    }

    public void setSwBTime(int swBTime) {
        this.swBTime = swBTime;
    }

    public byte getSwBTimeOrDist() {
        return this.swBTimeOrDist;
    }

    public void setSwBTimeOrDist(byte swBTimeOrDist) {
        this.swBTimeOrDist = swBTimeOrDist;
    }

    public int getSwCDist() {
        return this.swCDist;
    }

    public void setSwCDist(int swCDist) {
        this.swCDist = swCDist;
    }

    public int getSwCTime() {
        return this.swCTime;
    }

    public void setSwCTime(int swCTime) {
        this.swCTime = swCTime;
    }

    public byte getSwCTimeOrDist() {
        return this.swCTimeOrDist;
    }

    public void setSwCTimeOrDist(byte swCTimeOrDist) {
        this.swCTimeOrDist = swCTimeOrDist;
    }

    public short getUnk1() {
        return this.unk1;
    }

    public void setUnk1(short unk1) {
        this.unk1 = unk1;
    }

    public byte getUnk2() {
        return this.unk2;
    }

    public void setUnk2(byte unk2) {
        this.unk2 = unk2;
    }

    public int getRemainder() {
        return this.remainder;
    }

    public int getUnk3() {
        return this.unk3;
    }

    public int getUnk4() {
        return this.unk4;
    }

    public void writeProps(String fName) throws Exception {
        Properties props = new Properties();
        props.setProperty(propLogFormat, "" + this.logFormat);
        props.setProperty(propDisableLogSpeed, "" + this.disableLogSpeed);
        props.setProperty(propSpeedThres, "" + this.speedThres);
        props.setProperty(propDisableLogDist, "" + this.disableLogDist);
        props.setProperty(propDistThres, "" + this.distThres);
        props.setProperty(propSwATime, "" + this.swATime);
        props.setProperty(propSwBTime, "" + this.swBTime);
        props.setProperty(propSwCTime, "" + this.swCTime);
        props.setProperty(propUnk1, "" + this.unk1);
        props.setProperty(propSwATimeOrDist, "" + this.swATimeOrDist);
        props.setProperty(propSwBTimeOrDist, "" + this.swBTimeOrDist);
        props.setProperty(propSwCTimeOrDist, "" + this.swCTimeOrDist);
        props.setProperty(propSwADist, "" + this.swADist);
        props.setProperty(propSwBDist, "" + this.swBDist);
        props.setProperty(propSwCDist, "" + this.swCDist);
        props.setProperty(propUnk2, "" + this.unk2);
        props.setProperty(propRemainder, "" + this.remainder);
        props.setProperty(propUnk3, "" + this.unk3);
        props.setProperty(propUnk4, "" + this.unk4);
        FileOutputStream os = null;
        try {
            try {
                os = new FileOutputStream(fName);
                props.store(os, "dg100 config");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (os != null) {
                ((OutputStream)os).close();
            }
        }
    }

    public void readProps(String fName) throws Exception {
        Properties props = new Properties();
        FileInputStream is = null;
        try {
            try {
                is = new FileInputStream(fName);
                props.load(is);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        this.logFormat = Byte.parseByte(props.getProperty(propLogFormat, "2"));
        this.disableLogSpeed = Byte.parseByte(props.getProperty(propDisableLogSpeed, "0"));
        this.speedThres = Integer.parseInt(props.getProperty(propSpeedThres, "0"));
        this.disableLogDist = Byte.parseByte(props.getProperty(propDisableLogDist, "0"));
        this.distThres = Integer.parseInt(props.getProperty(propDistThres, "0"));
        this.swATime = Integer.parseInt(props.getProperty(propSwATime, "1000"));
        this.swBTime = Integer.parseInt(props.getProperty(propSwBTime, "1000"));
        this.swCTime = Integer.parseInt(props.getProperty(propSwCTime, "1000"));
        this.swATimeOrDist = Byte.parseByte(props.getProperty(propSwATimeOrDist, "0"));
        this.swBTimeOrDist = Byte.parseByte(props.getProperty(propSwBTimeOrDist, "0"));
        this.swCTimeOrDist = Byte.parseByte(props.getProperty(propSwCTimeOrDist, "0"));
        this.swADist = Integer.parseInt(props.getProperty(propSwADist, "0"));
        this.swBDist = Integer.parseInt(props.getProperty(propSwBDist, "0"));
        this.swCDist = Integer.parseInt(props.getProperty(propSwCDist, "0"));
        this.unk1 = Short.parseShort(props.getProperty(propUnk1, "0"));
        this.unk2 = Byte.parseByte(props.getProperty(propUnk2, "0"));
        this.unk3 = Integer.parseInt(props.getProperty(propUnk3, "0"));
        this.unk4 = Integer.parseInt(props.getProperty(propUnk4, "0"));
    }
}

