/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import livegps.AppendableGpxTrackSegment;
import livegps.ILiveGpsSuppressor;
import livegps.LiveGpsData;
import livegps.SingleSegmentGpxTrack;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.tools.I18n;

public class LiveGpsLayer
extends GpxLayer
implements PropertyChangeListener {
    public static final String LAYER_NAME = I18n.tr((String)"LiveGPS layer");
    public static final String KEY_LIVEGPS_COLOR = "color.livegps.position";
    LatLon lastPos;
    WayPoint lastPoint;
    private final AppendableGpxTrackSegment trackSegment;
    float speed;
    float course;
    String status;
    boolean autocenter;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private ILiveGpsSuppressor suppressor;

    public LiveGpsLayer(GpxData data) {
        super(data, LAYER_NAME);
        this.trackSegment = new AppendableGpxTrackSegment();
        HashMap<String, Object> attr = new HashMap<String, Object>();
        attr.put("desc", "josm live gps");
        SingleSegmentGpxTrack trackBeingWritten = new SingleSegmentGpxTrack(this.trackSegment, attr);
        data.tracks.add(trackBeingWritten);
    }

    void setCurrentPosition(double lat, double lon) {
        LatLon thisPos = new LatLon(lat, lon);
        if (this.lastPos != null && thisPos.equalsEpsilon(this.lastPos)) {
            return;
        }
        this.lastPos = thisPos;
        this.lastPoint = new WayPoint(thisPos);
        this.lastPoint.attr.put("time", this.dateFormat.format(new Date()));
        this.trackSegment.addWaypoint(this.lastPoint);
        if (this.autocenter && this.allowRedraw()) {
            this.center();
        }
    }

    public void center() {
        if (this.lastPoint != null) {
            Main.map.mapView.zoomTo(this.lastPoint.getCoor());
        }
    }

    void setSpeed(float metresPerSecond) {
        this.speed = metresPerSecond;
    }

    void setCourse(float degrees) {
        this.course = degrees;
    }

    public void setAutoCenter(boolean ac) {
        this.autocenter = ac;
    }

    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        super.paint(g, mv, bounds);
        if (this.lastPoint != null) {
            Point screen = mv.getPoint(this.lastPoint.getCoor());
            g.setColor(Main.pref.getColor(KEY_LIVEGPS_COLOR, Color.RED));
            g.drawOval(screen.x - 10, screen.y - 10, 20, 20);
            g.drawOval(screen.x - 9, screen.y - 9, 18, 18);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        LiveGpsData data;
        if (!this.isVisible()) {
            return;
        }
        if ("gpsdata".equals(evt.getPropertyName()) && (data = (LiveGpsData)evt.getNewValue()).isFix()) {
            this.setCurrentPosition(data.getLatitude(), data.getLongitude());
            if (!Float.isNaN(data.getSpeed())) {
                this.setSpeed(data.getSpeed());
            }
            if (!Float.isNaN(data.getCourse())) {
                this.setCourse(data.getCourse());
            }
            if (!this.autocenter && this.allowRedraw()) {
                Main.map.repaint();
            }
        }
    }

    public void setSuppressor(ILiveGpsSuppressor suppressor) {
        this.suppressor = suppressor;
    }

    public ILiveGpsSuppressor getSuppressor() {
        return this.suppressor;
    }

    private boolean allowRedraw() {
        if (this.suppressor != null) {
            return this.suppressor.isAllowUpdate();
        }
        return true;
    }
}

