/*
 * Decompiled with CFR 0.152.
 */
package buildings_tools;

import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class AddressDialog
extends ExtendedDialog {
    private static String lhousenum;
    private static String lstreetname;
    private static boolean inc;
    private JTextField housenum = new JTextField();
    private JTextField streetname = new JTextField();
    private Choice cincdec = new Choice();
    private JPanel panel = new JPanel(new GridBagLayout());

    static {
        inc = true;
    }

    private void addLabelled(String str, Component c) {
        JLabel label = new JLabel(str);
        this.panel.add((Component)label, GBC.std());
        label.setLabelFor(c);
        this.panel.add(c, GBC.eol().fill(2));
    }

    public AddressDialog() {
        super(Main.parent, I18n.tr((String)"Building address"), new String[]{I18n.tr((String)"OK"), I18n.tr((String)"Cancel")}, true);
        this.contentConstraints = GBC.eol().fill().insets(15, 15, 15, 5);
        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        this.addLabelled(I18n.tr((String)"House number:"), this.housenum);
        this.addLabelled(I18n.tr((String)"Street Name:"), this.streetname);
        this.housenum.setText(AddressDialog.nextHouseNum());
        this.streetname.setText(lstreetname);
        this.cincdec.add(I18n.tr((String)"Increment"));
        this.cincdec.add(I18n.tr((String)"Decrement"));
        this.cincdec.select(inc ? 0 : 1);
        this.addLabelled(I18n.tr((String)"Numbers:"), this.cincdec);
        this.setContent(this.panel);
        this.setupDialog();
        this.setVisible(true);
    }

    private static String nextHouseNum() {
        if (lhousenum == null) {
            return "";
        }
        try {
            Integer num = NumberFormat.getInstance().parse(lhousenum).intValue();
            num = inc ? Integer.valueOf(num + 2) : Integer.valueOf(num - 2);
            return num.toString();
        }
        catch (ParseException e) {
            return lhousenum;
        }
    }

    public void saveValues() {
        lhousenum = this.housenum.getText();
        lstreetname = this.streetname.getText();
        inc = this.cincdec.getSelectedItem() == I18n.tr((String)"Increment");
    }

    public String getHouseNum() {
        return this.housenum.getText();
    }

    public String getStreetName() {
        return this.streetname.getText();
    }
}

