/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.tools.I18n;

public class MultipolygonTest
extends Test {
    protected static final int WRONG_MEMBER_TYPE = 1601;
    protected static final int WRONG_MEMBER_ROLE = 1602;
    protected static final int NON_CLOSED_WAY = 1603;
    protected static final int MISSING_OUTER_WAY = 1604;
    protected static final int INNER_WAY_OUTSIDE = 1605;
    protected static final int CROSSING_WAYS = 1606;

    public MultipolygonTest() {
        super(I18n.tr((String)"Multipolygon"), I18n.tr((String)"This test checks if multipolygons are valid"));
    }

    public void visit(Relation r) {
        if ("multipolygon".equals(r.get("type"))) {
            this.checkMembersAndRoles(r);
            Multipolygon polygon = new Multipolygon((NavigatableComponent)Main.map.mapView);
            polygon.load(r);
            if (polygon.hasNonClosedWays()) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Multipolygon is not closed"), 1603, (OsmPrimitive)r));
            }
            if (polygon.getOuterWays().isEmpty()) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"No outer way for multipolygon"), 1604, (OsmPrimitive)r));
            }
            for (RelationMember rm : r.getMembers()) {
                if (rm.getMember().isUsable()) continue;
                return;
            }
            for (Multipolygon.PolyData pdInner : polygon.getInnerPolygons()) {
                Multipolygon.PolyData pdOuter = polygon.findOuterPolygon(pdInner, polygon.getOuterPolygons());
                if (pdOuter == null) {
                    this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Multipolygon inner way is outside."), 1605, (OsmPrimitive)r));
                    continue;
                }
                if (pdOuter.contains(pdInner.poly) != Multipolygon.PolyData.Intersection.CROSSING) continue;
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Intersection between multipolygon ways"), 1606, (OsmPrimitive)r));
            }
        }
    }

    private void checkMembersAndRoles(Relation r) {
        for (RelationMember rm : r.getMembers()) {
            if (rm.isWay()) {
                if ("inner".equals(rm.getRole()) || "outer".equals(rm.getRole()) || !rm.hasRole()) continue;
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"No useful role for multipolygon member"), 1602, rm.getMember()));
                continue;
            }
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"Non-Way in multipolygon."), 1601, rm.getMember()));
        }
    }
}

