/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.plugins.validator.OSMValidatorPlugin;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class PreferenceEditor
implements PreferenceSetting {
    private OSMValidatorPlugin plugin;
    public static final String PREFIX = "validator";
    public static final String PREF_DEBUG = "validator.debug";
    public static final String PREF_LAYER = "validator.layer";
    public static final String PREF_TESTS = "validator.tests";
    public static final String PREF_USE_IGNORE = "validator.ignore";
    public static final String PREF_TESTS_BEFORE_UPLOAD = "validator.testsBeforeUpload";
    public static final String PREF_OTHER_UPLOAD = "validator.otherUpload";
    public static final String PREF_FILTER_BY_SELECTION = "validator.selectionFilter";
    private JCheckBox prefUseIgnore;
    private JCheckBox prefUseLayer;
    private JCheckBox prefOtherUpload;
    private Collection<Test> allTests;

    public PreferenceEditor(OSMValidatorPlugin plugin) {
        this.plugin = plugin;
    }

    public void addGui(PreferenceTabbedPane gui) {
        JPanel testPanel = new JPanel(new GridBagLayout());
        testPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.prefUseIgnore = new JCheckBox(I18n.tr((String)"Use ignore list."), Main.pref.getBoolean(PREF_USE_IGNORE, true));
        this.prefUseIgnore.setToolTipText(I18n.tr((String)"Use the ignore list to suppress warnings."));
        testPanel.add((Component)this.prefUseIgnore, GBC.eol());
        this.prefUseLayer = new JCheckBox(I18n.tr((String)"Use error layer."), Main.pref.getBoolean(PREF_LAYER, true));
        this.prefUseLayer.setToolTipText(I18n.tr((String)"Use the error layer to display problematic elements."));
        testPanel.add((Component)this.prefUseLayer, GBC.eol());
        this.prefOtherUpload = new JCheckBox(I18n.tr((String)"Show informational level on upload."), Main.pref.getBoolean(PREF_OTHER_UPLOAD, false));
        this.prefOtherUpload.setToolTipText(I18n.tr((String)"Show the informational tests in the upload check windows."));
        testPanel.add((Component)this.prefOtherUpload, GBC.eol());
        GBC a = GBC.eol().insets(-5, 0, 0, 0);
        a.anchor = 13;
        testPanel.add((Component)new JLabel(I18n.tr((String)"On demand")), GBC.std());
        testPanel.add((Component)new JLabel(I18n.tr((String)"On upload")), a);
        this.allTests = OSMValidatorPlugin.getTests();
        for (Test test : this.allTests) {
            test.addGui(testPanel);
        }
        JScrollPane testPane = new JScrollPane(testPanel, 20, 30);
        testPane.setBorder(null);
        String description = I18n.tr((String)"An OSM data validator that checks for common errors made by users and editor programs.");
        JPanel tab = gui.createPreferenceTab(PREFIX, I18n.tr((String)"Data validator"), description);
        tab.add((Component)testPane, GBC.eol().fill(1));
        tab.add(GBC.glue((int)0, (int)10), a);
    }

    public boolean ok() {
        StringBuilder tests = new StringBuilder();
        StringBuilder testsBeforeUpload = new StringBuilder();
        Boolean res = false;
        for (Test test : this.allTests) {
            if (test.ok()) {
                res = false;
            }
            String name = ((Object)((Object)test)).getClass().getSimpleName();
            tests.append(',').append(name).append('=').append(test.enabled);
            testsBeforeUpload.append(',').append(name).append('=').append(test.testBeforeUpload);
        }
        if (tests.length() > 0) {
            tests = tests.deleteCharAt(0);
        }
        if (testsBeforeUpload.length() > 0) {
            testsBeforeUpload = testsBeforeUpload.deleteCharAt(0);
        }
        this.plugin.initializeTests(this.allTests);
        Main.pref.put(PREF_TESTS, tests.toString());
        Main.pref.put(PREF_TESTS_BEFORE_UPLOAD, testsBeforeUpload.toString());
        Main.pref.put(PREF_USE_IGNORE, this.prefUseIgnore.isSelected());
        Main.pref.put(PREF_OTHER_UPLOAD, this.prefOtherUpload.isSelected());
        Main.pref.put(PREF_LAYER, this.prefUseLayer.isSelected());
        return false;
    }
}

