/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.plugins.tageditor.TagEditorDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchAction
extends JosmAction
implements SelectionChangedListener {
    protected void registerAsMenuItem() {
        MainMenu menu = Main.main.menu;
        JMenu edit = null;
        JMenuItem item = new JMenuItem((Action)((Object)this));
        for (int i = 0; i < menu.getMenuCount(); ++i) {
            if (menu.getMenu(i) == null || !I18n.tr((String)"Edit").equals(menu.getMenu(i).getText())) continue;
            edit = menu.getMenu(i);
            break;
        }
        if (edit != null) {
            edit.insertSeparator(edit.getItemCount());
            JMenuItem mitem = edit.insert((Action)((Object)this), edit.getItemCount());
            mitem.setAccelerator(KeyStroke.getKeyStroke('T'));
        } else if (menu.getMenuCount() > 0) {
            edit = menu.getMenu(0);
            JMenuItem mitem = edit.insert((Action)((Object)this), 0);
            mitem.setAccelerator(KeyStroke.getKeyStroke('T'));
        }
        item.setVisible(true);
    }

    public LaunchAction() {
        super(I18n.tr((String)"Edit tags"), null, I18n.tr((String)"Launches the tag editor dialog"), Shortcut.registerShortcut((String)"edit:launchtageditor", (String)I18n.tr((String)"Launches the tag editor dialog"), (int)84, (int)3), false);
        DataSet.selListeners.add(this);
        this.registerAsMenuItem();
        this.setEnabled(false);
    }

    protected void launchEditor() {
        if (!this.isEnabled()) {
            return;
        }
        TagEditorDialog dialog = TagEditorDialog.getInstance();
        dialog.startEditSession();
        dialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        this.launchEditor();
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        this.setEnabled(newSelection != null && newSelection.size() > 0);
    }
}

