/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.tagspec;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.plugins.tageditor.ac.AutoCompletionContext;
import org.openstreetmap.josm.plugins.tageditor.tagspec.LableSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagSpecification {
    private String key;
    private String type;
    private boolean applicableToNode = true;
    private boolean applicableToWay = true;
    private boolean applicableToRelation = true;
    private ArrayList<LableSpecification> lables = new ArrayList();

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<TagSpecification ");
        builder.append("key=\"").append(this.key).append("\"").append(", ");
        builder.append("type=\"").append(this.type).append("\"").append(", ");
        builder.append("applicable-to-node=\"").append(this.applicableToNode).append("\"").append(", ");
        builder.append("applicable-to-way=\"").append(this.applicableToWay).append("\"").append(", ");
        builder.append("applicable-to-relation=\"").append(this.applicableToRelation).append("\"");
        builder.append(" />");
        return builder.toString();
    }

    public List<LableSpecification> getLables() {
        return this.lables;
    }

    public void setLables(List<LableSpecification> lables) throws IllegalArgumentException {
        if (lables == null) {
            throw new IllegalArgumentException("argument 'lables' must not be null");
        }
        this.lables.clear();
        for (LableSpecification l : lables) {
            this.lables.add(l);
        }
    }

    public void addLable(LableSpecification lable) throws IllegalArgumentException {
        if (lable == null) {
            throw new IllegalArgumentException("argument 'lable' must not be null");
        }
        if (!this.lables.contains(lable)) {
            this.lables.add(lable);
        }
    }

    public boolean isApplicable(AutoCompletionContext context) {
        boolean ret = false;
        if (context.isSelectionEmpty()) {
            ret = true;
        } else {
            ret = ret || this.applicableToNode && context.isSelectionIncludesNodes();
            ret = ret || this.applicableToWay && context.isSelectionIncludesWays();
            ret = ret || this.applicableToRelation && context.isSelectionIncludesRelations();
        }
        return ret;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isApplicableToNode() {
        return this.applicableToNode;
    }

    public void setApplicableToNode(boolean applicableToNode) {
        this.applicableToNode = applicableToNode;
    }

    public boolean isApplicableToWay() {
        return this.applicableToWay;
    }

    public void setApplicableToWay(boolean applicableToWay) {
        this.applicableToWay = applicableToWay;
    }

    public boolean isApplicableToRelation() {
        return this.applicableToRelation;
    }

    public void setApplicableToRelation(boolean applicableToRelation) {
        this.applicableToRelation = applicableToRelation;
    }
}

