/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.editor.old;

import java.awt.Component;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import org.openstreetmap.josm.plugins.tageditor.ac.AutoCompletionContext;
import org.openstreetmap.josm.plugins.tageditor.ac.IAutoCompletionListListener;
import org.openstreetmap.josm.plugins.tageditor.editor.TagEditorModel;
import org.openstreetmap.josm.plugins.tageditor.editor.old.AutoCompletionCache;
import org.openstreetmap.josm.plugins.tageditor.editor.old.AutoCompletionList;
import org.openstreetmap.josm.plugins.tageditor.editor.old.TagFieldEditor;
import org.openstreetmap.josm.plugins.tageditor.editor.old.TagModel;

public class TableCellEditor
extends AbstractCellEditor
implements javax.swing.table.TableCellEditor,
IAutoCompletionListListener {
    private static Logger logger = Logger.getLogger(TableCellEditor.class.getName());
    private TagFieldEditor editor = new TagFieldEditor();
    private TagModel currentTag = null;
    private TagEditorModel tagEditorModel = null;
    private int currentColumn = 0;
    private AutoCompletionCache acCache = new AutoCompletionCache();
    private AutoCompletionList autoCompletionList = null;

    protected void initAutoCompletionListForKeys(TagEditorModel model, TagModel currentTag) {
        AutoCompletionContext context = new AutoCompletionContext();
        context.initFromJOSMSelection();
        if (this.autoCompletionList == null) {
            logger.warning("autoCompletionList is null. Make sure an instance of AutoCompletionList is injected into TableCellEditor.");
            return;
        }
        this.autoCompletionList.clear();
        for (String key : this.acCache.getKeys()) {
        }
        for (String key : model.getKeys()) {
            if (key.equals(currentTag.getName())) continue;
            this.autoCompletionList.remove(key);
        }
        this.autoCompletionList.fireTableDataChanged();
    }

    protected void initAutoCompletionListForValues(String forKey) {
        if (this.autoCompletionList == null) {
            logger.warning("autoCompletionList is null. Make sure an instance of AutoCompletionList is injected into TableCellEditor.");
            return;
        }
        this.autoCompletionList.clear();
        AutoCompletionContext context = new AutoCompletionContext();
        context.initFromJOSMSelection();
        for (String value : this.acCache.getValues(forKey)) {
        }
        if (this.currentTag.getValueCount() > 1) {
            for (String value : this.currentTag.getValues()) {
            }
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.currentTag = (TagModel)value;
        if (column == 0) {
            this.editor.setText(this.currentTag.getName());
            this.currentColumn = 0;
            TagEditorModel model = (TagEditorModel)((Object)table.getModel());
            this.initAutoCompletionListForKeys(model, this.currentTag);
            return this.editor;
        }
        if (column == 1) {
            if (this.currentTag.getValueCount() == 0) {
                this.editor.setText("");
            } else if (this.currentTag.getValueCount() == 1) {
                this.editor.setText(this.currentTag.getValues().get(0));
            } else {
                this.editor.setText("");
            }
            this.currentColumn = 1;
            this.initAutoCompletionListForValues(this.currentTag.getName());
            return this.editor;
        }
        logger.warning("column this table cell editor is requested for is out of range. column=" + column);
        return null;
    }

    public Object getCellEditorValue() {
        return this.editor.getText();
    }

    public void cancelCellEditing() {
        super.cancelCellEditing();
    }

    public boolean stopCellEditing() {
        if (this.tagEditorModel == null) {
            logger.warning("no tag editor model set. Can't update edited values. Please set tag editor model first");
            return super.stopCellEditing();
        }
        if (this.currentColumn == 0 || this.currentColumn != 1 || this.currentTag.getValueCount() > 1 && !this.editor.getText().equals("") || this.currentTag.getValueCount() <= 1) {
            // empty if block
        }
        return super.stopCellEditing();
    }

    public AutoCompletionList getAutoCompletionList() {
        return this.autoCompletionList;
    }

    public void setAutoCompletionList(AutoCompletionList autoCompletionList) {
        this.autoCompletionList = autoCompletionList;
        this.editor.setAutoCompletionList(autoCompletionList);
    }

    public void setAutoCompletionCache(AutoCompletionCache acCache) {
        this.acCache = acCache;
    }

    public void autoCompletionItemSelected(String item) {
        this.editor.setText(item);
        this.editor.selectAll();
        this.editor.requestFocus();
    }

    public TagFieldEditor getEditor() {
        return this.editor;
    }

    public void setTagEditorModel(TagEditorModel tagEditorModel) {
        this.tagEditorModel = tagEditorModel;
    }
}

