/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.plugins.tageditor.editor.TagEditorModel;
import org.openstreetmap.josm.plugins.tageditor.preset.Item;
import org.openstreetmap.josm.plugins.tageditor.preset.Tag;
import org.openstreetmap.josm.tools.I18n;

public class TableCellRenderer
extends JLabel
implements javax.swing.table.TableCellRenderer {
    private static Logger logger = Logger.getLogger(TableCellRenderer.class.getName());
    public static final Color BG_COLOR_HIGHLIGHTED = new Color(255, 255, 204);
    private Font fontStandard = this.getFont();
    private Font fontItalic = this.fontStandard.deriveFont(2);

    public TableCellRenderer() {
        this.setOpaque(true);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    protected void renderTagName(TagModel tag) {
        this.setText(tag.getName());
    }

    protected void renderTagValue(TagModel tag) {
        if (tag.getValueCount() == 0) {
            this.setText("");
        } else if (tag.getValueCount() == 1) {
            this.setText((String)tag.getValues().get(0));
        } else if (tag.getValueCount() > 1) {
            this.setText(I18n.tr((String)"multiple"));
            this.setFont(this.fontItalic);
        }
    }

    protected void resetRenderer() {
        this.setText("");
        this.setIcon(null);
        this.setFont(this.fontStandard);
    }

    protected TagEditorModel getModel(JTable table) {
        return (TagEditorModel)((Object)table.getModel());
    }

    protected boolean belongsToSelectedPreset(TagModel tagModel, TagEditorModel model) {
        if (tagModel.getName().trim().equals("") && tagModel.getValue().equals("")) {
            return false;
        }
        Item item = (Item)model.getAppliedPresetsModel().getSelectedItem();
        if (item == null) {
            return false;
        }
        for (Tag tag : item.getTags()) {
            if (!(tag.getValue() == null ? tagModel.getName().equals(tag.getKey()) : tagModel.getName().equals(tag.getKey()) && tagModel.getValue().equals(tag.getValue()))) continue;
            return true;
        }
        return false;
    }

    protected void renderBackgroundColor(TagModel tagModel, TagEditorModel model) {
        this.setBackground(UIManager.getColor("Table.background"));
        if (this.belongsToSelectedPreset(tagModel, model)) {
            this.setBackground(BG_COLOR_HIGHLIGHTED);
        }
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
        this.resetRenderer();
        if (isSelected) {
            this.setBackground(UIManager.getColor("Table.selectionBackground"));
            this.setForeground(UIManager.getColor("Table.selectionForeground"));
        } else {
            this.setBackground(UIManager.getColor("Table.background"));
            this.setForeground(UIManager.getColor("Table.foreground"));
        }
        TagModel tagModel = (TagModel)value;
        switch (vColIndex) {
            case 0: {
                this.renderTagName(tagModel);
                break;
            }
            case 1: {
                this.renderTagValue(tagModel);
            }
        }
        this.renderBackgroundColor(tagModel, (TagEditorModel)((Object)table.getModel()));
        if (hasFocus && isSelected && table.getSelectedColumnCount() == 1 && table.getSelectedRowCount() == 1 && table.getEditorComponent() != null) {
            table.getEditorComponent().requestFocusInWindow();
        }
        return this;
    }
}

