/*
 * Decompiled with CFR 0.152.
 */
package public_transport;

import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoutePatternAction
extends JosmAction {
    private static JDialog jDialog = null;
    private static JTabbedPane tabbedPane = null;
    private static DefaultListModel dlm = null;
    private static ItineraryTableModel itineraryData = null;
    private static JTable itineraryTable = null;
    private static StoplistTableModel stoplistData = null;
    private static JTable stoplistTable = null;
    private static JList rpJList = null;
    private static JCheckBox cbRight = null;
    private static JCheckBox cbLeft = null;
    private static JTextField tfSuggestStopsLimit = null;
    private static Vector<Relation> routes = new Vector();
    private static Relation currentRoute = null;
    private static Vector<RelationMember> markedWays = new Vector();
    private static Vector<RelationMember> markedNodes = new Vector();

    public RoutePatternAction() {
        super(I18n.tr((String)"Route patterns ..."), null, I18n.tr((String)"Edit Route patterns for public transport"), null, true);
    }

    public void actionPerformed(ActionEvent event) {
        SegmentMetric sm;
        Way way;
        Vector<SegmentMetric> segmentMetrics;
        String role;
        Vector<RelationMember> itemsToReflect;
        RelationMember curMember;
        Iterator<RelationMember> relIter;
        OsmPrimitive[] osmp;
        BoundingXYVisitor box;
        Frame frame = JOptionPane.getFrameForComponent(Main.parent);
        DataSet mainDataSet = Main.main.getCurrentDataSet();
        if (jDialog == null) {
            jDialog = new JDialog(frame, "Route Patterns", false);
            tabbedPane = new JTabbedPane();
            JPanel tabOverview = new JPanel();
            tabbedPane.addTab(I18n.marktr((String)"Overview"), tabOverview);
            JPanel tabTags = new JPanel();
            tabbedPane.addTab(I18n.marktr((String)"Tags"), tabTags);
            JPanel tabItinerary = new JPanel();
            tabbedPane.addTab(I18n.marktr((String)"Itinerary"), tabItinerary);
            JPanel tabStoplist = new JPanel();
            tabbedPane.addTab(I18n.marktr((String)"Stops"), tabStoplist);
            JPanel tabMeta = new JPanel();
            tabbedPane.addTab(I18n.marktr((String)"Meta"), tabMeta);
            tabbedPane.setEnabledAt(0, true);
            tabbedPane.setEnabledAt(1, false);
            tabbedPane.setEnabledAt(2, false);
            tabbedPane.setEnabledAt(3, false);
            tabbedPane.setEnabledAt(4, false);
            jDialog.add(tabbedPane);
            JPanel contentPane = tabOverview;
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints layoutCons = new GridBagConstraints();
            contentPane.setLayout(gridbag);
            JLabel headline = new JLabel("Existing route patterns:");
            layoutCons.gridx = 0;
            layoutCons.gridy = 0;
            layoutCons.weightx = 0.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(headline, layoutCons);
            contentPane.add(headline);
            dlm = new DefaultListModel();
            rpJList = new JList(dlm);
            JScrollPane rpListSP = new JScrollPane(rpJList);
            Object[] data = new String[]{"1", "2", "3", "4", "5", "6"};
            dlm.copyInto(data);
            rpJList.setSelectionMode(0);
            rpJList.addListSelectionListener(new RoutesLSL(this));
            layoutCons.gridx = 0;
            layoutCons.gridy = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 1.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(rpListSP, layoutCons);
            contentPane.add(rpListSP);
            JButton bRefresh = new JButton("Refresh");
            bRefresh.setActionCommand("routePattern.refresh");
            bRefresh.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 0;
            layoutCons.gridy = 2;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bRefresh, layoutCons);
            contentPane.add(bRefresh);
            contentPane = tabItinerary;
            gridbag = new GridBagLayout();
            layoutCons = new GridBagConstraints();
            contentPane.setLayout(gridbag);
            itineraryTable = new JTable();
            itineraryData = new ItineraryTableModel();
            itineraryData.addColumn("Name/Id");
            itineraryData.addColumn("Role");
            itineraryTable.setModel(itineraryData);
            JScrollPane tableSP = new JScrollPane(itineraryTable);
            JComboBox<String> comboBox = new JComboBox<String>();
            comboBox.addItem("");
            comboBox.addItem("forward");
            comboBox.addItem("backward");
            itineraryTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(comboBox));
            itineraryData.addTableModelListener(new ItineraryTableModelListener());
            layoutCons.gridx = 0;
            layoutCons.gridy = 0;
            layoutCons.gridwidth = 3;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 1.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(tableSP, layoutCons);
            contentPane.add(tableSP);
            JButton bShow = new JButton("Show");
            bShow.setActionCommand("routePattern.itineraryShow");
            bShow.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 0;
            layoutCons.gridy = 1;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bShow, layoutCons);
            contentPane.add(bShow);
            JButton bMark = new JButton("Mark");
            bMark.setActionCommand("routePattern.itineraryMark");
            bMark.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 0;
            layoutCons.gridy = 2;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bMark, layoutCons);
            contentPane.add(bMark);
            JButton bAdd = new JButton("Add");
            bAdd.setActionCommand("routePattern.itineraryAdd");
            bAdd.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 1;
            layoutCons.gridy = 1;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bAdd, layoutCons);
            contentPane.add(bAdd);
            JButton bDelete = new JButton("Delete");
            bDelete.setActionCommand("routePattern.itineraryDelete");
            bDelete.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 1;
            layoutCons.gridy = 2;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bDelete, layoutCons);
            contentPane.add(bDelete);
            JButton bSort = new JButton("Sort");
            bSort.setActionCommand("routePattern.itinerarySort");
            bSort.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 2;
            layoutCons.gridy = 1;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bSort, layoutCons);
            contentPane.add(bSort);
            JButton bReflect = new JButton("Reflect");
            bReflect.setActionCommand("routePattern.itineraryReflect");
            bReflect.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 2;
            layoutCons.gridy = 2;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bReflect, layoutCons);
            contentPane.add(bReflect);
            contentPane = tabStoplist;
            gridbag = new GridBagLayout();
            layoutCons = new GridBagConstraints();
            contentPane.setLayout(gridbag);
            stoplistTable = new JTable();
            stoplistData = new StoplistTableModel();
            stoplistData.addColumn("Name/Id");
            stoplistData.addColumn("Role");
            stoplistTable.setModel(stoplistData);
            tableSP = new JScrollPane(stoplistTable);
            comboBox = new JComboBox();
            comboBox.addItem("");
            comboBox.addItem("forward");
            comboBox.addItem("backward");
            stoplistTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(comboBox));
            stoplistData.addTableModelListener(new StoplistTableModelListener());
            layoutCons.gridx = 0;
            layoutCons.gridy = 0;
            layoutCons.gridwidth = 3;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 1.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(tableSP, layoutCons);
            contentPane.add(tableSP);
            bShow = new JButton("Show");
            bShow.setActionCommand("routePattern.stoplistShow");
            bShow.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 0;
            layoutCons.gridy = 1;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bShow, layoutCons);
            contentPane.add(bShow);
            bMark = new JButton("Mark");
            bMark.setActionCommand("routePattern.stoplistMark");
            bMark.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 0;
            layoutCons.gridy = 2;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bMark, layoutCons);
            contentPane.add(bMark);
            bAdd = new JButton("Add");
            bAdd.setActionCommand("routePattern.stoplistAdd");
            bAdd.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 1;
            layoutCons.gridy = 1;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bAdd, layoutCons);
            contentPane.add(bAdd);
            bDelete = new JButton("Delete");
            bDelete.setActionCommand("routePattern.stoplistDelete");
            bDelete.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 1;
            layoutCons.gridy = 2;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bDelete, layoutCons);
            contentPane.add(bDelete);
            bSort = new JButton("Sort");
            bSort.setActionCommand("routePattern.stoplistSort");
            bSort.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 2;
            layoutCons.gridy = 1;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bSort, layoutCons);
            contentPane.add(bSort);
            bReflect = new JButton("Reflect");
            bReflect.setActionCommand("routePattern.stoplistReflect");
            bReflect.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 2;
            layoutCons.gridy = 2;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bReflect, layoutCons);
            contentPane.add(bReflect);
            contentPane = tabMeta;
            gridbag = new GridBagLayout();
            layoutCons = new GridBagConstraints();
            contentPane.setLayout(gridbag);
            JLabel rightleft = new JLabel("Stops are possible on the");
            layoutCons.gridx = 0;
            layoutCons.gridy = 1;
            layoutCons.gridwidth = 2;
            layoutCons.weightx = 0.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(rightleft, layoutCons);
            contentPane.add(rightleft);
            cbRight = new JCheckBox("right hand side", true);
            layoutCons.gridx = 0;
            layoutCons.gridy = 2;
            layoutCons.gridwidth = 2;
            layoutCons.weightx = 0.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(cbRight, layoutCons);
            contentPane.add(cbRight);
            cbLeft = new JCheckBox("left hand side", false);
            layoutCons.gridx = 0;
            layoutCons.gridy = 3;
            layoutCons.gridwidth = 2;
            layoutCons.weightx = 0.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(cbLeft, layoutCons);
            contentPane.add(cbLeft);
            JLabel maxdist = new JLabel("Maximum distance from route");
            layoutCons.gridx = 0;
            layoutCons.gridy = 4;
            layoutCons.gridwidth = 2;
            layoutCons.weightx = 0.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(maxdist, layoutCons);
            contentPane.add(maxdist);
            tfSuggestStopsLimit = new JTextField("20", 4);
            layoutCons.gridx = 0;
            layoutCons.gridy = 5;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 0.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(tfSuggestStopsLimit, layoutCons);
            contentPane.add(tfSuggestStopsLimit);
            JLabel meters = new JLabel("meters");
            layoutCons.gridx = 1;
            layoutCons.gridy = 5;
            layoutCons.gridwidth = 1;
            layoutCons.weightx = 0.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(meters, layoutCons);
            contentPane.add(meters);
            JButton bSuggestStops = new JButton("Suggest Stops");
            bSuggestStops.setActionCommand("routePattern.metaSuggestStops");
            bSuggestStops.addActionListener((ActionListener)((Object)this));
            layoutCons.gridx = 0;
            layoutCons.gridy = 6;
            layoutCons.gridwidth = 3;
            layoutCons.weightx = 1.0;
            layoutCons.weighty = 0.0;
            layoutCons.fill = 1;
            gridbag.setConstraints(bSuggestStops, layoutCons);
            contentPane.add(bSuggestStops);
            jDialog.pack();
        }
        if ("routePattern.refresh".equals(event.getActionCommand())) {
            this.refreshData();
        } else if ("routePattern.itineraryShow".equals(event.getActionCommand())) {
            box = new BoundingXYVisitor();
            if (itineraryTable.getSelectedRowCount() > 0) {
                for (int i = 0; i < itineraryData.getRowCount(); ++i) {
                    if (!itineraryTable.isRowSelected(i) || RoutePatternAction.itineraryData.ways.elementAt(i) == null) continue;
                    RoutePatternAction.itineraryData.ways.elementAt(i).visit((Visitor)box);
                }
            } else {
                for (int i = 0; i < itineraryData.getRowCount(); ++i) {
                    if (RoutePatternAction.itineraryData.ways.elementAt(i) == null) continue;
                    RoutePatternAction.itineraryData.ways.elementAt(i).visit((Visitor)box);
                }
            }
            if (box.getBounds() == null) {
                return;
            }
            box.enlargeBoundingBox();
            Main.map.mapView.recalculateCenterScale(box);
        } else if ("routePattern.itineraryMark".equals(event.getActionCommand())) {
            RelationMember markedWay;
            osmp = new OsmPrimitive[]{null};
            Main.main.getCurrentDataSet().setSelected((PrimitiveId[])osmp);
            markedWays.clear();
            if (itineraryTable.getSelectedRowCount() > 0) {
                for (int i = 0; i < itineraryData.getRowCount(); ++i) {
                    if (!itineraryTable.isRowSelected(i) || RoutePatternAction.itineraryData.ways.elementAt(i) == null) continue;
                    mainDataSet.addSelected(new PrimitiveId[]{(PrimitiveId)RoutePatternAction.itineraryData.ways.elementAt(i)});
                    markedWay = new RelationMember((String)itineraryData.getValueAt(i, 1), (OsmPrimitive)RoutePatternAction.itineraryData.ways.elementAt(i));
                    markedWays.addElement(markedWay);
                }
            } else {
                for (int i = 0; i < itineraryData.getRowCount(); ++i) {
                    if (RoutePatternAction.itineraryData.ways.elementAt(i) == null) continue;
                    mainDataSet.addSelected(new PrimitiveId[]{(PrimitiveId)RoutePatternAction.itineraryData.ways.elementAt(i)});
                    markedWay = new RelationMember((String)itineraryData.getValueAt(i, 1), (OsmPrimitive)RoutePatternAction.itineraryData.ways.elementAt(i));
                    markedWays.addElement(markedWay);
                }
            }
        } else if ("routePattern.itineraryAdd".equals(event.getActionCommand())) {
            int insPos = itineraryTable.getSelectedRow();
            relIter = markedWays.iterator();
            TreeSet<Way> addedWays = new TreeSet<Way>();
            if (mainDataSet == null) {
                return;
            }
            while (relIter.hasNext()) {
                curMember = relIter.next();
                if (!curMember.isWay() || !mainDataSet.isSelected((OsmPrimitive)curMember.getWay())) continue;
                itineraryData.insertRow(insPos, curMember.getWay(), curMember.getRole());
                if (insPos >= 0) {
                    ++insPos;
                }
                addedWays.add(curMember.getWay());
            }
            Collection selectedWays = mainDataSet.getSelectedWays();
            for (Way curMember2 : selectedWays) {
                if (addedWays.contains(curMember2)) continue;
                itineraryData.insertRow(insPos, curMember2, "");
                if (insPos < 0) continue;
                ++insPos;
            }
            if (insPos > 0 && insPos < itineraryData.getRowCount()) {
                while (insPos < itineraryData.getRowCount() && RoutePatternAction.itineraryData.ways.elementAt(insPos) == null) {
                    ++insPos;
                }
                itineraryTable.removeRowSelectionInterval(0, itineraryData.getRowCount() - 1);
                if (insPos < itineraryData.getRowCount()) {
                    itineraryTable.addRowSelectionInterval(insPos, insPos);
                }
            }
            this.cleanupGaps();
            this.rebuildWays();
        } else if ("routePattern.itineraryDelete".equals(event.getActionCommand())) {
            for (int i = itineraryData.getRowCount() - 1; i >= 0; --i) {
                if (!itineraryTable.isRowSelected(i) || RoutePatternAction.itineraryData.ways.elementAt(i) == null) continue;
                RoutePatternAction.itineraryData.ways.removeElementAt(i);
                itineraryData.removeRow(i);
            }
            this.cleanupGaps();
            this.rebuildWays();
        } else if ("routePattern.itinerarySort".equals(event.getActionCommand())) {
            int i;
            TreeSet<Way> usedWays = new TreeSet<Way>();
            TreeMap<Node, LinkedList<RelationMember>> frontNodes = new TreeMap<Node, LinkedList<RelationMember>>();
            TreeMap<Node, LinkedList<RelationMember>> backNodes = new TreeMap<Node, LinkedList<RelationMember>>();
            Vector<LinkedList<RelationMember>> loops = new Vector<LinkedList<RelationMember>>();
            int insPos = itineraryTable.getSelectedRow();
            if (itineraryTable.getSelectedRowCount() > 0) {
                for (i = itineraryData.getRowCount() - 1; i >= 0; --i) {
                    if (!itineraryTable.isRowSelected(i) || RoutePatternAction.itineraryData.ways.elementAt(i) == null) continue;
                    if (!usedWays.contains(RoutePatternAction.itineraryData.ways.elementAt(i))) {
                        this.addWayToSortingData(RoutePatternAction.itineraryData.ways.elementAt(i), frontNodes, backNodes, loops);
                        usedWays.add(RoutePatternAction.itineraryData.ways.elementAt(i));
                    }
                    RoutePatternAction.itineraryData.ways.removeElementAt(i);
                    itineraryData.removeRow(i);
                }
            } else {
                for (i = itineraryData.getRowCount() - 1; i >= 0; --i) {
                    if (RoutePatternAction.itineraryData.ways.elementAt(i) == null || usedWays.contains(RoutePatternAction.itineraryData.ways.elementAt(i))) continue;
                    this.addWayToSortingData(RoutePatternAction.itineraryData.ways.elementAt(i), frontNodes, backNodes, loops);
                    usedWays.add(RoutePatternAction.itineraryData.ways.elementAt(i));
                }
                itineraryData.clear();
            }
            Iterator entryIter = frontNodes.entrySet().iterator();
            while (entryIter.hasNext()) {
                for (RelationMember curMember3 : (LinkedList)entryIter.next().getValue()) {
                    itineraryData.insertRow(insPos, curMember3.getWay(), curMember3.getRole());
                    if (insPos < 0) continue;
                    ++insPos;
                }
            }
            Iterator listIter = loops.iterator();
            while (listIter.hasNext()) {
                for (RelationMember curMember4 : (LinkedList)listIter.next()) {
                    itineraryData.insertRow(insPos, curMember4.getWay(), curMember4.getRole());
                    if (insPos < 0) continue;
                    ++insPos;
                }
            }
            this.cleanupGaps();
            this.rebuildWays();
        } else if ("routePattern.itineraryReflect".equals(event.getActionCommand())) {
            RelationMember markedWay;
            int i;
            itemsToReflect = new Vector<RelationMember>();
            int insPos = itineraryTable.getSelectedRow();
            if (itineraryTable.getSelectedRowCount() > 0) {
                for (i = itineraryData.getRowCount() - 1; i >= 0; --i) {
                    if (!itineraryTable.isRowSelected(i) || RoutePatternAction.itineraryData.ways.elementAt(i) == null) continue;
                    role = (String)itineraryData.getValueAt(i, 1);
                    role = "backward".equals(role) ? "forward" : ("forward".equals(role) ? "backward" : "backward");
                    markedWay = new RelationMember(role, (OsmPrimitive)RoutePatternAction.itineraryData.ways.elementAt(i));
                    itemsToReflect.addElement(markedWay);
                    RoutePatternAction.itineraryData.ways.removeElementAt(i);
                    itineraryData.removeRow(i);
                }
            } else {
                for (i = itineraryData.getRowCount() - 1; i >= 0; --i) {
                    if (RoutePatternAction.itineraryData.ways.elementAt(i) == null) continue;
                    role = (String)itineraryData.getValueAt(i, 1);
                    role = "backward".equals(role) ? "forward" : ("forward".equals(role) ? "backward" : "backward");
                    markedWay = new RelationMember(role, (OsmPrimitive)RoutePatternAction.itineraryData.ways.elementAt(i));
                    itemsToReflect.addElement(markedWay);
                }
                itineraryData.clear();
            }
            int startPos = insPos;
            for (RelationMember curMember5 : itemsToReflect) {
                if (!curMember5.isWay()) continue;
                itineraryData.insertRow(insPos, curMember5.getWay(), curMember5.getRole());
                if (insPos < 0) continue;
                ++insPos;
            }
            if (insPos >= 0) {
                itineraryTable.addRowSelectionInterval(startPos, insPos - 1);
            }
            this.cleanupGaps();
            this.rebuildWays();
        } else if ("routePattern.stoplistShow".equals(event.getActionCommand())) {
            box = new BoundingXYVisitor();
            if (stoplistTable.getSelectedRowCount() > 0) {
                for (int i = 0; i < stoplistData.getRowCount(); ++i) {
                    if (!stoplistTable.isRowSelected(i)) continue;
                    RoutePatternAction.stoplistData.nodes.elementAt(i).visit((Visitor)box);
                }
            } else {
                for (int i = 0; i < stoplistData.getRowCount(); ++i) {
                    RoutePatternAction.stoplistData.nodes.elementAt(i).visit((Visitor)box);
                }
            }
            if (box.getBounds() == null) {
                return;
            }
            box.enlargeBoundingBox();
            Main.map.mapView.recalculateCenterScale(box);
        } else if ("routePattern.stoplistMark".equals(event.getActionCommand())) {
            RelationMember markedNode;
            osmp = new OsmPrimitive[]{null};
            Main.main.getCurrentDataSet().setSelected((PrimitiveId[])osmp);
            markedNodes.clear();
            if (stoplistTable.getSelectedRowCount() > 0) {
                for (int i = 0; i < stoplistData.getRowCount(); ++i) {
                    if (!stoplistTable.isRowSelected(i)) continue;
                    mainDataSet.addSelected(new PrimitiveId[]{(PrimitiveId)RoutePatternAction.stoplistData.nodes.elementAt(i)});
                    markedNode = new RelationMember((String)stoplistData.getValueAt(i, 1), (OsmPrimitive)RoutePatternAction.stoplistData.nodes.elementAt(i));
                    markedNodes.addElement(markedNode);
                }
            } else {
                for (int i = 0; i < stoplistData.getRowCount(); ++i) {
                    mainDataSet.addSelected(new PrimitiveId[]{(PrimitiveId)RoutePatternAction.stoplistData.nodes.elementAt(i)});
                    markedNode = new RelationMember((String)stoplistData.getValueAt(i, 1), (OsmPrimitive)RoutePatternAction.stoplistData.nodes.elementAt(i));
                    markedNodes.addElement(markedNode);
                }
            }
        } else if ("routePattern.stoplistAdd".equals(event.getActionCommand())) {
            int insPos = stoplistTable.getSelectedRow();
            relIter = markedNodes.iterator();
            TreeSet<Node> addedNodes = new TreeSet<Node>();
            if (mainDataSet == null) {
                return;
            }
            while (relIter.hasNext()) {
                curMember = relIter.next();
                if (!curMember.isNode() || !mainDataSet.isSelected((OsmPrimitive)curMember.getNode())) continue;
                stoplistData.insertRow(insPos, curMember.getNode(), curMember.getRole());
                if (insPos >= 0) {
                    ++insPos;
                }
                addedNodes.add(curMember.getNode());
            }
            Collection selectedNodes = mainDataSet.getSelectedNodes();
            for (Way curMember2 : selectedNodes) {
                if (addedNodes.contains(curMember2)) continue;
                stoplistData.insertRow(insPos, (Node)curMember2, "");
                if (insPos < 0) continue;
                ++insPos;
            }
            if (insPos > 0 && insPos < stoplistData.getRowCount()) {
                while (insPos < stoplistData.getRowCount() && RoutePatternAction.stoplistData.nodes.elementAt(insPos) == null) {
                    ++insPos;
                }
                stoplistTable.removeRowSelectionInterval(0, stoplistData.getRowCount() - 1);
                if (insPos < stoplistData.getRowCount()) {
                    stoplistTable.addRowSelectionInterval(insPos, insPos);
                }
            }
            this.rebuildNodes();
        } else if ("routePattern.stoplistDelete".equals(event.getActionCommand())) {
            for (int i = stoplistData.getRowCount() - 1; i >= 0; --i) {
                if (!stoplistTable.isRowSelected(i)) continue;
                RoutePatternAction.stoplistData.nodes.removeElementAt(i);
                stoplistData.removeRow(i);
            }
            this.rebuildNodes();
        } else if ("routePattern.stoplistSort".equals(event.getActionCommand())) {
            StopReference sr;
            int i;
            segmentMetrics = new Vector<SegmentMetric>();
            for (int i2 = 0; i2 < itineraryData.getRowCount(); ++i2) {
                if (RoutePatternAction.itineraryData.ways.elementAt(i2) != null) {
                    way = RoutePatternAction.itineraryData.ways.elementAt(i2);
                    if (way.isIncomplete()) continue;
                    if ("backward".equals((String)itineraryData.getValueAt(i2, 1))) {
                        for (int j = way.getNodesCount() - 2; j >= 0; --j) {
                            sm = new SegmentMetric(way.getNode(j + 1).getCoor().lat(), way.getNode(j + 1).getCoor().lon(), way.getNode(j).getCoor().lat(), way.getNode(j).getCoor().lon());
                            segmentMetrics.add(sm);
                        }
                        continue;
                    }
                    for (int j = 0; j < way.getNodesCount() - 1; ++j) {
                        sm = new SegmentMetric(way.getNode(j).getCoor().lat(), way.getNode(j).getCoor().lon(), way.getNode(j + 1).getCoor().lat(), way.getNode(j + 1).getCoor().lon());
                        segmentMetrics.add(sm);
                    }
                    continue;
                }
                segmentMetrics.add(null);
            }
            Vector<StopReference> srm = new Vector<StopReference>();
            int insPos = stoplistTable.getSelectedRow();
            if (stoplistTable.getSelectedRowCount() > 0) {
                for (i = stoplistData.getRowCount() - 1; i >= 0; --i) {
                    if (!stoplistTable.isRowSelected(i) || (sr = this.detectMinDistance(RoutePatternAction.stoplistData.nodes.elementAt(i), segmentMetrics, cbRight.isSelected(), cbLeft.isSelected())) == null) continue;
                    if (sr.distance < Double.parseDouble(tfSuggestStopsLimit.getText()) * 9.0 / 1000000.0) {
                        sr.role = (String)stoplistData.getValueAt(i, 1);
                        srm.addElement(sr);
                    } else {
                        sr.role = (String)stoplistData.getValueAt(i, 1);
                        sr.index = segmentMetrics.size() * 2;
                        sr.pos = 0.0;
                        srm.addElement(sr);
                    }
                    RoutePatternAction.stoplistData.nodes.removeElementAt(i);
                    stoplistData.removeRow(i);
                }
            } else {
                for (i = stoplistData.getRowCount() - 1; i >= 0; --i) {
                    sr = this.detectMinDistance(RoutePatternAction.stoplistData.nodes.elementAt(i), segmentMetrics, cbRight.isSelected(), cbLeft.isSelected());
                    if (sr == null) continue;
                    if (sr.distance < Double.parseDouble(tfSuggestStopsLimit.getText()) * 9.0 / 1000000.0) {
                        sr.role = (String)stoplistData.getValueAt(i, 1);
                        srm.addElement(sr);
                        continue;
                    }
                    sr.role = (String)stoplistData.getValueAt(i, 1);
                    sr.index = segmentMetrics.size() * 2;
                    sr.pos = 0.0;
                    srm.addElement(sr);
                }
                stoplistData.clear();
            }
            Collections.sort(srm);
            for (i = 0; i < srm.size(); ++i) {
                stoplistData.insertRow(insPos, ((StopReference)srm.elementAt((int)i)).node, ((StopReference)srm.elementAt((int)i)).role);
                if (insPos < 0) continue;
                ++insPos;
            }
            this.rebuildNodes();
        } else if ("routePattern.stoplistReflect".equals(event.getActionCommand())) {
            RelationMember markedNode;
            int i;
            itemsToReflect = new Vector();
            int insPos = stoplistTable.getSelectedRow();
            if (stoplistTable.getSelectedRowCount() > 0) {
                for (i = stoplistData.getRowCount() - 1; i >= 0; --i) {
                    if (!stoplistTable.isRowSelected(i)) continue;
                    role = (String)stoplistData.getValueAt(i, 1);
                    markedNode = new RelationMember(role, (OsmPrimitive)RoutePatternAction.stoplistData.nodes.elementAt(i));
                    itemsToReflect.addElement(markedNode);
                    RoutePatternAction.stoplistData.nodes.removeElementAt(i);
                    stoplistData.removeRow(i);
                }
            } else {
                for (i = stoplistData.getRowCount() - 1; i >= 0; --i) {
                    role = (String)stoplistData.getValueAt(i, 1);
                    markedNode = new RelationMember(role, (OsmPrimitive)RoutePatternAction.stoplistData.nodes.elementAt(i));
                    itemsToReflect.addElement(markedNode);
                }
                stoplistData.clear();
            }
            int startPos = insPos;
            for (RelationMember curMember5 : itemsToReflect) {
                if (!curMember5.isNode()) continue;
                stoplistData.insertRow(insPos, curMember5.getNode(), curMember5.getRole());
                if (insPos < 0) continue;
                ++insPos;
            }
            if (insPos >= 0) {
                stoplistTable.addRowSelectionInterval(startPos, insPos - 1);
            }
            this.rebuildNodes();
        } else if ("routePattern.metaSuggestStops".equals(event.getActionCommand())) {
            int i;
            segmentMetrics = new Vector();
            for (int i3 = 0; i3 < itineraryData.getRowCount(); ++i3) {
                if (RoutePatternAction.itineraryData.ways.elementAt(i3) != null) {
                    way = RoutePatternAction.itineraryData.ways.elementAt(i3);
                    if (way.isIncomplete()) continue;
                    if ("backward".equals((String)itineraryData.getValueAt(i3, 1))) {
                        for (int j = way.getNodesCount() - 2; j >= 0; --j) {
                            sm = new SegmentMetric(way.getNode(j + 1).getCoor().lat(), way.getNode(j + 1).getCoor().lon(), way.getNode(j).getCoor().lat(), way.getNode(j).getCoor().lon());
                            segmentMetrics.add(sm);
                        }
                        continue;
                    }
                    for (int j = 0; j < way.getNodesCount() - 1; ++j) {
                        sm = new SegmentMetric(way.getNode(j).getCoor().lat(), way.getNode(j).getCoor().lon(), way.getNode(j + 1).getCoor().lat(), way.getNode(j + 1).getCoor().lon());
                        segmentMetrics.add(sm);
                    }
                    continue;
                }
                segmentMetrics.add(null);
            }
            Vector<StopReference> srm = new Vector<StopReference>();
            mainDataSet = Main.main.getCurrentDataSet();
            if (mainDataSet != null) {
                Collection nodeCollection = mainDataSet.getNodes();
                for (Node currentNode : nodeCollection) {
                    StopReference sr;
                    if (!"bus_stop".equals(currentNode.get("highway")) || (sr = this.detectMinDistance(currentNode, segmentMetrics, cbRight.isSelected(), cbLeft.isSelected())) == null || !(sr.distance < Double.parseDouble(tfSuggestStopsLimit.getText()) * 9.0 / 1000000.0)) continue;
                    srm.addElement(sr);
                }
            } else {
                JOptionPane.showMessageDialog(null, "There exists no dataset. Try to download data from the server or open an OSM file.", "No data found", 0);
                System.out.println("Public Transport: No data found");
            }
            for (i = 0; i < stoplistData.getRowCount(); ++i) {
            }
            Collections.sort(srm);
            stoplistData.clear();
            for (i = 0; i < srm.size(); ++i) {
                stoplistData.addRow(((StopReference)srm.elementAt((int)i)).node, ((StopReference)srm.elementAt((int)i)).role);
            }
            this.rebuildNodes();
        } else {
            this.refreshData();
            jDialog.setLocationRelativeTo(frame);
            jDialog.setVisible(true);
        }
    }

    private void refreshData() {
        dlm.clear();
        DataSet mainDataSet = Main.main.getCurrentDataSet();
        if (mainDataSet != null) {
            routes.clear();
            Vector<String> rpLines = new Vector<String>();
            Collection relCollection = mainDataSet.getRelations();
            for (Relation currentRel : relCollection) {
                String routeVal = currentRel.get("route");
                if (!"bus".equals(routeVal)) continue;
                routes.addElement(currentRel);
                String relDesc = currentRel.get("ref");
                if (relDesc == null) {
                    relDesc = "";
                }
                relDesc = "bus: " + relDesc + " [" + currentRel.getId() + "]";
                rpLines.addElement(relDesc);
            }
            Iterator rplIter = rpLines.iterator();
            while (rplIter.hasNext()) {
                dlm.addElement(rplIter.next());
            }
        } else {
            JOptionPane.showMessageDialog(null, "There exists no dataset. Try to download data from the server or open an OSM file.", "No data found", 0);
            System.out.println("Public Transport: No data found");
        }
    }

    private void rebuildWays() {
        int i;
        currentRoute.setModified(true);
        for (i = currentRoute.getMembersCount() - 1; i >= 0; --i) {
            if (!currentRoute.getMember(i).isWay()) continue;
            currentRoute.removeMember(i);
        }
        for (i = 0; i < itineraryData.getRowCount(); ++i) {
            if (RoutePatternAction.itineraryData.ways.elementAt(i) == null) continue;
            RelationMember member = new RelationMember((String)itineraryData.getValueAt(i, 1), (OsmPrimitive)RoutePatternAction.itineraryData.ways.elementAt(i));
            currentRoute.addMember(member);
        }
    }

    private void rebuildNodes() {
        int i;
        currentRoute.setModified(true);
        for (i = currentRoute.getMembersCount() - 1; i >= 0; --i) {
            if (!currentRoute.getMember(i).isNode()) continue;
            currentRoute.removeMember(i);
        }
        for (i = 0; i < stoplistData.getRowCount(); ++i) {
            RelationMember member = new RelationMember((String)stoplistData.getValueAt(i, 1), (OsmPrimitive)RoutePatternAction.stoplistData.nodes.elementAt(i));
            currentRoute.addMember(member);
        }
    }

    private void addWayToSortingData(Way way, TreeMap<Node, LinkedList<RelationMember>> frontNodes, TreeMap<Node, LinkedList<RelationMember>> backNodes, Vector<LinkedList<RelationMember>> loops) {
        if (way.getNodesCount() < 1) {
            return;
        }
        Node firstNode = way.getNode(0);
        Node lastNode = way.getNode(way.getNodesCount() - 1);
        if (frontNodes.get(firstNode) != null) {
            LinkedList<RelationMember> list = frontNodes.get(firstNode);
            list.addFirst(new RelationMember("backward", (OsmPrimitive)way));
            frontNodes.remove(firstNode);
            Node lastListNode = null;
            lastListNode = "backward".equals(list.getLast().getRole()) ? list.getLast().getWay().getNode(0) : list.getLast().getWay().getNode(list.getLast().getWay().getNodesCount() - 1);
            if (lastNode.equals((Object)lastListNode)) {
                backNodes.remove(lastListNode);
                loops.add(list);
            } else if (frontNodes.get(lastNode) != null) {
                backNodes.remove(lastListNode);
                LinkedList<RelationMember> listToAppend = frontNodes.get(lastNode);
                for (RelationMember member : list) {
                    if ("backward".equals(member.getRole())) {
                        listToAppend.addFirst(new RelationMember("forward", (OsmPrimitive)member.getWay()));
                        continue;
                    }
                    listToAppend.addFirst(new RelationMember("backward", (OsmPrimitive)member.getWay()));
                }
                frontNodes.remove(lastNode);
                frontNodes.put(lastListNode, listToAppend);
            } else if (backNodes.get(lastNode) != null) {
                backNodes.remove(lastListNode);
                LinkedList<RelationMember> listToAppend = backNodes.get(lastNode);
                for (RelationMember member : list) {
                    listToAppend.addLast(member);
                }
                backNodes.remove(lastNode);
                backNodes.put(lastListNode, listToAppend);
            } else {
                frontNodes.put(lastNode, list);
            }
        } else if (backNodes.get(firstNode) != null) {
            LinkedList<RelationMember> list = backNodes.get(firstNode);
            list.addLast(new RelationMember("forward", (OsmPrimitive)way));
            backNodes.remove(firstNode);
            Node firstListNode = null;
            firstListNode = "backward".equals(list.getFirst().getRole()) ? list.getFirst().getWay().getNode(list.getFirst().getWay().getNodesCount() - 1) : list.getFirst().getWay().getNode(0);
            if (lastNode.equals((Object)firstListNode)) {
                frontNodes.remove(firstListNode);
                loops.add(list);
            } else if (frontNodes.get(lastNode) != null) {
                frontNodes.remove(firstListNode);
                LinkedList<RelationMember> listToAppend = frontNodes.get(lastNode);
                Iterator<RelationMember> memberIter = list.descendingIterator();
                while (memberIter.hasNext()) {
                    RelationMember member = memberIter.next();
                    listToAppend.addFirst(member);
                }
                frontNodes.remove(lastNode);
                frontNodes.put(firstListNode, listToAppend);
            } else if (backNodes.get(lastNode) != null) {
                frontNodes.remove(firstListNode);
                LinkedList<RelationMember> listToAppend = backNodes.get(lastNode);
                Iterator<RelationMember> memberIter = list.descendingIterator();
                while (memberIter.hasNext()) {
                    RelationMember member = memberIter.next();
                    if ("backward".equals(member.getRole())) {
                        listToAppend.addLast(new RelationMember("forward", (OsmPrimitive)member.getWay()));
                        continue;
                    }
                    listToAppend.addLast(new RelationMember("backward", (OsmPrimitive)member.getWay()));
                }
                backNodes.remove(lastNode);
                backNodes.put(firstListNode, listToAppend);
            } else {
                backNodes.put(lastNode, list);
            }
        } else if (frontNodes.get(lastNode) != null) {
            LinkedList<RelationMember> list = frontNodes.get(lastNode);
            list.addFirst(new RelationMember("forward", (OsmPrimitive)way));
            frontNodes.remove(lastNode);
            frontNodes.put(firstNode, list);
        } else if (backNodes.get(lastNode) != null) {
            LinkedList<RelationMember> list = backNodes.get(lastNode);
            list.addLast(new RelationMember("backward", (OsmPrimitive)way));
            backNodes.remove(lastNode);
            backNodes.put(firstNode, list);
        } else {
            LinkedList<RelationMember> newList = new LinkedList<RelationMember>();
            newList.add(new RelationMember("forward", (OsmPrimitive)way));
            frontNodes.put(firstNode, newList);
            backNodes.put(lastNode, newList);
        }
    }

    private void routesSelectionChanged() {
        int selectedPos = rpJList.getAnchorSelectionIndex();
        if (rpJList.isSelectedIndex(selectedPos)) {
            currentRoute = routes.elementAt(selectedPos);
            tabbedPane.setEnabledAt(1, true);
            tabbedPane.setEnabledAt(2, true);
            tabbedPane.setEnabledAt(3, true);
            tabbedPane.setEnabledAt(4, true);
            itineraryData.clear();
            List relMembers = currentRoute.getMembers();
            Iterator<Object> relIter = relMembers.iterator();
            this.fillItineraryTable(relIter, 0L, -1);
            stoplistData.clear();
            relMembers = currentRoute.getMembers();
            relIter = relMembers.iterator();
            this.fillStoplistTable(relIter, -1);
        } else {
            currentRoute = null;
            tabbedPane.setEnabledAt(1, false);
            tabbedPane.setEnabledAt(2, false);
            tabbedPane.setEnabledAt(3, false);
            tabbedPane.setEnabledAt(4, false);
        }
    }

    private void fillItineraryTable(Iterator<RelationMember> relIter, long lastNodeId, int insPos) {
        while (relIter.hasNext()) {
            RelationMember curMember = relIter.next();
            if (!curMember.isWay()) continue;
            insPos = this.insertGapIfNecessary(curMember.getWay(), curMember.getRole(), lastNodeId, insPos);
            itineraryData.insertRow(insPos, curMember.getWay(), curMember.getRole());
            if (insPos >= 0) {
                ++insPos;
            }
            lastNodeId = this.getLastNodeId(curMember.getWay(), curMember.getRole());
        }
    }

    private void fillStoplistTable(Iterator<RelationMember> relIter, int insPos) {
        while (relIter.hasNext()) {
            RelationMember curMember = relIter.next();
            if (!curMember.isNode()) continue;
            stoplistData.insertRow(insPos, curMember.getNode(), curMember.getRole());
            if (insPos < 0) continue;
            ++insPos;
        }
    }

    private void cleanupGaps() {
        long lastNodeId = 0L;
        for (int i = 0; i < itineraryData.getRowCount() && (RoutePatternAction.itineraryData.ways.elementAt(i) != null || ++i < itineraryData.getRowCount()); ++i) {
            while (RoutePatternAction.itineraryData.ways.elementAt(i) == null && (i == 0 || RoutePatternAction.itineraryData.ways.elementAt(i - 1) == null)) {
                RoutePatternAction.itineraryData.ways.removeElementAt(i);
                itineraryData.removeRow(i);
                if (i < itineraryData.getRowCount()) continue;
            }
            if (i >= itineraryData.getRowCount()) break;
            boolean gapRequired = this.gapNecessary(RoutePatternAction.itineraryData.ways.elementAt(i), (String)itineraryData.getValueAt(i, 1), lastNodeId);
            if (i > 0 && !gapRequired && RoutePatternAction.itineraryData.ways.elementAt(i - 1) == null) {
                RoutePatternAction.itineraryData.ways.removeElementAt(i - 1);
                itineraryData.removeRow(i - 1);
                --i;
            } else if (i > 0 && gapRequired && RoutePatternAction.itineraryData.ways.elementAt(i - 1) != null) {
                Object[] buf = new String[]{"", ""};
                buf[0] = "[gap]";
                itineraryData.insertRow(i, buf);
                ++i;
            }
            lastNodeId = this.getLastNodeId(RoutePatternAction.itineraryData.ways.elementAt(i), (String)itineraryData.getValueAt(i, 1));
        }
        while (RoutePatternAction.itineraryData.ways.elementAt(itineraryData.getRowCount() - 1) == null) {
            RoutePatternAction.itineraryData.ways.removeElementAt(itineraryData.getRowCount() - 1);
            itineraryData.removeRow(itineraryData.getRowCount() - 1);
        }
    }

    private int insertGapIfNecessary(Way way, String role, long lastNodeId, int insPos) {
        Object[] buf = new String[]{"", ""};
        if (this.gapNecessary(way, role, lastNodeId)) {
            buf[0] = "[gap]";
            itineraryData.insertRow(insPos, buf);
            if (insPos >= 0) {
                ++insPos;
            }
        }
        return insPos;
    }

    private boolean gapNecessary(Way way, String role, long lastNodeId) {
        if (way != null && !way.isIncomplete() && way.getNodesCount() >= 1) {
            if ("backward".equals(role)) {
                long firstNodeId = way.getNode(way.getNodesCount() - 1).getId();
                if (lastNodeId != 0L && lastNodeId != firstNodeId) {
                    return true;
                }
            } else {
                long firstNodeId = way.getNode(0).getId();
                if (lastNodeId != 0L && lastNodeId != firstNodeId) {
                    return true;
                }
            }
        }
        return false;
    }

    private long getLastNodeId(Way way, String role) {
        if (way == null || way.isIncomplete() || way.getNodesCount() < 1) {
            return 0L;
        }
        if ("backward".equals(role)) {
            return way.getNode(0).getId();
        }
        return way.getNode(way.getNodesCount() - 1).getId();
    }

    private StopReference detectMinDistance(Node node, Vector<SegmentMetric> segmentMetrics, boolean rhsPossible, boolean lhsPossible) {
        int minIndex = -1;
        double position = -1.0;
        double distance = 180.0;
        double lat = node.getCoor().lat();
        double lon = node.getCoor().lon();
        int curIndex = -2;
        double angleLat = 100.0;
        double angleLon = 200.0;
        Iterator<SegmentMetric> iter = segmentMetrics.iterator();
        while (iter.hasNext()) {
            curIndex += 2;
            SegmentMetric sm = iter.next();
            if (sm == null) {
                angleLat = 100.0;
                angleLon = 200.0;
                continue;
            }
            double curPosition = (lat - sm.aLat) * sm.d1 + (lon - sm.aLon) * sm.d2;
            if (curPosition < 0.0) {
                if (angleLat <= 90.0) {
                    double lastSegAngle = Math.atan2(angleLat - sm.aLat, angleLon - sm.aLon);
                    double segAngle = Math.atan2(sm.d1, -sm.o1);
                    double vertexAngle = Math.atan2(lat - sm.aLat, lon - sm.aLon);
                    boolean vertexOnSeg = vertexAngle == segAngle || vertexAngle == lastSegAngle;
                    boolean vertexOnTheLeft = !vertexOnSeg && (lastSegAngle > vertexAngle && vertexAngle > segAngle || vertexAngle > segAngle && segAngle > lastSegAngle || segAngle > lastSegAngle && lastSegAngle > vertexAngle);
                    double currentDistance = Math.sqrt((lat - sm.aLat) * (lat - sm.aLat) + (lon - sm.aLon) * (lon - sm.aLon) * Math.cos(sm.aLat * Math.PI / 180.0) * Math.cos(sm.aLat * Math.PI / 180.0));
                    curPosition = vertexAngle - segAngle;
                    if (vertexOnTheLeft) {
                        curPosition = -curPosition;
                    }
                    if (curPosition < 0.0) {
                        curPosition += Math.PI * 2;
                    }
                    if (Math.abs(currentDistance) < distance && (!vertexOnTheLeft && rhsPossible || vertexOnTheLeft && lhsPossible || vertexOnSeg)) {
                        distance = Math.abs(currentDistance);
                        minIndex = curIndex - 1;
                        position = curPosition;
                    }
                }
                angleLat = 100.0;
                angleLon = 200.0;
                continue;
            }
            if (curPosition > sm.length) {
                angleLat = sm.aLat;
                angleLon = sm.aLon;
                continue;
            }
            double currentDistance = (lat - sm.aLat) * sm.o1 + (lon - sm.aLon) * sm.o2;
            if (Math.abs(currentDistance) < distance && (currentDistance >= 0.0 && rhsPossible || currentDistance <= 0.0 && lhsPossible)) {
                distance = Math.abs(currentDistance);
                minIndex = curIndex;
                position = curPosition;
            }
            angleLat = 100.0;
            angleLon = 200.0;
        }
        if (minIndex == -1) {
            return new StopReference(segmentMetrics.size() * 2, 0.0, 180.0, node.get("name"), "", node);
        }
        return new StopReference(minIndex, position, distance, node.get("name"), "", node);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StopReference
    implements Comparable<StopReference> {
        public int index = 0;
        public double pos = 0.0;
        public double distance = 0.0;
        public String name = "";
        public String role = "";
        public Node node;

        public StopReference(int inIndex, double inPos, double inDistance, String inName, String inRole, Node inNode) {
            this.index = inIndex;
            this.pos = inPos;
            this.distance = inDistance;
            this.name = inName;
            this.role = inRole;
            this.node = inNode;
        }

        @Override
        public int compareTo(StopReference sr) {
            if (this.index < sr.index) {
                return -1;
            }
            if (this.index > sr.index) {
                return 1;
            }
            if (this.pos < sr.pos) {
                return -1;
            }
            if (this.pos > sr.pos) {
                return 1;
            }
            return 0;
        }
    }

    private class SegmentMetric {
        public double aLat;
        public double aLon;
        public double length;
        public double d1;
        public double d2;
        public double o1;
        public double o2;

        public SegmentMetric(double fromLat, double fromLon, double toLat, double toLon) {
            this.aLat = fromLat;
            this.aLon = fromLon;
            this.d1 = toLat - fromLat;
            this.d2 = (toLon - fromLon) * Math.cos(fromLat * Math.PI / 180.0);
            this.length = Math.sqrt(this.d1 * this.d1 + this.d2 * this.d2);
            this.d1 /= this.length;
            this.d2 /= this.length;
            this.o1 = -this.d2;
            this.o2 = this.d1;
            this.d2 *= Math.cos(fromLat * Math.PI / 180.0);
            this.o2 *= Math.cos(fromLat * Math.PI / 180.0);
        }
    }

    private class StoplistTableModelListener
    implements TableModelListener {
        private StoplistTableModelListener() {
        }

        public void tableChanged(TableModelEvent e) {
            if (e.getType() == 0) {
                RoutePatternAction.this.rebuildNodes();
            }
        }
    }

    private class StoplistTableModel
    extends DefaultTableModel {
        public Vector<Node> nodes = new Vector();

        private StoplistTableModel() {
        }

        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }

        public void addRow(Object[] obj) {
            throw new UnsupportedOperationException();
        }

        public void insertRow(int insPos, Object[] obj) {
            throw new UnsupportedOperationException();
        }

        public void addRow(Node node, String role) {
            this.insertRow(-1, node, role);
        }

        public void insertRow(int insPos, Node node, String role) {
            Object[] buf = new String[]{"", ""};
            String curName = node.get("name");
            buf[0] = curName != null ? curName : "[ID] " + new Long(node.getId()).toString();
            buf[1] = role;
            if (insPos == -1) {
                this.nodes.addElement(node);
                super.addRow(buf);
            } else {
                this.nodes.insertElementAt(node, insPos);
                super.insertRow(insPos, buf);
            }
        }

        public void clear() {
            this.nodes.clear();
            super.setRowCount(0);
        }
    }

    private class ItineraryTableModelListener
    implements TableModelListener {
        private ItineraryTableModelListener() {
        }

        public void tableChanged(TableModelEvent e) {
            if (e.getType() == 0) {
                RoutePatternAction.this.cleanupGaps();
                RoutePatternAction.this.rebuildWays();
            }
        }
    }

    private class ItineraryTableModel
    extends DefaultTableModel {
        public Vector<Way> ways = new Vector();

        private ItineraryTableModel() {
        }

        public boolean isCellEditable(int row, int column) {
            if (column != 1) {
                return false;
            }
            return this.ways.elementAt(row) != null;
        }

        public void addRow(Object[] obj) {
            this.ways.addElement(null);
            super.addRow(obj);
        }

        public void insertRow(int insPos, Object[] obj) {
            if (insPos == -1) {
                this.ways.addElement(null);
                super.addRow(obj);
            } else {
                this.ways.insertElementAt(null, insPos);
                super.insertRow(insPos, obj);
            }
        }

        public void addRow(Way way, String role) {
            this.insertRow(-1, way, role);
        }

        public void insertRow(int insPos, Way way, String role) {
            Object[] buf = new String[]{"", ""};
            String curName = way.get("name");
            buf[0] = way.isIncomplete() ? "[incomplete]" : (way.getNodesCount() < 1 ? "[empty way]" : (curName != null ? curName : "[ID] " + new Long(way.getId()).toString()));
            buf[1] = role;
            if (insPos == -1) {
                this.ways.addElement(way);
                super.addRow(buf);
            } else {
                this.ways.insertElementAt(way, insPos);
                super.insertRow(insPos, buf);
            }
        }

        public void clear() {
            this.ways.clear();
            super.setRowCount(0);
        }
    }

    private class RoutesLSL
    implements ListSelectionListener {
        RoutePatternAction root = null;

        public RoutesLSL(RoutePatternAction rpa) {
            this.root = rpa;
        }

        public void valueChanged(ListSelectionEvent e) {
            this.root.routesSelectionChanged();
        }
    }
}

