/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.gui;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.AddressElement;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Database;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.ElementWithStreets;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Region;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Suburb;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.ViToCi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationSelector
extends ExtendedDialog {
    protected ElementWithStreets selectedElement;
    protected ArrayList<ItemListener> listeners = new ArrayList();
    private JLabel castObceLabel;
    private JPanel mainPanel;
    private JLabel obecLabel;
    private JComboBox oblastComboBox;
    private JLabel oblastLabel;
    private JComboBox suburbComboBox;
    private JComboBox vitociComboBox;

    public static ElementWithStreets selectLocation() {
        LocationSelector ls = new LocationSelector();
        ls.setVisible(true);
        if (ls.getValue() == 1) {
            return ls.selectedElement;
        }
        return null;
    }

    private LocationSelector() {
        super(Main.parent, "V\u00fdb\u011br um\u00edst\u011bn\u00ed", new String[]{"OK", "Zru\u0161it"}, true);
        this.initComponents();
        this.setContent(this.mainPanel);
        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        this.setupDialog();
        this.oblastComboBox.setRenderer(new AddressElementRenderer());
        this.vitociComboBox.setRenderer(new AddressElementRenderer());
        this.suburbComboBox.setRenderer(new SuburbRenderer());
        this.oblastComboBox.setModel(new DefaultComboBoxModel<Object>(Database.getInstance().regions.toArray()));
    }

    @Deprecated
    private void autodetectLocation() {
        LatLon center;
        boolean assertions = false;
        if (!$assertionsDisabled) {
            assertions = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        BoundingXYVisitor visitor = new BoundingXYVisitor();
        for (OsmPrimitive op : Main.main.getCurrentDataSet().allPrimitives()) {
            if (op instanceof Node) {
                ((Node)op).visit((Visitor)visitor);
                continue;
            }
            if (!(op instanceof Way)) continue;
            ((Way)op).visit((Visitor)visitor);
        }
        try {
            center = Main.proj.eastNorth2latlon(visitor.getBounds().getCenter());
        }
        catch (Exception e) {
            System.err.println("AUTO: No bounds to determine autolocation.");
            return;
        }
        OsmPrimitive bestFit = this.findNearest(center).get("XXX-best");
        if (bestFit == null) {
            return;
        }
        String bestName = bestFit.get("name").toUpperCase();
        String bestPlace = bestFit.get("place");
        boolean isSuburb = bestPlace.equals("suburb");
        block3: for (Region oblast : Database.getInstance().regions) {
            block4: for (ViToCi obec : oblast.getViToCis()) {
                if (isSuburb) {
                    for (Suburb castObce : obec.getSuburbs()) {
                        if (!castObce.getName().toUpperCase().equals(bestName)) continue;
                        this.oblastComboBox.setSelectedItem(oblast);
                        this.vitociComboBox.setSelectedItem(obec);
                        this.suburbComboBox.setSelectedItem(castObce);
                        continue block4;
                    }
                    continue;
                }
                if (!obec.getName().toUpperCase().equals(bestName)) continue;
                this.oblastComboBox.setSelectedItem(oblast);
                this.vitociComboBox.setSelectedItem(obec);
                continue block3;
            }
        }
    }

    private Map<String, OsmPrimitive> findNearest(LatLon center) {
        HashMap<String, OsmPrimitive> retval = new HashMap<String, OsmPrimitive>();
        HashMap<String, Double> length = new HashMap<String, Double>();
        for (OsmPrimitive op : Main.main.getCurrentDataSet().allPrimitives()) {
            String place;
            if (!(op instanceof Node) || op.get("name") == null || (place = op.get("place")) == null) continue;
            double currLen = ((Node)op).getCoor().distance((Point2D)center);
            if (retval.get(place) != null && !(currLen < (Double)length.get(place))) continue;
            retval.put(place, op);
            length.put(place, currLen);
        }
        OsmPrimitive bestVal = null;
        double bestLen = 0.0;
        for (String place : retval.keySet()) {
            double currLen;
            double multiplicator;
            if (place.equals("city")) {
                multiplicator = 2.8;
            } else if (place.equals("town")) {
                multiplicator = 2.3;
            } else if (place.equals("village")) {
                multiplicator = 2.0;
            } else {
                if (!place.equals("suburb")) continue;
                multiplicator = 1.0;
            }
            if (!(bestVal == null & (currLen = multiplicator * (Double)length.get(place)) < bestLen)) continue;
            bestVal = (OsmPrimitive)retval.get(place);
            bestLen = currLen;
        }
        if (bestVal != null) {
            retval.put("XXX-best", bestVal);
        }
        return retval;
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.oblastComboBox = new JComboBox();
        this.suburbComboBox = new JComboBox();
        this.vitociComboBox = new JComboBox();
        this.obecLabel = new JLabel();
        this.castObceLabel = new JLabel();
        this.oblastLabel = new JLabel();
        this.setTitle("V\u00fdb\u011br um\u00edst\u011bn\u00ed");
        this.setModal(true);
        this.setName("locationSelector");
        this.getContentPane().setLayout(new GridLayout(1, 0));
        this.oblastComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                LocationSelector.this.oblastComboBoxItemStateChanged(evt);
            }
        });
        this.suburbComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                LocationSelector.this.suburbComboBoxItemStateChanged(evt);
            }
        });
        this.vitociComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                LocationSelector.this.vitociComboBoxItemStateChanged(evt);
            }
        });
        this.obecLabel.setText("Obec:");
        this.castObceLabel.setText("\u010c\u00e1st obce:");
        this.oblastLabel.setText("ORP:");
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.oblastLabel).addComponent(this.obecLabel).addComponent(this.castObceLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.suburbComboBox, 0, 341, Short.MAX_VALUE).addComponent(this.vitociComboBox, 0, 341, Short.MAX_VALUE).addComponent(this.oblastComboBox, 0, 341, Short.MAX_VALUE))));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.oblastLabel).addComponent(this.oblastComboBox, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.obecLabel).addComponent(this.vitociComboBox, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.castObceLabel).addComponent(this.suburbComboBox, -2, 25, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.getContentPane().add(this.mainPanel);
    }

    private void oblastComboBoxItemStateChanged(ItemEvent evt) {
        Region oblast = (Region)this.oblastComboBox.getSelectedItem();
        if (oblast == null) {
            return;
        }
        this.vitociComboBox.setModel(new DefaultComboBoxModel<Object>(oblast.getViToCis().toArray()));
        this.vitociComboBox.setEnabled(this.vitociComboBox.getModel().getSize() > 1);
        this.vitociComboBoxItemStateChanged(null);
    }

    private void vitociComboBoxItemStateChanged(ItemEvent evt) {
        ViToCi obec = (ViToCi)this.vitociComboBox.getSelectedItem();
        if (obec == null) {
            return;
        }
        if (obec.getSuburbs().size() > 0) {
            Object[] suburbs = new Object[obec.getSuburbs().size() + 1];
            for (int i = 0; i < obec.getSuburbs().size(); ++i) {
                suburbs[i] = obec.getSuburbs().get(i);
            }
            suburbs[obec.getSuburbs().size()] = obec;
            this.suburbComboBox.setModel(new DefaultComboBoxModel<Object>(suburbs));
        } else {
            this.suburbComboBox.setModel(new DefaultComboBoxModel());
        }
        this.suburbComboBox.setEnabled(this.suburbComboBox.getModel().getSize() > 1);
        this.suburbComboBoxItemStateChanged(null);
    }

    private void suburbComboBoxItemStateChanged(ItemEvent evt) {
        if (this.suburbComboBox.getSelectedItem() != null) {
            this.selectedElement = (ElementWithStreets)this.suburbComboBox.getSelectedItem();
        } else if (this.vitociComboBox.getSelectedItem() != null) {
            this.selectedElement = (ElementWithStreets)this.vitociComboBox.getSelectedItem();
        } else if (this.oblastComboBox.getSelectedItem() != null) {
            this.selectedElement = (ElementWithStreets)this.oblastComboBox.getSelectedItem();
        }
    }

    private class SuburbRenderer
    extends AddressElementRenderer {
        private SuburbRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof ViToCi) {
                this.setFont(this.getFont().deriveFont(1));
                this.setText("v\u0161echny \u010d\u00e1sti obce [experiment\u00e1ln\u00ed]");
            } else {
                this.setFont(this.getFont().deriveFont(0));
            }
            return c;
        }
    }

    private class AddressElementRenderer
    extends DefaultListCellRenderer {
        private AddressElementRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof AddressElement && !(value instanceof Region)) {
                this.setText(((AddressElement)value).getName());
            }
            return c;
        }
    }
}

