/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameMismatch
extends Test {
    protected static final int NAME_MISSING = 1501;
    protected static final int NAME_TRANSLATION_MISSING = 1502;

    public NameMismatch() {
        super(I18n.tr((String)"Missing name:* translation."), I18n.tr((String)"This test finds multilingual objects whose 'name' attribute is not equal to some 'name:*' attribute and not a composition of 'name:*' attributes, e.g., Italia - Italien - Italy."));
    }

    private void missingTranslation(OsmPrimitive p) {
        this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"A name:* translation is missing."), 1502, p));
    }

    public void check(OsmPrimitive p) {
        HashSet<String> names = new HashSet<String>();
        for (Map.Entry entry : p.getKeys().entrySet()) {
            String name_s;
            if (!((String)entry.getKey()).startsWith("name:") || (name_s = (String)entry.getValue()) == null) continue;
            names.add(name_s);
        }
        if (names.isEmpty()) {
            return;
        }
        String name = p.get("name");
        if (name == null) {
            this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr((String)"A name is missing, even though name:* exists."), 1501, p));
            return;
        }
        if (names.contains(name)) {
            return;
        }
        String[] split_names = name.split(" - ");
        if (split_names.length == 1) {
            this.missingTranslation(p);
            return;
        }
        String[] stringArray = split_names;
        int n = split_names.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            if (!names.contains(n3)) {
                this.missingTranslation(p);
                return;
            }
            ++n2;
        }
    }

    @Override
    public void visit(Collection<OsmPrimitive> selection) {
        for (OsmPrimitive p : selection) {
            if (p.isDeleted() || p.isIncomplete()) continue;
            this.check(p);
        }
    }
}

