/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.validator.OSMValidatorPlugin;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.AgregatePrimitivesVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

public class ValidateAction
extends JosmAction {
    private OSMValidatorPlugin plugin;
    private static final long serialVersionUID = -2304521273582574603L;
    private Collection<OsmPrimitive> lastSelection;

    public ValidateAction(OSMValidatorPlugin plugin) {
        super(I18n.tr((String)"Validation"), "validator", I18n.tr((String)"Performs the data validation"), Shortcut.registerShortcut((String)"tools:validate", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Validation")}), (int)86, (int)3, (int)1), true);
        this.plugin = plugin;
    }

    public void actionPerformed(ActionEvent ev) {
        this.doValidate(ev, true);
    }

    public void doValidate(ActionEvent ev, boolean getSelectedItems) {
        Collection<OsmPrimitive> selection;
        if (this.plugin.validateAction == null || Main.map == null || !Main.map.isVisible()) {
            return;
        }
        this.plugin.initializeErrorLayer();
        Collection<Test> tests = OSMValidatorPlugin.getEnabledTests(false);
        if (tests.isEmpty()) {
            return;
        }
        if (getSelectedItems) {
            selection = Main.main.getCurrentDataSet().getSelected();
            if (selection.isEmpty()) {
                selection = Main.main.getCurrentDataSet().allNonDeletedPrimitives();
                this.lastSelection = null;
            } else {
                AgregatePrimitivesVisitor v = new AgregatePrimitivesVisitor();
                selection = v.visit(selection);
                this.lastSelection = selection;
            }
        } else {
            selection = this.lastSelection == null ? Main.main.getCurrentDataSet().allNonDeletedPrimitives() : this.lastSelection;
        }
        ValidationTask task = new ValidationTask(tests, selection, this.lastSelection);
        Main.worker.submit((Runnable)((Object)task));
    }

    public void updateEnabledState() {
        this.setEnabled(this.getEditLayer() != null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValidationTask
    extends PleaseWaitRunnable {
        private Collection<Test> tests;
        private Collection<OsmPrimitive> validatedPrimitmives;
        private Collection<OsmPrimitive> formerValidatedPrimitives;
        private boolean canceled;
        private List<TestError> errors;

        public ValidationTask(Collection<Test> tests, Collection<OsmPrimitive> validatedPrimitives, Collection<OsmPrimitive> formerValidatedPrimitives) {
            super(I18n.tr((String)"Validating"), false);
            this.validatedPrimitmives = validatedPrimitives;
            this.formerValidatedPrimitives = formerValidatedPrimitives;
            this.tests = tests;
        }

        protected void cancel() {
            this.canceled = true;
        }

        protected void finish() {
            if (this.canceled) {
                return;
            }
            Runnable r = new Runnable(){

                public void run() {
                    ((ValidateAction)((ValidationTask)ValidationTask.this).ValidateAction.this).plugin.validationDialog.tree.setErrors(ValidationTask.this.errors);
                    ((ValidateAction)((ValidationTask)ValidationTask.this).ValidateAction.this).plugin.validationDialog.setVisible(true);
                    Main.main.getCurrentDataSet().fireSelectionChanged();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }

        protected void realRun() throws SAXException, IOException, OsmTransferException {
            if (this.tests == null || this.tests.isEmpty()) {
                return;
            }
            this.errors = new ArrayList<TestError>(200);
            this.getProgressMonitor().setTicksCount(this.tests.size() * this.validatedPrimitmives.size());
            int testCounter = 0;
            for (Test test : this.tests) {
                if (this.canceled) {
                    return;
                }
                this.getProgressMonitor().setCustomText(I18n.tr((String)"Test {0}/{1}: Starting {2}", (Object[])new Object[]{++testCounter, this.tests.size(), test.name}));
                test.setPartialSelection(this.formerValidatedPrimitives != null);
                test.startTest(this.getProgressMonitor().createSubTaskMonitor(this.validatedPrimitmives.size(), false));
                test.visit(this.validatedPrimitmives);
                test.endTest();
                this.errors.addAll(test.getErrors());
            }
            this.tests = null;
            if (Main.pref.getBoolean("validator.ignore", true)) {
                this.getProgressMonitor().subTask(I18n.tr((String)"Updating ignored errors ..."));
                for (TestError error : this.errors) {
                    if (this.canceled) {
                        return;
                    }
                    ArrayList<String> s = new ArrayList<String>();
                    s.add(error.getIgnoreState());
                    s.add(error.getIgnoreGroup());
                    s.add(error.getIgnoreSubGroup());
                    for (String state : s) {
                        if (state == null || !((ValidateAction)ValidateAction.this).plugin.ignoredErrors.contains(state)) continue;
                        error.setIgnored(true);
                    }
                }
            }
        }
    }
}

