/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.tests;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.validator.Severity;
import org.openstreetmap.josm.plugins.validator.Test;
import org.openstreetmap.josm.plugins.validator.TestError;
import org.openstreetmap.josm.plugins.validator.util.Bag;
import org.openstreetmap.josm.tools.I18n;

public class DuplicateWay
extends Test {
    protected static int DUPLICATE_WAY = 1401;
    Bag<WayPair, OsmPrimitive> ways;

    public DuplicateWay() {
        super(String.valueOf(I18n.tr((String)"Duplicated ways")) + ".", I18n.tr((String)"This test checks that there are no ways with same tags and same node coordinates."));
    }

    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.ways = new Bag(1000);
    }

    public void endTest() {
        super.endTest();
        for (List duplicated : this.ways.values()) {
            if (duplicated.size() <= 1) continue;
            TestError testError = new TestError((Test)this, Severity.ERROR, I18n.tr((String)"Duplicated ways"), DUPLICATE_WAY, duplicated);
            this.errors.add(testError);
        }
        this.ways = null;
    }

    public void visit(Way w) {
        if (!w.isUsable()) {
            return;
        }
        List wNodes = w.getNodes();
        Vector<LatLon> wLat = new Vector<LatLon>(wNodes.size());
        int i = 0;
        while (i < wNodes.size()) {
            wLat.add(((Node)wNodes.get(i)).getCoor());
            ++i;
        }
        Map wkeys = w.getKeys();
        wkeys.remove("created_by");
        WayPair wKey = new WayPair(wLat, wkeys);
        this.ways.add(wKey, (OsmPrimitive)w);
    }

    public Command fixError(TestError testError) {
        List<? extends OsmPrimitive> sel = testError.getPrimitives();
        LinkedList<Way> ways = new LinkedList<Way>();
        for (OsmPrimitive osmPrimitive : sel) {
            if (!(osmPrimitive instanceof Way)) continue;
            ways.add((Way)osmPrimitive);
        }
        if (ways.size() < 2) {
            return null;
        }
        long l = 0L;
        for (Way w : ways) {
            if (w.isNew() || l != 0L && w.getId() >= l) continue;
            l = w.getId();
        }
        if (l > 0L) {
            for (Way w : ways) {
                if (w.getId() != l) continue;
                ways.remove(w);
                break;
            }
        } else {
            ways.remove(0);
        }
        LinkedList<DeleteCommand> commands = new LinkedList<DeleteCommand>();
        commands.add(new DeleteCommand(ways));
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Delete duplicate ways"), commands));
        return null;
    }

    public boolean isFixable(TestError testError) {
        return testError.getTester() instanceof DuplicateWay;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WayPair {
        public List<LatLon> coor;
        public Map<String, String> keys;

        public WayPair(List<LatLon> _coor, Map<String, String> _keys) {
            this.coor = _coor;
            this.keys = _keys;
        }

        public int hashCode() {
            return this.coor.hashCode() + this.keys.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WayPair)) {
                return false;
            }
            WayPair wp = (WayPair)obj;
            return wp.coor.equals(this.coor) && wp.keys.equals(this.keys);
        }
    }
}

