/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import livegps.ILiveGpsSuppressor;
import org.openstreetmap.josm.Main;

public class LiveGpsSuppressor
implements Runnable,
ILiveGpsSuppressor {
    private static final int DEFAULT_SLEEP_TIME = 5;
    private int sleepTime = 5;
    private boolean allowUpdate = false;
    private boolean shutdownFlag = false;

    public void run() {
        this.initSleepTime();
        this.shutdownFlag = false;
        while (!this.shutdownFlag && this.isEnabled()) {
            this.setAllowUpdate(true);
            try {
                Thread.sleep(this.getSleepTime());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void initSleepTime() {
        int sleepSeconds = 0;
        sleepSeconds = Main.pref.getInteger("livegps.refreshinterval", 5);
        Main.pref.putInteger("livegps.refreshinterval", Integer.valueOf(sleepSeconds));
        this.sleepTime = sleepSeconds * 1000;
    }

    private synchronized void setAllowUpdate(boolean allowUpdate) {
        this.allowUpdate = allowUpdate;
    }

    public synchronized boolean isAllowUpdate() {
        if (!this.isEnabled()) {
            return true;
        }
        if (this.allowUpdate) {
            this.allowUpdate = false;
            return true;
        }
        return false;
    }

    private boolean isEnabled() {
        return this.sleepTime > 0;
    }

    public void shutdown() {
        this.shutdownFlag = true;
    }

    private int getSleepTime() {
        return this.sleepTime;
    }
}

