/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.photo_geotagging;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.photo_geotagging.ExifGPSTagger;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class GeotaggingPlugin
extends Plugin {
    static final boolean debug = false;
    static final String KEEP_BACKUP = "plugins.photo_geotagging.keep_backup";

    public GeotaggingPlugin(PluginInformation info) {
        super(info);
        GeoImageLayer.registerMenuAddition((GeoImageLayer.LayerMenuAddition)new GeotaggingMenuAddition());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FileListModel
    extends AbstractListModel {
        private List<String> files;

        public FileListModel() {
            this.files = new ArrayList<String>();
        }

        public FileListModel(List<String> files) {
            this.setFiles(files);
        }

        public void setFiles(List<String> files) {
            this.files = files == null ? new ArrayList<String>() : files;
            this.fireContentsChanged(this, 0, this.getSize());
        }

        @Override
        public Object getElementAt(int index) {
            if (this.files == null) {
                return null;
            }
            return this.files.get(index);
        }

        @Override
        public int getSize() {
            if (this.files == null) {
                return 0;
            }
            return this.files.size();
        }
    }

    static class FileList
    extends JList {
        public FileList() {
            super(new FileListModel());
        }

        public FileListModel getFileListModel() {
            return (FileListModel)this.getModel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GeoTaggingRunnable
    extends PleaseWaitRunnable {
        private boolean cancelled;
        private final boolean keep_backup;
        final List<ImageEntry> images;
        private Boolean override_backup;
        private File fileFrom;
        private File fileTo;
        private File fileDelete;

        public GeoTaggingRunnable(List<ImageEntry> images, boolean keep_backup) {
            super(I18n.tr((String)"Photo Geotagging Plugin"));
            this.cancelled = false;
            this.override_backup = null;
            this.images = images;
            this.keep_backup = keep_backup;
        }

        protected void realRun() {
            this.progressMonitor.subTask(I18n.tr((String)"Writing position information to image files..."));
            this.progressMonitor.setTicksCount(this.images.size());
            for (int i = 0; i < this.images.size(); ++i) {
                if (this.cancelled) {
                    return;
                }
                ImageEntry e = this.images.get(i);
                this.fileFrom = null;
                this.fileTo = null;
                this.fileDelete = null;
                try {
                    this.chooseFiles(e.getFile());
                    if (this.cancelled) {
                        return;
                    }
                    ExifGPSTagger.setExifGPSTag(this.fileFrom, this.fileTo, e.getPos().lat(), e.getPos().lon());
                    this.cleanupFiles();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error: ") + ioe.getMessage(), I18n.tr((String)"Error"), 0);
                    return;
                }
                this.progressMonitor.worked(1);
            }
        }

        private void chooseFiles(File file) throws IOException {
            if (!this.keep_backup) {
                this.chooseFilesNoBackup(file);
                return;
            }
            File fileBackup = new File(file.getParentFile(), file.getName() + "_");
            if (fileBackup.exists()) {
                this.confirm_override();
                if (this.cancelled) {
                    return;
                }
                if (this.override_backup.booleanValue()) {
                    if (!fileBackup.delete()) {
                        throw new IOException(I18n.tr((String)"File could not be deleted!"));
                    }
                } else {
                    this.chooseFilesNoBackup(file);
                    return;
                }
            }
            if (!file.renameTo(fileBackup)) {
                throw new IOException(I18n.tr((String)"Could not rename file!"));
            }
            this.fileFrom = fileBackup;
            this.fileTo = file;
            this.fileDelete = null;
        }

        private void chooseFilesNoBackup(File file) throws IOException {
            File fileTmp = File.createTempFile("img", ".jpg", file.getParentFile());
            if (!file.renameTo(fileTmp)) {
                throw new IOException(I18n.tr((String)"Could not rename file!"));
            }
            this.fileFrom = fileTmp;
            this.fileTo = file;
            this.fileDelete = fileTmp;
        }

        private void confirm_override() {
            if (this.override_backup == null) {
                JLabel l = new JLabel(I18n.tr((String)"<html><h3>There are old backup files in the image directory!</h3>"));
                l.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
                int override = new ExtendedDialog(Main.parent, I18n.tr((String)"Override old backup files?"), new String[]{I18n.tr((String)"Cancel"), I18n.tr((String)"Keep old backups and continue"), I18n.tr((String)"Override")}).setButtonIcons(new String[]{"cancel.png", "ok.png", "dialogs/delete.png"}).setContent((Component)l).setCancelButton(1).setDefaultButton(2).showDialog().getValue();
                if (override == 2) {
                    this.override_backup = false;
                } else if (override == 3) {
                    this.override_backup = true;
                } else {
                    this.cancelled = true;
                    return;
                }
            }
        }

        private void cleanupFiles() throws IOException {
            if (this.fileDelete != null && !this.fileDelete.delete()) {
                throw new IOException(I18n.tr((String)"Could not delete temporary file!"));
            }
        }

        protected void finish() {
        }

        protected void cancel() {
            this.cancelled = true;
        }
    }

    class GeotagImages
    implements ActionListener {
        private final GeoImageLayer layer;

        public GeotagImages(GeoImageLayer layer) {
            this.layer = layer;
        }

        public void actionPerformed(ActionEvent arg0) {
            ArrayList<ImageEntry> images = new ArrayList<ImageEntry>();
            for (ImageEntry e : this.layer.getImages()) {
                if (e.getPos() == null) continue;
                images.add(e);
            }
            JPanel cont = new JPanel(new GridBagLayout());
            cont.add((Component)new JLabel(I18n.tr((String)"Write position information into the exif header of the following files:")), GBC.eol());
            FileList files = new FileList();
            files.setVisibleRowCount(Math.min(files.getModel().getSize(), 10));
            ArrayList<String> strs = new ArrayList<String>();
            DecimalFormat cDdFormatter = new DecimalFormat("###0.000000");
            for (ImageEntry e : images) {
                strs.add(e.getFile().getAbsolutePath() + " (" + cDdFormatter.format(e.getPos().lat()) + "," + cDdFormatter.format(e.getPos().lon()) + ")");
            }
            files.getFileListModel().setFiles(strs);
            JScrollPane scroll = new JScrollPane(files);
            scroll.setPreferredSize(new Dimension(300, 250));
            cont.add((Component)scroll, GBC.eol().fill(1));
            JCheckBox backups = new JCheckBox(I18n.tr((String)"keep backup files"), Main.pref.getBoolean(GeotaggingPlugin.KEEP_BACKUP, true));
            cont.add((Component)backups, GBC.eol());
            int result = new ExtendedDialog(Main.parent, I18n.tr((String)"Photo Geotagging Plugin"), new String[]{I18n.tr((String)"OK"), I18n.tr((String)"Cancel")}).setButtonIcons(new String[]{"ok.png", "cancel.png"}).setContent((Component)cont).setCancelButton(2).setDefaultButton(1).showDialog().getValue();
            if (result != 1) {
                return;
            }
            boolean keep_backup = backups.isSelected();
            Main.pref.put(GeotaggingPlugin.KEEP_BACKUP, keep_backup);
            Main.worker.execute((Runnable)((Object)new GeoTaggingRunnable(images, keep_backup)));
        }
    }

    class GeotaggingMenuAddition
    implements GeoImageLayer.LayerMenuAddition {
        GeotaggingMenuAddition() {
        }

        public Component getComponent(Layer layer) {
            JMenuItem geotaggingItem = new JMenuItem(I18n.tr((String)"Write coordinates to image header"), ImageProvider.get((String)"geotagging"));
            geotaggingItem.addActionListener(new GeotagImages((GeoImageLayer)layer));
            return geotaggingItem;
        }
    }
}

