/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.photo_geotagging;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.Sanselan;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.formats.jpeg.JpegImageMetadata;
import org.apache.sanselan.formats.jpeg.exifRewrite.ExifRewriter;
import org.apache.sanselan.formats.tiff.TiffImageMetadata;
import org.apache.sanselan.formats.tiff.write.TiffOutputSet;
import org.openstreetmap.josm.tools.I18n;

public class ExifGPSTagger {
    public static void setExifGPSTag(File jpegImageFile, File dst, double lat, double lon) throws IOException {
        try {
            ExifGPSTagger.setExifGPSTagWorker(jpegImageFile, dst, lat, lon);
        }
        catch (ImageReadException ire) {
            throw new IOException(I18n.tr((String)"Read error!"));
        }
        catch (ImageWriteException ire2) {
            throw new IOException(I18n.tr((String)"Write error!"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setExifGPSTagWorker(File jpegImageFile, File dst, double lat, double lon) throws IOException, ImageReadException, ImageWriteException {
        OutputStream os = null;
        try {
            TiffImageMetadata exif;
            TiffOutputSet outputSet = null;
            IImageMetadata metadata = Sanselan.getMetadata(jpegImageFile);
            JpegImageMetadata jpegMetadata = (JpegImageMetadata)metadata;
            if (null != jpegMetadata && null != (exif = jpegMetadata.getExif())) {
                outputSet = exif.getOutputSet();
            }
            if (null == outputSet) {
                outputSet = new TiffOutputSet();
            }
            outputSet.setGPSInDegrees(lon, lat);
            os = new FileOutputStream(dst);
            os = new BufferedOutputStream(os);
            new ExifRewriter().updateExifMetadataLossless(jpegImageFile, os, outputSet);
            os.close();
            os = null;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

