/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Mercator;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.io.CacheFiles;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.ProgressInputStream;
import org.openstreetmap.josm.tools.I18n;
import wmsplugin.GeorefImage;
import wmsplugin.Grabber;
import wmsplugin.WMSLayer;

public class WMSGrabber
extends Grabber {
    protected String baseURL;
    private final boolean urlWithPatterns;
    public static final NumberFormat latLonFormat = new DecimalFormat("###0.0000000", new DecimalFormatSymbols(Locale.US));

    public static boolean isUrlWithPatterns(String url) {
        return url != null && url.contains("{") && url.contains("}");
    }

    WMSGrabber(ProjectionBounds b, GeorefImage image, MapView mv, WMSLayer layer, CacheFiles cache) {
        super(b, image, mv, layer, cache);
        this.baseURL = layer.baseURL;
        this.urlWithPatterns = WMSGrabber.isUrlWithPatterns(this.baseURL);
    }

    public void run() {
        this.attempt();
        this.mv.repaint();
    }

    void fetch() throws Exception {
        URL url = null;
        try {
            url = this.getURL(this.b.min.east(), this.b.min.north(), this.b.max.east(), this.b.max.north(), this.width(), this.height());
            this.image.min = this.b.min;
            this.image.max = this.b.max;
            if (this.image.isVisible((NavigatableComponent)this.mv, this.layer.getDx(), this.layer.getDy())) {
                this.image.image = this.grab(url);
                this.image.flushedResizedCachedInstance();
            }
            this.image.downloadingStarted = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(String.valueOf(e.getMessage()) + "\nImage couldn't be fetched: " + (url != null ? url.toString() : ""));
        }
    }

    protected URL getURL(double w, double s, double e, double n, int wi, int ht) throws MalformedURLException {
        String myProj = Main.proj.toCode();
        if (Main.proj instanceof Mercator) {
            LatLon sw = Main.proj.eastNorth2latlon(new EastNorth(w, s));
            LatLon ne = Main.proj.eastNorth2latlon(new EastNorth(e, n));
            myProj = "EPSG:4326";
            s = sw.lat();
            w = sw.lon();
            n = ne.lat();
            e = ne.lon();
        }
        String str = this.baseURL;
        String bbox = String.valueOf(latLonFormat.format(w)) + "," + latLonFormat.format(s) + "," + latLonFormat.format(e) + "," + latLonFormat.format(n);
        if (this.urlWithPatterns) {
            str = str.replaceAll("\\{proj\\}", myProj).replaceAll("\\{bbox\\}", bbox).replaceAll("\\{w\\}", latLonFormat.format(w)).replaceAll("\\{s\\}", latLonFormat.format(s)).replaceAll("\\{e\\}", latLonFormat.format(e)).replaceAll("\\{n\\}", latLonFormat.format(n)).replaceAll("\\{width\\}", String.valueOf(wi)).replaceAll("\\{height\\}", String.valueOf(ht));
        } else {
            str = String.valueOf(str) + "bbox=" + bbox + WMSGrabber.getProjection(this.baseURL, false) + "&width=" + wi + "&height=" + ht;
            if (!this.baseURL.endsWith("&") && !this.baseURL.endsWith("?")) {
                System.out.println(I18n.tr((String)"Warning: The base URL ''{0}'' for a WMS service doesn't have a trailing '&' or a trailing '?'.", (Object[])new Object[]{this.baseURL}));
                System.out.println(I18n.tr((String)"Warning: Fetching WMS tiles is likely to fail. Please check you preference settings."));
                System.out.println(I18n.tr((String)"Warning: The complete URL is ''{0}''.", (Object[])new Object[]{str}));
            }
        }
        return new URL(str.replace(" ", "%20"));
    }

    public static String getProjection(String baseURL, Boolean warn) {
        String projname = Main.proj.toCode();
        if (Main.proj instanceof Mercator) {
            projname = "EPSG:4326";
        }
        String res = "";
        try {
            Matcher m = Pattern.compile(".*srs=([a-z0-9:]+).*").matcher(baseURL.toLowerCase());
            if (m.matches()) {
                if (!(projname = projname.toLowerCase()).equals(m.group(1)) && warn.booleanValue()) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The projection ''{0}'' in URL and current projection ''{1}'' mismatch.\nThis may lead to wrong coordinates.", (Object[])new Object[]{m.group(1), projname}), I18n.tr((String)"Warning"), 2);
                }
            } else {
                res = "&srs=" + projname;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    public boolean loadFromCache() {
        URL url = null;
        try {
            url = this.getURL(this.b.min.east(), this.b.min.north(), this.b.max.east(), this.b.max.north(), this.width(), this.height());
        }
        catch (Exception e) {
            return false;
        }
        BufferedImage cached = this.cache.getImg(url.toString());
        if (!this.layer.hasAutoDownload() || cached != null) {
            this.image.min = this.b.min;
            this.image.max = this.b.max;
            if (cached == null) {
                this.grabNotInCache();
                return true;
            }
            this.image.image = cached;
            this.image.flushedResizedCachedInstance();
            this.image.downloadingStarted = false;
            return true;
        }
        return false;
    }

    protected BufferedImage grab(URL url) throws IOException, OsmTransferException {
        System.out.println("Grabbing WMS " + url);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (this.layer.cookies != null && !this.layer.cookies.equals("")) {
            conn.setRequestProperty("Cookie", this.layer.cookies);
        }
        conn.setConnectTimeout(Main.pref.getInteger("wmsplugin.timeout.connect", 30) * 1000);
        conn.setReadTimeout(Main.pref.getInteger("wmsplugin.timeout.read", 30) * 1000);
        String contentType = conn.getHeaderField("Content-Type");
        if (conn.getResponseCode() != 200 || contentType != null && !contentType.startsWith("image")) {
            throw new IOException(this.readException(conn));
        }
        ProgressInputStream is = new ProgressInputStream((URLConnection)conn, null);
        BufferedImage img = ImageIO.read((InputStream)is);
        is.close();
        this.cache.saveImg(url.toString(), img);
        return img;
    }

    protected String readException(URLConnection conn) throws IOException {
        StringBuilder exception = new StringBuilder();
        InputStream in = conn.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        String line = null;
        while ((line = br.readLine()) != null) {
            exception.append(line);
            exception.append('\n');
        }
        return exception.toString();
    }
}

