/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.routes.paint;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.openstreetmap.josm.plugins.routes.paint.PathPainter;

public abstract class AbstractLinePainter
implements PathPainter {
    protected boolean getLineLineIntersection(Line2D.Double l1, Line2D.Double l2, Point2D.Double intersection) {
        double x1 = l1.getX1();
        double y1 = l1.getY1();
        double x2 = l1.getX2();
        double y2 = l1.getY2();
        double x3 = l2.getX1();
        double y3 = l2.getY1();
        double x4 = l2.getX2();
        double y4 = l2.getY2();
        double ua = ((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) / ((y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1));
        intersection.x = x1 + ua * (x2 - x1);
        intersection.y = y1 + ua * (y2 - y1);
        return true;
    }

    protected double det(double a, double b, double c, double d) {
        return a * d - b * c;
    }

    protected Point2D shiftPoint(Point2D p1, Point2D p2, double shift) {
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        double ndx = -dy;
        double ndy = dx;
        double length = Math.sqrt(ndx * ndx + ndy * ndy);
        return new Point2D.Double(p1.getX() + shift * (ndx /= length), p1.getY() + shift * (ndy /= length));
    }

    protected Line2D.Double shiftLine(Point2D p1, Point2D p2, double shift) {
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        Point2D point1 = this.shiftPoint(p1, p2, shift);
        Point2D.Double point2 = new Point2D.Double(point1.getX() + dx, point1.getY() + dy);
        return new Line2D.Double(point1, point2);
    }
}

