/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import org.jgrapht.Graph;
import org.jgrapht.alg.AbstractPathElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BellmanFordPathElement<V, E>
extends AbstractPathElement<V, E> {
    private static final double epsilon = 1.0E-9;
    private double cost = 0.0;

    protected BellmanFordPathElement(Graph<V, E> graph, BellmanFordPathElement<V, E> bellmanFordPathElement, E e, double d) {
        super(graph, bellmanFordPathElement, e);
        this.cost = d;
    }

    BellmanFordPathElement(BellmanFordPathElement<V, E> bellmanFordPathElement) {
        super(bellmanFordPathElement);
        this.cost = bellmanFordPathElement.cost;
    }

    protected BellmanFordPathElement(V v) {
        super(v);
        this.cost = 0.0;
    }

    public double getCost() {
        return this.cost;
    }

    protected boolean improve(BellmanFordPathElement<V, E> bellmanFordPathElement, E e, double d) {
        if (d < this.getCost() - 1.0E-9) {
            this.prevPathElement = bellmanFordPathElement;
            this.prevEdge = e;
            this.cost = d;
            this.nHops = bellmanFordPathElement.getHopCount() + 1;
            return true;
        }
        return false;
    }
}

